/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsHistory {
    private final LoadTestStatistics statistics;
    private List<long[][]> data = new ArrayList<long[][]>();
    private List<Long> threadCounts = new ArrayList<Long>();
    private Map<Integer, TestStepStatisticsHistory> testStepStatisticHistories = new HashMap<Integer, TestStepStatisticsHistory>();
    private EnumMap<LoadTestStatistics.Statistic, StatisticsValueHistory> statisticsValueHistories = new EnumMap(LoadTestStatistics.Statistic.class);
    private static final Logger logger = Logger.getLogger(StatisticsHistory.class);
    private long resolution = 0L;
    private InternalTableModelListener internalTableModelListener = new InternalTableModelListener();
    private Updater updater = new Updater();

    public StatisticsHistory(LoadTestStatistics statistics) {
        this.statistics = statistics;
        statistics.addTableModelListener(this.internalTableModelListener);
        statistics.getLoadTest().addLoadTestRunListener(new LoadTestRunListenerAdapter(){

            public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
                if (StatisticsHistory.this.resolution > 0L) {
                    new Thread((Runnable)StatisticsHistory.this.updater, StatisticsHistory.this.statistics.getLoadTest().getName() + " StatisticsHistory Updater").start();
                }
            }
        });
    }

    public Map<Integer, TestStepStatisticsHistory> getTestStepStatisticHistories() {
        return this.testStepStatisticHistories;
    }

    public long getResolution() {
        return this.resolution;
    }

    public void setResolution(long resolution) {
        long old = this.resolution;
        this.resolution = resolution;
        if (resolution > 0L && old == 0L && this.statistics.getLoadTest().getHistoryLimit() != 0L) {
            new Thread((Runnable)this.updater, this.statistics.getLoadTest().getName() + " StatisticsHistory Updater").start();
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public long[][] getHistoryAt(int index) {
        return this.data.get(index);
    }

    public long getThreadCountAt(int index) {
        return this.threadCounts.get(index);
    }

    public StatisticsHistoryModel getTestStepHistory(int testStepIndex) {
        if (!this.testStepStatisticHistories.containsKey(testStepIndex)) {
            this.testStepStatisticHistories.put(testStepIndex, new TestStepStatisticsHistory(testStepIndex));
        }
        return this.testStepStatisticHistories.get(testStepIndex);
    }

    public StatisticsHistoryModel getStatisticsValueHistory(LoadTestStatistics.Statistic statistic) {
        if (!this.statisticsValueHistories.containsKey((Object)statistic)) {
            this.statisticsValueHistories.put(statistic, new StatisticsValueHistory(statistic));
        }
        return this.statisticsValueHistories.get((Object)statistic);
    }

    public void reset() {
        this.data.clear();
        this.threadCounts.clear();
        for (StatisticsValueHistory statisticsValueHistory : this.statisticsValueHistories.values()) {
            statisticsValueHistory.fireTableDataChanged();
            statisticsValueHistory.fireTableStructureChanged();
        }
        for (TestStepStatisticsHistory testStepStatisticsHistory : this.testStepStatisticHistories.values()) {
            testStepStatisticsHistory.fireTableDataChanged();
            testStepStatisticsHistory.fireTableStructureChanged();
        }
    }

    private synchronized void updateHistory() {
        if (this.statistics.getStatistic(-1, LoadTestStatistics.Statistic.COUNT) == 0L) {
            this.reset();
        } else {
            int columnCount = this.statistics.getColumnCount();
            int rowCount = this.statistics.getRowCount();
            long[][] values = new long[rowCount][columnCount - 2];
            for (int c = 0; c < rowCount; ++c) {
                for (int i = 2; i < columnCount; ++i) {
                    try {
                        values[c][i - 2] = Long.parseLong(this.statistics.getValueAt(c, i).toString());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        values[c][i - 2] = (long)Float.parseFloat(this.statistics.getValueAt(c, i).toString());
                    }
                }
            }
            this.data.add(values);
            this.threadCounts.add(this.statistics.getLoadTest().getThreadCount());
            int sz = this.data.size() - 1;
            for (StatisticsValueHistory statisticsValueHistory : this.statisticsValueHistories.values()) {
                statisticsValueHistory.fireTableRowsInserted(sz, sz);
            }
            for (TestStepStatisticsHistory testStepStatisticsHistory : this.testStepStatisticHistories.values()) {
                testStepStatisticsHistory.fireTableRowsInserted(sz, sz);
            }
        }
    }

    private final class Updater
    implements Runnable {
        private Updater() {
        }

        public void run() {
            WsdlLoadTest loadTest = StatisticsHistory.this.statistics.getLoadTest();
            while (StatisticsHistory.this.resolution > 0L && loadTest.isRunning()) {
                try {
                    long res;
                    if (loadTest.getHistoryLimit() != 0L) {
                        StatisticsHistory.this.updateHistory();
                    }
                    for (res = StatisticsHistory.this.resolution; res > 100L && StatisticsHistory.this.resolution > 0L && loadTest.isRunning(); res -= 100L) {
                        Thread.sleep(res);
                    }
                    if (StatisticsHistory.this.resolution <= 0L || !loadTest.isRunning()) continue;
                    Thread.sleep(res);
                }
                catch (InterruptedException e) {
                    SoapUI.logError(e);
                    break;
                }
            }
        }
    }

    private class InternalTableModelListener
    implements TableModelListener {
        private InternalTableModelListener() {
        }

        public synchronized void tableChanged(TableModelEvent e) {
            if (StatisticsHistory.this.resolution > 0L && StatisticsHistory.this.statistics.getLoadTest().isRunning() || e.getType() != 0 || StatisticsHistory.this.statistics.getLoadTest().getHistoryLimit() == 0L) {
                return;
            }
            StatisticsHistory.this.updateHistory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatisticsValueHistory
    extends StatisticsHistoryModel {
        private final LoadTestStatistics.Statistic statistic;

        public StatisticsValueHistory(LoadTestStatistics.Statistic statistic) {
            this.statistic = statistic;
        }

        public LoadTestStatistics.Statistic getStatistic() {
            return this.statistic;
        }

        @Override
        public int getRowCount() {
            return StatisticsHistory.this.data.size();
        }

        @Override
        public int getColumnCount() {
            return StatisticsHistory.this.statistics.getRowCount() + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return StatisticsHistory.this.threadCounts.get(rowIndex);
            }
            return ((long[][])StatisticsHistory.this.data.get(rowIndex))[columnIndex - 1][this.statistic.getIndex()];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Long.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "ThreadCount";
            }
            if (column == StatisticsHistory.this.statistics.getRowCount()) {
                return "Total";
            }
            return StatisticsHistory.this.statistics.getLoadTest().getTestCase().getTestStepAt(column - 1).getName();
        }

        @Override
        public void release() {
            StatisticsHistory.this.statisticsValueHistories.remove((Object)this.statistic);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestStepStatisticsHistory
    extends StatisticsHistoryModel {
        private final int testStepIndex;

        public TestStepStatisticsHistory(int testStepIndex) {
            this.testStepIndex = testStepIndex == -1 ? StatisticsHistory.this.statistics.getRowCount() - 1 : testStepIndex;
        }

        public int getTestStepIndex() {
            return this.testStepIndex;
        }

        @Override
        public int getRowCount() {
            return StatisticsHistory.this.data.size();
        }

        @Override
        public int getColumnCount() {
            return StatisticsHistory.this.statistics.getColumnCount() - 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return StatisticsHistory.this.threadCounts.get(rowIndex);
            }
            if (rowIndex < StatisticsHistory.this.data.size()) {
                return ((long[][])StatisticsHistory.this.data.get(rowIndex))[this.testStepIndex][columnIndex - 1];
            }
            return new Long(0L);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Long.class;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "ThreadCount" : LoadTestStatistics.Statistic.forIndex(column - 1).getName();
        }

        @Override
        public void release() {
            StatisticsHistory.this.testStepStatisticHistories.remove(this.testStepIndex);
        }
    }

    public abstract class StatisticsHistoryModel
    extends AbstractTableModel {
        public abstract void release();
    }
}

