/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.request;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AddWSSUsernameTokenAction
extends AbstractAction {
    private final WsdlRequest request;

    public AddWSSUsernameTokenAction(WsdlRequest request) {
        super("Add WSS Username Token");
        this.request = request;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(this.request.getUsername() != null && this.request.getUsername().length() != 0 || this.request.getPassword() != null && this.request.getPassword().length() != 0)) {
            UISupport.showErrorMessage("Request is missing username and password");
            return;
        }
        String req = this.request.getRequestContent();
        try {
            String passwordType = UISupport.prompt("Add WSS Username Token", "Specify Password Type", new String[]{"PasswordText", "PasswordDigest"});
            if (passwordType == null) {
                return;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(req)));
            WSSecUsernameToken addUsernameToken = new WSSecUsernameToken();
            if ("PasswordDigest".equals(passwordType)) {
                addUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            } else {
                addUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            }
            addUsernameToken.setUserInfo(this.request.getUsername(), this.request.getPassword());
            addUsernameToken.addNonce();
            addUsernameToken.addCreated();
            StringWriter writer = new StringWriter();
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            XmlUtils.serializePretty(addUsernameToken.build(doc, secHeader), (Writer)writer);
            this.request.setRequestContent(writer.toString());
        }
        catch (Exception e1) {
            UISupport.showErrorMessage(e1);
        }
    }
}

