/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.request;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.CompressedStringConfig;
import com.eviware.soapui.config.MockResponseStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.support.AbstractAddToTestCaseAction;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlMockResponseStepFactory;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRequestAsMockResponseStepAction
extends AbstractAddToTestCaseAction<WsdlRequest> {
    public static final String SOAPUI_ACTION_ID = "AddRequestAsMockResponseStepAction";
    private XFormDialog dialog;

    public AddRequestAsMockResponseStepAction() {
        super("Add as MockResponse Step", "Creates a MockResponseStep from this Request");
    }

    @Override
    public void perform(WsdlRequest request, Object param) {
        WsdlTestCase testCase = this.getTargetTestCase(request.getOperation().getInterface().getProject());
        if (testCase != null) {
            this.addMockResponse(testCase, request);
        }
    }

    protected boolean addMockResponse(WsdlTestCase testCase, WsdlRequest request) {
        String response;
        String title = this.getName();
        boolean create = false;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        WsdlOperation operation = request.getOperation();
        this.dialog.setValue("Name", operation.getName());
        this.dialog.setBooleanValue("Close Request Window", true);
        this.dialog.setBooleanValue("Shows TestCase Editor", true);
        this.dialog.setIntValue("Port", 8181);
        this.dialog.setValue("Path", "/" + operation.getName());
        SoapUIDesktop desktop = SoapUI.getDesktop();
        this.dialog.getFormField("Close Request Window").setEnabled(desktop != null && desktop.hasDesktopPanel(request));
        if (!this.dialog.show()) {
            return false;
        }
        TestStepConfig config = WsdlMockResponseStepFactory.createConfig(operation, request, false);
        MockResponseStepConfig mockResponseStepConfig = (MockResponseStepConfig)config.getConfig();
        config.setName(this.dialog.getValue("Name"));
        mockResponseStepConfig.setPath(this.dialog.getValue("Path"));
        mockResponseStepConfig.setPort(this.dialog.getIntValue("Port", 8181));
        CompressedStringConfig responseContent = mockResponseStepConfig.getResponse().getResponseContent();
        if (request.getResponse() == null && !request.getOperation().isOneWay()) {
            create = UISupport.confirm("Request is missing response, create default mock response instead?", title);
        }
        if (create) {
            response = operation.createResponse(operation.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS));
            CompressedStringSupport.setString(responseContent, response);
        } else if (request.getResponse() != null) {
            response = request.getResponse().getContentAsString();
            CompressedStringSupport.setString(responseContent, response);
        }
        WsdlMockResponseTestStep testStep = (WsdlMockResponseTestStep)testCase.addTestStep(config);
        if (this.dialog.getBooleanValue("Add Schema Assertion")) {
            testStep.addAssertion("Schema Compliance");
        }
        UISupport.selectAndShow(testStep);
        if (this.dialog.getBooleanValue("Close Request Window") && desktop != null) {
            desktop.closeDesktopPanel(request);
        }
        if (this.dialog.getBooleanValue("Shows TestCase Editor")) {
            UISupport.selectAndShow(testCase);
        }
        return true;
    }

    @AForm(name="Add MockResponse to TestCase", description="Options for adding this requests response to a TestCase", helpUrl="http://www.soapui.org/userguide/functional/mockresponse.html", icon="/preferences-system.png")
    private static interface Form {
        @AField(name="Name", description="Unique name of MockResponse Step")
        public static final String STEP_NAME = "Name";
        @AField(name="Path", description="Path to listen on")
        public static final String PATH = "Path";
        @AField(name="Port", description="Port to listen on", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(name="Add Schema Assertion", description="Adds SchemaCompliance Assertion for request", type=AField.AFieldType.BOOLEAN)
        public static final String ADD_SCHEMA_ASSERTION = "Add Schema Assertion";
        @AField(name="Close Request Window", description="Closes the request editor if visible", type=AField.AFieldType.BOOLEAN)
        public static final String CLOSE_REQUEST = "Close Request Window";
        @AField(name="Shows TestCase Editor", description="Shows the target steps TestCase editor", type=AField.AFieldType.BOOLEAN)
        public static final String SHOW_TESTCASE = "Shows TestCase Editor";
    }
}

