/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.tcpmon;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpMonAction
extends AbstractToolsAction<WsdlInterface> {
    private static final String ENDPOINT = "Endpoint";
    private static final String PORT = "Local Port";
    private static final String ADD_ENDPOINT = "Add local endpoint";
    private XForm mainForm;
    public static final String SOAPUI_ACTION_ID = "TcpMonAction";

    public TcpMonAction() {
        super("Launch TcpMon", "Launch Tcp Mon for monitoring SOAP traffic");
    }

    @Override
    protected XFormDialog buildDialog(WsdlInterface modelItem) {
        if (modelItem == null) {
            return null;
        }
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Launch TcpMon");
        this.mainForm = builder.createForm("Basic");
        this.mainForm.addComboBox(ENDPOINT, new String[]{""}, "endpoint to forward to");
        this.mainForm.addTextField(PORT, "Local port to listen on.", XForm.FieldType.TEXT);
        this.mainForm.addCheckBox(ADD_ENDPOINT, "adds an endpoint to the interface pointing to the started monitor");
        return builder.buildDialog(this.buildDefaultActions("http://ws.apache.org/commons/tcpmon/", modelItem), "Specify arguments for launching TcpMon", UISupport.TOOL_ICON);
    }

    @Override
    protected Action createRunOption(WsdlInterface modelItem) {
        Action action = super.createRunOption(modelItem);
        action.putValue("Name", "Launch");
        return action;
    }

    @Override
    protected StringToStringMap initValues(WsdlInterface modelItem, Object param) {
        if (modelItem != null) {
            ArrayList<String> endpoints = new ArrayList<String>(Arrays.asList(modelItem.getEndpoints()));
            endpoints.add(0, null);
            this.mainForm.setOptions(ENDPOINT, endpoints.toArray());
        } else if (this.mainForm != null) {
            this.mainForm.setOptions(ENDPOINT, new String[]{null});
        }
        StringToStringMap values = super.initValues(modelItem, param);
        if (!values.isEmpty()) {
            return values;
        }
        values.put(ENDPOINT, this.getDefinition(modelItem));
        values.put(PORT, "8080");
        return values;
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, WsdlInterface modelItem) throws Exception {
        String tcpMonDir = SoapUI.getSettings().getString(ToolsSettings.TCPMON_LOCATION, null);
        if (Tools.isEmpty(tcpMonDir)) {
            UISupport.showErrorMessage("TcpMon directory must be set in global preferences");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(modelItem);
        builder.command(args.getArgs());
        builder.directory(new File(tcpMonDir + File.separatorChar + "build"));
        SoapUI.log("Launching tcpmon in directory [" + builder.directory() + "] with arguments [" + args.toString() + "]");
        builder.start();
        this.closeDialog(modelItem);
    }

    private ArgumentBuilder buildArgs(WsdlInterface modelItem) throws IOException {
        if (this.dialog == null) {
            ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
            builder.startScript("tcpmon", ".bat", ".sh");
            return builder;
        }
        StringToStringMap values = this.dialog.getValues();
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript("tcpmon", ".bat", ".sh");
        builder.addArgs((String)values.get(PORT));
        String endpoint = (String)values.get(ENDPOINT);
        if (endpoint != null && !endpoint.equals("- none available -")) {
            URL url = new URL(endpoint);
            builder.addArgs(url.getHost());
            builder.addArgs(url.getPort() == -1 ? "80" : "" + url.getPort());
            if (values.getBoolean(ADD_ENDPOINT)) {
                modelItem.addEndpoint("http://localhost:" + (String)values.get(PORT) + url.getPath());
            }
        }
        this.addToolArgs(values, builder);
        return builder;
    }
}

