/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.panels;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpXmlRequestDesktopPanel<T extends ModelItem, T2 extends HttpRequestInterface<?>>
extends AbstractHttpRequestDesktopPanel<T, T2> {
    public AbstractHttpXmlRequestDesktopPanel(T modelItem, T2 requestItem) {
        super(modelItem, requestItem);
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        return new HttpRequestMessageEditor((HttpRequestInterface)this.getRequest());
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new HttpResponseMessageEditor((HttpRequestInterface)this.getRequest());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpResponseDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        private final HttpRequestInterface<?> modelItem;

        public HttpResponseDocument(HttpRequestInterface<?> modelItem) {
            this.modelItem = modelItem;
            modelItem.addPropertyChangeListener(RestRequestInterface.RESPONSE_PROPERTY, this);
        }

        public HttpRequestInterface<?> getRequest() {
            return this.modelItem;
        }

        @Override
        public String getXml() {
            return this.modelItem.getResponseContentAsXml();
        }

        @Override
        public void setXml(String xml) {
            HttpResponse response = this.getRequest().getResponse();
            if (response != null) {
                response.setResponseContent(xml);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireXmlChanged(evt.getOldValue() == null ? null : ((HttpResponse)evt.getOldValue()).getContentAsString(), this.getXml());
        }

        @Override
        public void release() {
            super.release();
            this.modelItem.removePropertyChangeListener(RestRequestInterface.RESPONSE_PROPERTY, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpRequestDocument
    extends AbstractXmlDocument
    implements PropertyChangeListener {
        private final HttpRequestInterface<?> modelItem;
        private boolean updating;

        public HttpRequestDocument(HttpRequestInterface<?> modelItem) {
            this.modelItem = modelItem;
            modelItem.addPropertyChangeListener(this);
        }

        public HttpRequestInterface<?> getRequest() {
            return this.modelItem;
        }

        @Override
        public String getXml() {
            return this.getRequest().getRequestContent();
        }

        @Override
        public void release() {
            super.release();
            this.modelItem.removePropertyChangeListener(this);
        }

        @Override
        public void setXml(String xml) {
            if (!this.updating) {
                this.updating = true;
                this.getRequest().setRequestContent(xml);
                this.updating = false;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("request") && !this.updating) {
                this.updating = true;
                this.fireXmlChanged((String)evt.getOldValue(), (String)evt.getNewValue());
                this.updating = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpResponseMessageEditor
    extends AbstractHttpRequestDesktopPanel.AbstractHttpResponseMessageEditor<HttpResponseDocument> {
        public HttpResponseMessageEditor(HttpRequestInterface<?> modelItem) {
            super((AbstractHttpRequestDesktopPanel)AbstractHttpXmlRequestDesktopPanel.this, (XmlDocument)new HttpResponseDocument(modelItem));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class HttpRequestMessageEditor
    extends AbstractHttpRequestDesktopPanel.AbstractHttpRequestMessageEditor<HttpRequestDocument> {
        public HttpRequestMessageEditor(HttpRequestInterface<?> modelItem) {
            super((AbstractHttpRequestDesktopPanel)AbstractHttpXmlRequestDesktopPanel.this, (XmlDocument)new HttpRequestDocument(modelItem));
        }
    }
}

