/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestParamsTableModel
extends AbstractTableModel
implements TableModel,
TestPropertyListener {
    protected RestParamsPropertyHolder params;

    public RestParamsTableModel(RestParamsPropertyHolder params) {
        this.params = params;
        params.addTestPropertyListener(this);
    }

    public void release() {
        this.params.removeTestPropertyListener(this);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Default value";
            }
            case 2: {
                return "Style";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex < 2 ? String.class : RestParamsPropertyHolder.ParameterStyle.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.params.getPropertyCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RestParamProperty prop = this.params.getPropertyAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return prop.getName();
            }
            case 1: {
                return prop.getDefaultValue();
            }
            case 2: {
                return prop.getStyle();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        RestParamProperty prop = this.params.getPropertyAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                this.params.renameProperty(prop.getName(), value.toString());
                return;
            }
            case 1: {
                prop.setDefaultValue(value.toString());
                prop.setValue(value.toString());
                return;
            }
            case 2: {
                prop.setStyle((RestParamsPropertyHolder.ParameterStyle)((Object)value));
                return;
            }
        }
    }

    public RestParamProperty getParameterAt(int selectedRow) {
        return this.params.getPropertyAt(selectedRow);
    }

    @Override
    public void propertyAdded(String name) {
        this.fireTableDataChanged();
    }

    @Override
    public void propertyRemoved(String name) {
        this.fireTableDataChanged();
    }

    @Override
    public void propertyRenamed(String oldName, String newName) {
        this.fireTableDataChanged();
    }

    @Override
    public void propertyValueChanged(String name, String oldValue, String newValue) {
        this.fireTableCellUpdated(this.params.getPropertyIndex(name), 1);
    }

    @Override
    public void propertyMoved(String name, int oldIndex, int newIndex) {
        this.fireTableDataChanged();
    }

    public void setParams(RestParamsPropertyHolder params) {
        this.params.removeTestPropertyListener(this);
        this.params = params;
        this.params.addTestPropertyListener(this);
        this.fireTableDataChanged();
    }
}

