/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.components.StringListFormComponent;
import com.jgoodies.binding.PresentationModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;

public class RestParamsTable
extends JPanel {
    protected RestParamsPropertyHolder params;
    protected RestParamsTableModel paramsTableModel;
    protected JTable paramsTable;
    protected AddParamAction addParamAction = new AddParamAction();
    protected RemoveParamAction removeParamAction = new RemoveParamAction();
    protected ClearParamsAction clearParamsAction = new ClearParamsAction();
    protected UseDefaultParamsAction defaultParamsAction = new UseDefaultParamsAction();
    protected MovePropertyDownAction movePropertyDownAction = new MovePropertyDownAction();
    protected MovePropertyUpAction movePropertyUpAction = new MovePropertyUpAction();
    protected UpdateParamsAction updateParamsAction = new UpdateParamsAction();
    private PresentationModel<RestParamProperty> paramDetailsModel;
    private StringListFormComponent optionsFormComponent;
    private SimpleBindingForm detailsForm;

    public RestParamsTable(RestParamsPropertyHolder params, boolean showInspector) {
        super(new BorderLayout());
        this.params = params;
        this.init(params, showInspector);
    }

    protected RestParamsTableModel createTableModel(RestParamsPropertyHolder params) {
        return new RestParamsTableModel(params);
    }

    protected void init(RestParamsPropertyHolder params, boolean showInspector) {
        this.paramsTableModel = this.createTableModel(params);
        this.paramsTable = new JTable(this.paramsTableModel);
        this.paramsTable.setRowHeight(19);
        this.paramsTable.setSelectionMode(0);
        this.paramsTable.setDefaultEditor(RestParamsPropertyHolder.ParameterStyle.class, new DefaultCellEditor(new JComboBox<Object>(new Object[]{RestParamsPropertyHolder.ParameterStyle.QUERY, RestParamsPropertyHolder.ParameterStyle.TEMPLATE, RestParamsPropertyHolder.ParameterStyle.HEADER, RestParamsPropertyHolder.ParameterStyle.MATRIX, RestParamsPropertyHolder.ParameterStyle.PLAIN})));
        this.paramsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = RestParamsTable.this.paramsTable.getSelectedRow();
                RestParamsTable.this.removeParamAction.setEnabled(selectedRow != -1);
                RestParamsTable.this.movePropertyDownAction.setEnabled(selectedRow < RestParamsTable.this.paramsTable.getRowCount() - 1);
                RestParamsTable.this.movePropertyUpAction.setEnabled(selectedRow > 0);
                if (selectedRow != -1) {
                    RestParamProperty selectedParameter = RestParamsTable.this.getSelectedParameter();
                    if (RestParamsTable.this.paramDetailsModel != null) {
                        RestParamsTable.this.paramDetailsModel.setBean((Object)selectedParameter);
                        RestParamsTable.this.detailsForm.setEnabled(true);
                    }
                } else if (RestParamsTable.this.paramDetailsModel != null) {
                    RestParamsTable.this.detailsForm.setEnabled(false);
                    RestParamsTable.this.paramDetailsModel.setBean(null);
                }
            }
        });
        this.add(this.buildToolbar(), "North");
        if (showInspector) {
            final JSplitPane splitPane = UISupport.createVerticalSplit(new JScrollPane(this.paramsTable), this.buildDetails());
            this.add((Component)splitPane, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    splitPane.setDividerLocation(0.5);
                }
            });
        } else {
            this.add((Component)new JScrollPane(this.paramsTable), "Center");
        }
    }

    private JComponent buildDetails() {
        this.paramDetailsModel = new PresentationModel(null);
        this.detailsForm = new SimpleBindingForm(this.paramDetailsModel);
        this.detailsForm.addSpace(5);
        this.detailsForm.appendCheckBox("required", "Required", "Sets if parameter is required");
        ArrayList<QName> types = new ArrayList<QName>();
        for (SchemaType type : XmlBeans.getBuiltinTypeSystem().globalTypes()) {
            types.add(type.getName());
        }
        this.detailsForm.appendComboBox("type", "Type", types.toArray(), "The type of the parameter");
        this.optionsFormComponent = new StringListFormComponent("Available values for this Parameter");
        this.optionsFormComponent.setPreferredSize(new Dimension(350, 80));
        this.detailsForm.appendComponent("options", "Options", this.optionsFormComponent);
        this.detailsForm.appendTextField("description", "Description", "A short description of the parameter");
        this.detailsForm.appendCheckBox("disableUrlEncoding", "Disable Encoding", "Disables URL-Encoding of the parameter value");
        this.detailsForm.addSpace(5);
        this.detailsForm.setEnabled(false);
        return new JScrollPane(this.detailsForm.getPanel());
    }

    protected RestParamProperty getSelectedParameter() {
        return this.paramsTable.getSelectedRow() == -1 ? null : this.paramsTableModel.getParameterAt(this.paramsTable.getSelectedRow());
    }

    public JTable getParamsTable() {
        return this.paramsTable;
    }

    public void release() {
        this.paramsTableModel.release();
        if (this.paramDetailsModel != null) {
            this.paramDetailsModel.setBean(null);
        }
    }

    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(UISupport.createToolbarButton(this.addParamAction));
        toolbar.add(UISupport.createToolbarButton(this.removeParamAction, false));
        toolbar.add(UISupport.createToolbarButton(this.clearParamsAction, this.paramsTable.getRowCount() > 0));
        toolbar.addSeparator();
        toolbar.add(UISupport.createToolbarButton(this.movePropertyDownAction, false));
        toolbar.add(UISupport.createToolbarButton(this.movePropertyUpAction, false));
        toolbar.addSeparator();
        toolbar.add(UISupport.createToolbarButton(this.updateParamsAction));
        toolbar.addSeparator();
        this.insertAdditionalButtons(toolbar);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/rest/params.html")));
        return toolbar;
    }

    protected void insertAdditionalButtons(JXToolBar toolbar) {
    }

    public void setParams(RestParamsPropertyHolder params) {
        this.params = params;
        this.paramsTableModel.setParams(params);
    }

    public void refresh() {
        this.paramsTableModel.fireTableDataChanged();
    }

    private class MovePropertyDownAction
    extends AbstractAction {
        public MovePropertyDownAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/down_arrow.gif"));
            this.putValue("ShortDescription", "Moves selected parameter down one row");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int ix = RestParamsTable.this.paramsTable.getSelectedRow();
            if (ix != -1) {
                RestParamsTable.this.params.moveProperty(RestParamsTable.this.params.getPropertyAt(ix).getName(), ix + 1);
                RestParamsTable.this.paramsTable.setRowSelectionInterval(ix + 1, ix + 1);
            }
        }
    }

    private class MovePropertyUpAction
    extends AbstractAction {
        public MovePropertyUpAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/up_arrow.gif"));
            this.putValue("ShortDescription", "Moves selected parameter up one row");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int ix = RestParamsTable.this.paramsTable.getSelectedRow();
            if (ix != -1) {
                RestParamsTable.this.params.moveProperty(RestParamsTable.this.params.getPropertyAt(ix).getName(), ix - 1);
                RestParamsTable.this.paramsTable.setRowSelectionInterval(ix - 1, ix - 1);
            }
        }
    }

    private class UseDefaultParamsAction
    extends AbstractAction {
        public UseDefaultParamsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/default_properties.gif"));
            this.putValue("ShortDescription", "Reverts all current parameters to default values");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Revert all parameters to default values?", "Use Defaults")) {
                for (TestProperty property : RestParamsTable.this.params.getProperties().values()) {
                    property.setValue(null);
                }
            }
        }
    }

    private class ClearParamsAction
    extends AbstractAction {
        public ClearParamsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_properties.gif"));
            this.putValue("ShortDescription", "Clears all current parameter values");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Clear all parameter values?", "Clear Parameters")) {
                RestParamsTable.this.params.clear();
            }
        }
    }

    private class RemoveParamAction
    extends AbstractAction {
        public RemoveParamAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected parameter");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = RestParamsTable.this.paramsTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            UISupport.stopCellEditing(RestParamsTable.this.paramsTable);
            String propertyName = RestParamsTable.this.paramsTableModel.getValueAt(row, 0).toString();
            if (UISupport.confirm("Remove parameter [" + propertyName + "]?", "Remove Parameter")) {
                RestParamsTable.this.paramsTable.clearSelection();
                RestParamsTable.this.params.removeProperty(propertyName);
                RestParamsTable.this.clearParamsAction.setEnabled(RestParamsTable.this.params.getPropertyCount() > 0);
            }
        }
    }

    private class UpdateParamsAction
    extends AbstractAction {
        private UpdateParamsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Updates params from a specified URL");
        }

        public void actionPerformed(ActionEvent e) {
            String str = UISupport.prompt("Enter new url below", "Extract Params", "");
            if (str == null) {
                return;
            }
            try {
                RestParamsTable.this.params.resetValues();
                RestUtils.extractParams(str, RestParamsTable.this.params, false);
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private class AddParamAction
    extends AbstractAction {
        public AddParamAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a parameter to the parameter table");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify parameter name", "Add Parameter", "");
            if (StringUtils.hasContent(name)) {
                RestParamsTable.this.params.addProperty(name);
                final int row = RestParamsTable.this.params.getPropertyNames().length - 1;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RestParamsTable.this.requestFocusInWindow();
                        RestParamsTable.this.scrollRectToVisible(RestParamsTable.this.paramsTable.getCellRect(row, 1, true));
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                RestParamsTable.this.paramsTable.editCellAt(row, 1);
                                RestParamsTable.this.paramsTable.getEditorComponent().requestFocusInWindow();
                            }
                        });
                    }
                });
                RestParamsTable.this.clearParamsAction.setEnabled(true);
            }
        }
    }
}

