/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class ProxyPrefs
implements Prefs {
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String USERNAME = "Username";
    public static final String PASSWORD = "Password";
    public static final String EXCLUDES = "Excludes";
    public static final String ENABLE_PROXY = "Enable Proxy";
    private JTextField hostTextField;
    private JTextField portTextField;
    private JCheckBox enableProxyCheckbox;
    private SimpleForm proxyPrefForm;
    private final String title;

    public ProxyPrefs(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public SimpleForm getForm() {
        if (this.proxyPrefForm == null) {
            this.proxyPrefForm = new SimpleForm();
            this.proxyPrefForm.addSpace(5);
            this.hostTextField = this.proxyPrefForm.appendTextField(HOST, "proxy host to use");
            this.hostTextField.getDocument().addDocumentListener(new ProxyDocumentListenerAdapter());
            this.portTextField = this.proxyPrefForm.appendTextField(PORT, "proxy port to use");
            this.portTextField.getDocument().addDocumentListener(new ProxyDocumentListenerAdapter());
            this.proxyPrefForm.appendTextField(USERNAME, "proxy username to use");
            this.proxyPrefForm.appendTextField(PASSWORD, "proxy password to use");
            this.proxyPrefForm.appendTextField(EXCLUDES, "Comma-seperated list of hosts to exclude");
            this.enableProxyCheckbox = this.proxyPrefForm.appendCheckBox(ENABLE_PROXY, "enable using proxy", true);
        }
        return this.proxyPrefForm;
    }

    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.proxyPrefForm.getValues(values);
        this.storeValues(values, settings);
    }

    public StringToStringMap getValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        values.put(HOST, settings.getString(ProxySettings.HOST, ""));
        values.put(PORT, settings.getString(ProxySettings.PORT, ""));
        values.put(USERNAME, settings.getString(ProxySettings.USERNAME, ""));
        values.put(PASSWORD, settings.getString(ProxySettings.PASSWORD, ""));
        values.put(EXCLUDES, settings.getString(ProxySettings.EXCLUDES, ""));
        values.put(ENABLE_PROXY, settings.getBoolean(ProxySettings.ENABLE_PROXY));
        ProxyUtils.setProxyEnabled(settings.getBoolean(ProxySettings.ENABLE_PROXY));
        return values;
    }

    public void setFormValues(Settings settings) {
        this.getForm().setValues(this.getValues(settings));
    }

    public void storeValues(StringToStringMap values, Settings settings) {
        settings.setString(ProxySettings.HOST, (String)values.get(HOST));
        settings.setString(ProxySettings.PORT, (String)values.get(PORT));
        settings.setString(ProxySettings.USERNAME, (String)values.get(USERNAME));
        settings.setString(ProxySettings.PASSWORD, (String)values.get(PASSWORD));
        settings.setString(ProxySettings.EXCLUDES, (String)values.get(EXCLUDES));
        settings.setBoolean(ProxySettings.ENABLE_PROXY, values.getBoolean(ENABLE_PROXY));
        JButton applyProxyButton = SoapUI.getApplyProxyButton();
        if (values.getBoolean(ENABLE_PROXY)) {
            if (applyProxyButton != null) {
                applyProxyButton.setIcon(UISupport.createImageIcon("/proxyEnabled.png"));
            }
            ProxyUtils.setProxyEnabled(true);
        } else {
            if (applyProxyButton != null) {
                applyProxyButton.setIcon(UISupport.createImageIcon("/proxyDisabled.png"));
            }
            ProxyUtils.setProxyEnabled(false);
        }
    }

    private class ProxyDocumentListenerAdapter
    extends DocumentListenerAdapter {
        private ProxyDocumentListenerAdapter() {
        }

        public void update(Document document) {
            ProxyPrefs.this.enableProxyCheckbox.setSelected(!StringUtils.isNullOrEmpty(ProxyPrefs.this.hostTextField.getText()) && !StringUtils.isNullOrEmpty(ProxyPrefs.this.portTextField.getText()));
        }
    }
}

