/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.pdfbox.ExtractText;

public class PDFToTextTask
extends Task {
    private List fileSets = new ArrayList();

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void execute() {
        this.log("PDFToTextTask executing");
        for (FileSet next : this.fileSets) {
            DirectoryScanner dirScanner = next.getDirectoryScanner(this.getProject());
            dirScanner.scan();
            String[] files = dirScanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = new File(dirScanner.getBasedir(), files[i]);
                this.log("processing: " + f.getAbsolutePath());
                String pdfFile = f.getAbsolutePath();
                if (!pdfFile.toUpperCase().endsWith(".PDF")) continue;
                String textFile = pdfFile.substring(0, pdfFile.length() - 3);
                textFile = textFile + "txt";
                try {
                    ExtractText.main(new String[]{pdfFile, textFile});
                    continue;
                }
                catch (Exception e) {
                    this.log("Error processing " + pdfFile + e.getMessage());
                }
            }
        }
    }
}

