/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureFaking;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import wsattacker.library.signatureFaking.exceptions.ConfigurationException;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class XmlMessageSigner {
    private KeyStore keyStore;
    private String keyAlias;
    private char[] password;
    private static final String DEFAULT_NAMESPACE_PREFIX = "ds";
    private String signatureNamespacePrefix = "ds";

    public String signMessage(String message, String signedElementId, boolean useEnvelopedTransform, String signatureParent, String signatureSibling) throws ConfigurationException {
        try {
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            LinkedList<Transform> transforms = new LinkedList<Transform>();
            if (useEnvelopedTransform) {
                transforms.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            }
            transforms.add(fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null));
            Reference ref = fac.newReference(signedElementId, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transforms, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.keyAlias, new KeyStore.PasswordProtection(this.password));
            X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            ArrayList<Object> x509Content = new ArrayList<Object>(2);
            x509Content.add(cert.getSubjectX500Principal().getName());
            x509Content.add(cert);
            X509Data xd = kif.newX509Data(x509Content);
            KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(message.getBytes()));
            XmlMessageSigner.setAllIdAttributesInDocument(doc, "Id");
            XmlMessageSigner.setAllIdAttributesInDocument(doc, "ID");
            DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)doc.getDocumentElement());
            dsc.setDefaultNamespacePrefix(this.signatureNamespacePrefix);
            List nl1 = DomUtilities.evaluateXPath((Document)doc, (String)("//*[local-name()=\"" + signatureParent + "\"]"));
            List nl2 = DomUtilities.evaluateXPath((Document)doc, (String)("//*[local-name()=\"" + signatureSibling + "\"]"));
            System.out.println(nl1.get(0));
            System.out.println(nl2.get(0));
            dsc.setParent((Node)nl1.get(0));
            dsc.setNextSibling((Node)nl2.get(0));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            signature.sign(dsc);
            String result = DomUtilities.domToString((Document)doc);
            return result;
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | MarshalException | XMLSignatureException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean verifyMessage(String message) throws SAXException, MarshalException, XMLSignatureException, XPathExpressionException {
        Document doc = DomUtilities.stringToDom((String)message);
        XmlMessageSigner.setAllIdAttributesInDocument(doc, "Id");
        XmlMessageSigner.setAllIdAttributesInDocument(doc, "ID");
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }
        boolean valid = true;
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        for (int i = 0; i < nl.getLength(); ++i) {
            DOMValidateContext valContext = new DOMValidateContext(new X509KeySelector(), nl.item(i));
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            System.out.println("Signature " + i + "validity: " + coreValidity);
            if (coreValidity) continue;
            valid = false;
        }
        return valid;
    }

    public static void setAllIdAttributesInDocument(Document doc, String idName) throws XPathExpressionException {
        List result = DomUtilities.evaluateXPath((Document)doc, (String)("//*/@" + idName));
        for (int i = 0; i < result.size(); ++i) {
            Attr attribute = (Attr)result.get(i);
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }

    public String getSignatureNamespacePrefix() {
        return this.signatureNamespacePrefix;
    }

    public void setSignatureNamespacePrefix(String signatureNamespacePrefix) {
        this.signatureNamespacePrefix = signatureNamespacePrefix;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public class X509KeySelector
    extends KeySelector {
        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure info : keyInfo.getContent()) {
                if (!(info instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)info;
                for (Object o : x509Data.getContent()) {
                    if (!(o instanceof X509Certificate)) continue;
                    final PublicKey key = ((X509Certificate)o).getPublicKey();
                    if (!this.algEquals(method.getAlgorithm(), key.getAlgorithm())) continue;
                    return new KeySelectorResult(){

                        @Override
                        public Key getKey() {
                            return key;
                        }
                    };
                }
            }
            throw new KeySelectorException("No key found!");
        }

        boolean algEquals(String algURI, String algName) {
            return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

