/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.signatureWrapping.option;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.gui.util.XmlTextPane;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.util.signature.SignatureManager;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.wrapping.WrappingOracle;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.plugin.signatureWrapping.SignatureWrapping;
import wsattacker.plugin.signatureWrapping.option.OptionViewButton;

public class OptionViewButtonGUI
extends OptionGUI {
    private SignatureWrapping signateWrappingPlugin;
    private static final long serialVersionUID = 1L;
    private JEditorPane name;
    private JEditorPane description;
    private JLabel maxPossibilitiesLabel;
    private JButton closeButton;
    private JScrollPane jScrollPane1;
    private XmlTextPane xml;
    private JTextArea logLabel;
    private JLabel headline;
    private JLabel ofLabel;
    private JFormattedTextField directChooser;
    private JSlider possibilitySwitcher;
    private JDialog viewDialog;
    private JButton viewButton;
    private JScrollPane descriptionScrollPane;
    private JScrollPane nameScrollPane;
    private WrappingOracle wrappingOracle;
    private AbstractOption option;

    public OptionViewButtonGUI(AbstractPlugin plugin, OptionViewButton option) {
        this.option = option;
        this.signateWrappingPlugin = (SignatureWrapping)plugin;
        GroupLayout thisLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(thisLayout);
        this.viewButton = new JButton();
        this.viewButton.setText("View");
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.out.println("viewButton.actionPerformed, event=" + evt);
                OptionViewButtonGUI.this.getViewDialog().setVisible(true);
            }
        });
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionScrollPane.setVerticalScrollBarPolicy(21);
        this.descriptionScrollPane.setHorizontalScrollBarPolicy(31);
        this.descriptionScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nameScrollPane = new JScrollPane();
        this.nameScrollPane.setHorizontalScrollBarPolicy(31);
        this.nameScrollPane.setVerticalScrollBarPolicy(21);
        this.nameScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.name = new JEditorPane();
        this.nameScrollPane.setViewportView(this.name);
        this.name.setPreferredSize(new Dimension(85, 16));
        this.name.setBackground(this.getBackground());
        this.name.setText(plugin.getName());
        this.description = new JEditorPane();
        this.description.setFont(new Font("Dialog", 2, 12));
        this.description.setBackground(this.getBackground());
        this.description.setText(option.getDescription());
        this.description.setEditable(false);
        thisLayout.setHorizontalGroup(thisLayout.createSequentialGroup().addContainerGap().addComponent(this.nameScrollPane, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(thisLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, thisLayout.createSequentialGroup().addGap(174, 174, 174).addComponent(this.viewButton, -2, 70, -2).addGap(10)).addComponent(this.descriptionScrollPane, GroupLayout.Alignment.LEADING, 0, 254, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, thisLayout.createSequentialGroup().addComponent(this.description, 0, 242, Short.MAX_VALUE).addGap(0, 12, -2))));
        thisLayout.setVerticalGroup(thisLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, thisLayout.createSequentialGroup().addComponent(this.viewButton, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, -2).addComponent(this.description, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionScrollPane, -2, 21, -2)).addComponent(this.nameScrollPane, GroupLayout.Alignment.LEADING, 0, 85, Short.MAX_VALUE));
        this.setPreferredSize(new Dimension(369, 66));
    }

    public JDialog getViewDialog() {
        this.createWrappingOracle();
        if (this.viewDialog == null) {
            this.viewDialog = new JDialog();
            GroupLayout viewDialogLayout = new GroupLayout(this.viewDialog.getContentPane());
            this.viewDialog.getContentPane().setLayout(viewDialogLayout);
            this.viewDialog.setPreferredSize(new Dimension(740, 591));
            this.headline = new JLabel();
            this.headline.setText("View Wrapping Possibilites");
            this.headline.setHorizontalAlignment(0);
            this.headline.setFont(new Font("Arial", 1, 14));
            this.possibilitySwitcher = new JSlider();
            this.possibilitySwitcher.setMinimum(1);
            this.possibilitySwitcher.setPaintTicks(true);
            this.possibilitySwitcher.setPaintLabels(false);
            this.possibilitySwitcher.setSnapToTicks(false);
            this.possibilitySwitcher.setMinorTickSpacing(1);
            this.possibilitySwitcher.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    try {
                        int value = OptionViewButtonGUI.this.possibilitySwitcher.getValue();
                        OptionViewButtonGUI.this.directChooser.setText(String.format("%d", value));
                        OptionViewButtonGUI.this.showPossibility(value);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            });
            this.directChooser = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.directChooser.setText("1");
            this.directChooser.setHorizontalAlignment(11);
            this.directChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    try {
                        int value = Integer.parseInt(OptionViewButtonGUI.this.directChooser.getText());
                        if (value != OptionViewButtonGUI.this.possibilitySwitcher.getValue()) {
                            OptionViewButtonGUI.this.possibilitySwitcher.setValue(value);
                        }
                        OptionViewButtonGUI.this.showPossibility(value);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            });
            this.ofLabel = new JLabel();
            this.ofLabel.setText("of");
            this.viewDialog.setSize(740, 591);
            viewDialogLayout.setHorizontalGroup(viewDialogLayout.createSequentialGroup().addContainerGap().addGroup(viewDialogLayout.createParallelGroup().addGroup(GroupLayout.Alignment.LEADING, viewDialogLayout.createSequentialGroup().addComponent(this.directChooser, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ofLabel, -2, 18, -2).addComponent(this.getMaxPossibilitiesLabel(), -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(viewDialogLayout.createParallelGroup().addComponent(this.getLogLabel(), GroupLayout.Alignment.LEADING, 0, 555, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, viewDialogLayout.createSequentialGroup().addGap(0, 466, Short.MAX_VALUE).addComponent(this.getCloseButton(), -2, 89, -2)))).addComponent(this.possibilitySwitcher, GroupLayout.Alignment.LEADING, 0, 716, Short.MAX_VALUE).addComponent(this.headline, GroupLayout.Alignment.LEADING, 0, 716, Short.MAX_VALUE).addComponent(this.getJScrollPane1(), GroupLayout.Alignment.LEADING, 0, 716, Short.MAX_VALUE)).addContainerGap());
            viewDialogLayout.setVerticalGroup(viewDialogLayout.createSequentialGroup().addContainerGap().addComponent(this.headline, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.possibilitySwitcher, -2, 46, -2).addGroup(viewDialogLayout.createParallelGroup().addComponent(this.getLogLabel(), GroupLayout.Alignment.LEADING, -2, 64, -2).addGroup(viewDialogLayout.createSequentialGroup().addGap(12).addGroup(viewDialogLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directChooser, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.ofLabel, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.getMaxPossibilitiesLabel(), GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(30))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getJScrollPane1(), 0, 391, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getCloseButton(), -2, -2, -2).addContainerGap());
        }
        this.initView();
        return this.viewDialog;
    }

    public JSlider getPossibilitySwitcher() {
        return this.possibilitySwitcher;
    }

    public JFormattedTextField getDirectChooser() {
        return this.directChooser;
    }

    public void bindingDoUnbind() {
    }

    public AbstractOption getUsedOption() {
        return this.option;
    }

    private JTextArea getLogLabel() {
        if (this.logLabel == null) {
            this.logLabel = new JTextArea();
            this.logLabel.setText("LOG");
            this.logLabel.setOpaque(false);
            this.logLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.logLabel.setEditable(false);
        }
        return this.logLabel;
    }

    public XmlTextPane getXml() {
        if (this.xml == null) {
            this.xml = new XmlTextPane();
            this.xml.setText("xml");
        }
        return this.xml;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView((Component)this.getXml());
        }
        return this.jScrollPane1;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    System.out.println("closeButton.actionPerformed, event=" + evt);
                    OptionViewButtonGUI.this.getViewDialog().dispose();
                }
            });
        }
        return this.closeButton;
    }

    public JLabel getMaxPossibilitiesLabel() {
        if (this.maxPossibilitiesLabel == null) {
            this.maxPossibilitiesLabel = new JLabel();
            this.maxPossibilitiesLabel.setText("12345");
        }
        return this.maxPossibilitiesLabel;
    }

    private void showPossibility(int value) throws Exception {
        String message = DomUtilities.domToString((Document)this.wrappingOracle.getPossibility(value - 1));
        this.getXml().setText(message);
        this.logLabel.setText(WeaknessLog.representation());
        this.logLabel.setSize(this.logLabel.getPreferredSize());
    }

    private void createWrappingOracle() {
        SignatureManager sm = this.signateWrappingPlugin.getSignatureManager();
        SchemaAnalyzer sa = this.signateWrappingPlugin.getUsedSchemaAnalyser();
        this.wrappingOracle = new WrappingOracle(sm.getDocument(), sm.getPayloads(), sa);
    }

    private void initView() {
        int max = this.wrappingOracle.maxPossibilities();
        if (max > 0) {
            this.getPossibilitySwitcher().setMinimum(1);
            this.getPossibilitySwitcher().setMaximum(max + 1);
            this.getPossibilitySwitcher().setValue(1);
            this.getPossibilitySwitcher().setMinorTickSpacing((max + 1) / 10);
            this.getMaxPossibilitiesLabel().setText(String.format("%d", max + 1));
            this.getPossibilitySwitcher().setEnabled(true);
            this.getXml().setEnabled(true);
        } else {
            this.getPossibilitySwitcher().setMinimum(0);
            this.getPossibilitySwitcher().setMaximum(0);
            this.getPossibilitySwitcher().setMinorTickSpacing(1);
            this.getPossibilitySwitcher().setEnabled(false);
            this.getXml().setText("No possibilites available");
            this.getXml().setEnabled(false);
            this.logLabel.setText("");
        }
    }
}

