/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.signatureWrapping.option;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.gui.component.pluginconfiguration.composition.OptionGUI;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.plugin.signatureWrapping.gui.OptionPayloadGUI_NB;

public class OptionPayload
extends AbstractOption
implements PropertyChangeListener {
    public static final String PROP_PAYLOAD = "payload";
    private static final Logger LOG = Logger.getLogger(OptionPayload.class);
    private final Payload payload;
    public static final String PROP_VALUE = "value";
    public static final String PROP_WORKINGXPATH = "workingXPath";

    public String getValue() {
        return this.payload == null ? "" : this.payload.getValue();
    }

    public OptionPayload(Payload payload) {
        super("Payload Option", "This payload will be placed at the position of the signed element.");
        if (payload.getSignedElement() != null) {
            String name = String.format("Payload for %s", payload.getSignedElement().getNodeName());
            this.setName(name);
            String description = DomUtilities.getFastXPath((Node)payload.getSignedElement());
            this.setDescription(description);
        }
        this.payload = payload;
        payload.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean hasPayload() {
        return this.payload == null ? false : this.payload.hasPayload();
    }

    public boolean isTimestamp() {
        return this.payload == null ? false : this.payload.isTimestamp();
    }

    public void setTimestamp(boolean isTimestamp) {
        this.payload.setTimestamp(isTimestamp);
    }

    public boolean isValid(String value) {
        return this.payload.isValid(value);
    }

    public OptionGUI createOptionGUI() {
        LOG.trace((Object)(this.getName() + ": " + "GUI Requested"));
        return new OptionPayloadGUI_NB(this);
    }

    public void parseValue(String value) {
        this.setValue(value);
    }

    public void setValue(String value) {
        boolean isValid = this.isValid(value);
        if (!isValid) {
            throw new IllegalArgumentException(String.format("isValid(\"%s\" returned false", value));
        }
        String oldValue = this.getValue();
        this.payload.setValue(value);
        String newValue = this.getValue();
        this.firePropertyChange(PROP_VALUE, oldValue, newValue);
        LOG.info((Object)String.format("Saving Payload Value: %s", newValue));
    }

    public String getValueAsString() {
        return this.getValue();
    }

    public String getWorkingXPath() {
        String result = this.payload != null && this.payload.getReferringElement() != null ? this.payload.getReferringElement().getXPath() : "";
        return result;
    }

    public void setWorkingXPath(String workingXPath) {
        String oldWorkingXPath = this.getWorkingXPath();
        this.payload.getReferringElement().setXPath(workingXPath);
        this.firePropertyChange(PROP_WORKINGXPATH, oldWorkingXPath, workingXPath);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String property = pce.getPropertyName();
        if ("timestamp".equals(property)) {
            this.firePropertyChange(pce);
        } else if ("payloadElement".equals(property)) {
            String oldValue = DomUtilities.domToString((Node)((Element)pce.getOldValue()));
            String newValue = DomUtilities.domToString((Node)((Element)pce.getNewValue()));
            this.firePropertyChange(PROP_VALUE, oldValue, newValue);
        }
    }
}

