/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.signatureWrapping.function.postanalyze.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import wsattacker.gui.util.XmlTextPane;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.plugin.signatureWrapping.SignatureWrapping;
import wsattacker.plugin.signatureWrapping.function.postanalyze.model.AnalysisData;
import wsattacker.plugin.signatureWrapping.function.postanalyze.model.AnalysisDataCollector;

public class AnalysisDialog
extends JDialog {
    public static final String PROP_SIGNATUREWRAPPINGPLUGIN = "signatureWrappingPlugin";
    private SignatureWrapping signatureWrappingPlugin;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JList indexList;
    private JSplitPane leftRightSplitPane;
    private JScrollPane listScrollPane;
    private JTextPane logPane;
    private JScrollPane logScrollPane1;
    private XmlTextPane requestPane;
    private JScrollPane requestScrollPane;
    private JComboBox responseChooser;
    private XmlTextPane responsePane;
    private JScrollPane responseScrollPane;
    private JLabel title;
    private JSplitPane topDownSplitPane;

    public AnalysisDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.title = new JLabel();
        this.responseChooser = new JComboBox();
        this.listScrollPane = new JScrollPane();
        this.indexList = new JList();
        this.topDownSplitPane = new JSplitPane();
        this.leftRightSplitPane = new JSplitPane();
        this.requestScrollPane = new JScrollPane();
        this.requestPane = new XmlTextPane();
        this.responseScrollPane = new JScrollPane();
        this.responsePane = new XmlTextPane();
        this.logScrollPane1 = new JScrollPane();
        this.logPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.title.setText("Signature Wrapping Analysis");
        this.responseChooser.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.responseChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AnalysisDialog.this.responseChooserItemStateChanged(evt);
            }
        });
        this.indexList.setModel(new DefaultListModel());
        this.indexList.setSelectionMode(0);
        this.indexList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AnalysisDialog.this.indexListValueChanged(evt);
            }
        });
        this.listScrollPane.setViewportView(this.indexList);
        this.topDownSplitPane.setOrientation(0);
        this.leftRightSplitPane.setDividerLocation(0.5);
        this.requestScrollPane.setViewportView((Component)this.requestPane);
        this.leftRightSplitPane.setLeftComponent(this.requestScrollPane);
        this.responseScrollPane.setViewportView((Component)this.responsePane);
        this.leftRightSplitPane.setRightComponent(this.responseScrollPane);
        this.topDownSplitPane.setBottomComponent(this.leftRightSplitPane);
        this.logPane.setEditable(false);
        this.logPane.setBackground(this.getBackground());
        this.logPane.setFocusable(false);
        this.logPane.setRequestFocusEnabled(false);
        this.logScrollPane1.setViewportView(this.logPane);
        this.topDownSplitPane.setLeftComponent(this.logScrollPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.title, -1, 563, Short.MAX_VALUE).addComponent(this.responseChooser, 0, -1, Short.MAX_VALUE).addComponent(this.topDownSplitPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listScrollPane, -2, 100, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.listScrollPane, -1, 461, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.title, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.responseChooser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.topDownSplitPane))).addContainerGap()));
        this.pack();
    }

    private void responseChooserItemStateChanged(ItemEvent evt) {
        if (this.signatureWrappingPlugin != null && this.responseChooser.getSelectedIndex() >= 0) {
            DefaultListModel model = (DefaultListModel)this.indexList.getModel();
            model.removeAllElements();
            AnalysisDataCollector dataCollector = this.signatureWrappingPlugin.getAnalysisData();
            String key = (String)this.responseChooser.getSelectedItem();
            for (AnalysisData data : dataCollector.getDataEntry(key)) {
                model.addElement(data.getIndex() + 1);
            }
        }
    }

    private void indexListValueChanged(ListSelectionEvent evt) {
        if (this.signatureWrappingPlugin != null && this.signatureWrappingPlugin.getWrappingOracle() != null && this.indexList.getSelectedIndex() >= 0) {
            Integer index = (Integer)this.indexList.getSelectedValue() - 1;
            try {
                this.logPane.setText(WeaknessLog.representation());
                Document wrappingPossibility = this.signatureWrappingPlugin.getWrappingOracle().getPossibility(index.intValue());
                this.requestPane.setText(DomUtilities.domToString((Document)wrappingPossibility));
                String key = (String)this.responseChooser.getSelectedItem();
                String response = this.signatureWrappingPlugin.getAnalysisData().getDataEntry(key).get(this.indexList.getSelectedIndex()).getResponse();
                this.responsePane.setText(response);
            }
            catch (InvalidWeaknessException ex) {
                Logger.getLogger(AnalysisDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NullPointerException e) {
                Logger.getLogger(AnalysisDialog.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AnalysisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AnalysisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AnalysisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AnalysisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnalysisDialog dialog = new AnalysisDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public SignatureWrapping getSignatureWrappingPlugin() {
        return this.signatureWrappingPlugin;
    }

    public void setSignatureWrappingPlugin(SignatureWrapping signatureWrappingPlugin) {
        SignatureWrapping oldSignatureWrappingPlugin = signatureWrappingPlugin;
        this.signatureWrappingPlugin = signatureWrappingPlugin;
        this.responseChooser.removeAllItems();
        for (String key : signatureWrappingPlugin.getAnalysisData().getData().keySet()) {
            this.responseChooser.addItem(key);
        }
        if (this.responseChooser.getItemCount() > 0) {
            this.responseChooser.setSelectedIndex(0);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_SIGNATUREWRAPPINGPLUGIN, (Object)oldSignatureWrappingPlugin, (Object)signatureWrappingPlugin);
    }
}

