/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.maven2;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.tools.SoapUIToolRunner;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ToolMojo
extends AbstractMojo {
    private String projectFile;
    private String tool;
    private String iface;
    private String settingsFile;
    private String projectPassword;
    private String settingsPassword;
    private String outputFolder;
    private Properties soapuiProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        SoapUIToolRunner runner = new SoapUIToolRunner("SoapUI " + SoapUI.SOAPUI_VERSION + " Maven2 Tool Runner");
        runner.setProjectFile(this.projectFile);
        if (this.iface != null) {
            runner.setInterface(this.iface);
        }
        if (this.tool != null) {
            runner.setTool(this.tool);
        }
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.outputFolder != null) {
            runner.setOutputFolder(this.outputFolder);
        }
        if (this.soapuiProperties != null && this.soapuiProperties.size() > 0) {
            for (Object key : this.soapuiProperties.keySet()) {
                System.out.println("Setting " + (String)key + " value " + this.soapuiProperties.getProperty((String)key));
                System.setProperty((String)key, this.soapuiProperties.getProperty((String)key));
            }
        }
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoFailureException((Object)this, "SoapUI Tool(s) failed", e.getMessage());
        }
    }
}

