/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.maven2;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.tools.SoapUILoadTestRunner;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LoadTestMojo
extends AbstractMojo {
    private String projectFile;
    private String testSuite;
    private String testCase;
    private String loadTest;
    private String username;
    private String password;
    private String wssPasswordType;
    private String domain;
    private String host;
    private String endpoint;
    private Integer limit;
    private Integer threadCount;
    private String outputFolder;
    private boolean printReport;
    private String settingsFile;
    private boolean skip;
    private String projectPassword;
    private String settingsPassword;
    private String[] globalProperties;
    private String[] projectProperties;
    private boolean saveAfterRun;
    private Properties soapuiProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            return;
        }
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        SoapUILoadTestRunner runner = new SoapUILoadTestRunner("SoapUI " + SoapUI.SOAPUI_VERSION + " Maven2 LoadTest Runner");
        runner.setProjectFile(this.projectFile);
        if (this.endpoint != null) {
            runner.setEndpoint(this.endpoint);
        }
        if (this.testSuite != null) {
            runner.setTestSuite(this.testSuite);
        }
        if (this.testCase != null) {
            runner.setTestCase(this.testCase);
        }
        if (this.loadTest != null) {
            runner.setLoadTest(this.loadTest);
        }
        if (this.username != null) {
            runner.setUsername(this.username);
        }
        if (this.password != null) {
            runner.setPassword(this.password);
        }
        if (this.wssPasswordType != null) {
            runner.setWssPasswordType(this.wssPasswordType);
        }
        if (this.domain != null) {
            runner.setDomain(this.domain);
        }
        if (this.limit != null) {
            runner.setLimit(this.limit.intValue());
        }
        if (this.threadCount != null) {
            runner.setThreadCount((long)this.threadCount.intValue());
        }
        if (this.host != null) {
            runner.setHost(this.host);
        }
        if (this.outputFolder != null) {
            runner.setOutputFolder(this.outputFolder);
        }
        runner.setPrintReport(this.printReport);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.soapuiProperties != null && this.soapuiProperties.size() > 0) {
            for (Object key : this.soapuiProperties.keySet()) {
                System.out.println("Setting " + (String)key + " value " + this.soapuiProperties.getProperty((String)key));
                System.setProperty((String)key, this.soapuiProperties.getProperty((String)key));
            }
        }
        try {
            runner.run();
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoFailureException((Object)this, "SoapUI LoadTest(s) failed", e.getMessage());
        }
    }
}

