/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.worker;

import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import wsattacker.library.intelligentdos.IntelligentDoSLibrary;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestObject;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.plugin.intelligentdos.listener.AttackModelChangeListener;
import wsattacker.plugin.intelligentdos.listener.AttackPerformedListener;
import wsattacker.plugin.intelligentdos.listener.RecentTestProbeListener;
import wsattacker.plugin.intelligentdos.model.ResultModel;
import wsattacker.plugin.intelligentdos.threads.ExecuteRequestsThread;
import wsattacker.plugin.intelligentdos.threads.TestProbeThread;

public class IntelligentDoSWorker
implements RecentTestProbeListener {
    private static final int MIN = 5;
    private static final int MAX = 25;
    private final IntelligentDoSLibrary intelligentDoSLibrary;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final List<AttackModelChangeListener> changedListeners = Lists.newArrayList();
    private final List<AttackPerformedListener> performedListeners = Lists.newArrayList();
    private boolean abort = false;
    private boolean finished = true;
    private int count = 0;
    private Date start;
    private Date stop;
    private TestProbeThread testProbeThread;

    public IntelligentDoSWorker(IntelligentDoSLibrary intelligentDoSLibrary) {
        this.intelligentDoSLibrary = intelligentDoSLibrary;
    }

    public void startAttack(RequestResponsePair original) {
        this.finished = false;
        this.start = new Date();
        Map<String, String> headerMap = this.createHttpHeaderMap(original.getWsdlResponse());
        RequestObject testProbeRO = new RequestObject(this.intelligentDoSLibrary.getTestProbeContent(), original.getWsdlRequest().getEndpoint(), headerMap);
        this.testProbeThread = new TestProbeThread(testProbeRO);
        this.testProbeThread.addListener(this);
        this.testProbeThread.start();
        int i = 5;
        while (!this.abort && this.intelligentDoSLibrary.hasFurtherAttack()) {
            if (this.count % i == 0) {
                this.logger.debug((Object)("\tattack " + (this.count + 1) + " start: " + new Date()));
            }
            AttackModel attackModel = this.intelligentDoSLibrary.nextAttack();
            this.fireModelChanged(attackModel);
            try {
                if (attackModel.getServerRecoveryBeforeSend() != 0) {
                    this.logger.trace((Object)("Server Recovery: " + attackModel.getServerRecoveryBeforeSend() + "!"));
                    Thread.sleep(attackModel.getServerRecoveryBeforeSend());
                }
                String content = attackModel.getRequestContent();
                RequestObject requestObject = new RequestObject(content, original.getWsdlRequest().getEndpoint(), headerMap);
                this.sendAttack(attackModel, requestObject);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)e.toString(), (Throwable)e);
            }
            if (this.count % i == 0) {
                this.logger.debug((Object)("\tattack " + (this.count + 1) + " stop: " + new Date()));
            }
            ++this.count;
            this.intelligentDoSLibrary.update(attackModel);
            this.fireAttackPerformed(this.count - 1, attackModel);
        }
        this.testProbeThread.interrupt();
        this.stop = new Date();
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ResultModel getResult() {
        ResultModel resultModel = new ResultModel(this.intelligentDoSLibrary.getSuccessfulAttacks());
        resultModel.setStartDate(this.start);
        resultModel.setStopDate(this.stop);
        resultModel.setNotPossible(this.intelligentDoSLibrary.getNotPossible());
        resultModel.setThresholds(this.intelligentDoSLibrary.getThresholds());
        resultModel.setMaximumRequestsPerSecond(this.intelligentDoSLibrary.getMaximumRequestsPerSecond());
        return resultModel;
    }

    private void sendAttack(AttackModel attackModel, RequestObject requestObject) throws InterruptedException {
        ExecutorThread executorThread = new ExecutorThread(attackModel, requestObject);
        executorThread.start();
        executorThread.join();
    }

    public int getCount() {
        return this.count;
    }

    private void fireModelChanged(AttackModel attackModel) {
        for (AttackModelChangeListener listener : this.changedListeners) {
            listener.attackModelChanged(attackModel);
        }
    }

    private void fireAttackPerformed(int count, AttackModel attackModel) {
        for (AttackPerformedListener listener : this.performedListeners) {
            listener.attackPerformed(count, attackModel);
        }
    }

    public void addListener(AttackModelChangeListener attackModelChangeListener) {
        this.changedListeners.add(attackModelChangeListener);
    }

    public void removeListener(AttackModelChangeListener attackModelChangeListener) {
        this.changedListeners.remove(attackModelChangeListener);
    }

    public void addListener(AttackPerformedListener attackPerformedListener) {
        this.performedListeners.add(attackPerformedListener);
    }

    public void removeListener(AttackPerformedListener attackPerformedListener) {
        this.performedListeners.remove(attackPerformedListener);
    }

    @Override
    public void recentTestProbe(Metric metric) {
        this.intelligentDoSLibrary.updateTestProbes(metric);
    }

    public void stopAttack() {
        this.testProbeThread.interrupt();
        this.abort = true;
        this.finished = true;
    }

    private Map<String, String> createHttpHeaderMap(WsdlResponse wsdlResponse) {
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        StringToStringsMap originalHeaders = wsdlResponse.getRequestHeaders();
        for (Map.Entry entry : originalHeaders.entrySet()) {
            for (String value : (List)entry.getValue()) {
                httpHeaderMap.put((String)entry.getKey(), value);
            }
        }
        return httpHeaderMap;
    }

    private static class ExecutorThread
    extends Thread {
        private final AttackModel attackModel;
        private final RequestObject requestObject;
        private final int numberOfThreads;
        private final int numberOfRequests;
        private final int secondsBetweenRequests;
        private final Random random = new Random();

        ExecutorThread(AttackModel attackModel, RequestObject requestObject) {
            this.attackModel = attackModel;
            this.requestObject = requestObject;
            this.numberOfThreads = attackModel.getNumberOfThreads();
            this.numberOfRequests = attackModel.getNumberOfRequests();
            this.secondsBetweenRequests = attackModel.getMilliesBetweenRequests();
        }

        @Override
        public void run() {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            try {
                int delay = 5 + this.random.nextInt(21);
                for (int threadNumber = 0; threadNumber < this.numberOfThreads; ++threadNumber) {
                    Thread thread = new ExecuteRequestsThread(this.attackModel, this.requestObject, this.numberOfRequests, this.secondsBetweenRequests);
                    thread.start();
                    threads.add(thread);
                    Thread.sleep(delay);
                }
                for (Thread thread : threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                Logger.getLogger(this.getClass()).warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

