/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.ui.dialog;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import wsattacker.library.intelligentdos.common.SuccessfulAttack;
import wsattacker.library.intelligentdos.position.Position;
import wsattacker.plugin.intelligentdos.model.ResultModel;
import wsattacker.plugin.intelligentdos.ui.controller.ResultButtonController;
import wsattacker.plugin.intelligentdos.ui.helper.ChartHelper;
import wsattacker.plugin.intelligentdos.ui.helper.FormatHelper;
import wsattacker.plugin.intelligentdos.ui.renderer.EfficiencyRenderer;

public class Result_NB
extends JFrame {
    private static final String FILE_EXT_ZIP = "zip";
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final DecimalFormat df = new DecimalFormat(".00");
    private final JFreeChart chart;
    private final transient ResultButtonController btnController;
    private final transient List<SuccessfulAttack> attacks;
    private JPanel attackMetadataPanel;
    private JPanel attackSuccessMetricPanel;
    private JPanel chartPanel1;
    private JPanel chartPanel2;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTree resultTree;
    private JButton saveBtn;
    private JLabel successMetric;

    public Result_NB(String title, ResultModel resultModel) {
        super(title);
        this.attacks = resultModel.getAttacks();
        this.btnController = new ResultButtonController(resultModel);
        this.chart = ChartHelper.createDumyChart();
        this.initComponents();
        this.resultTree.getSelectionModel().setSelectionMode(1);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.resultTree = new JTree();
        this.attackMetadataPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.attackSuccessMetricPanel = new JPanel();
        this.successMetric = new JLabel();
        this.chartPanel1 = new ChartPanel(this.chart);
        this.chartPanel2 = new ChartPanel(this.chart);
        this.saveBtn = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.resultTree.setBorder(BorderFactory.createTitledBorder("Successful attacks"));
        this.resultTree.setModel(this.createModel());
        this.resultTree.setCellRenderer(new EfficiencyRenderer());
        this.resultTree.setRootVisible(false);
        this.resultTree.setShowsRootHandles(true);
        this.resultTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Result_NB.this.resultTreeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.resultTree);
        this.attackMetadataPanel.setBorder(BorderFactory.createTitledBorder("Attack metadata"));
        this.jLabel1.setVerticalAlignment(1);
        GroupLayout attackMetadataPanelLayout = new GroupLayout(this.attackMetadataPanel);
        this.attackMetadataPanel.setLayout(attackMetadataPanelLayout);
        attackMetadataPanelLayout.setHorizontalGroup(attackMetadataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 400, Short.MAX_VALUE));
        attackMetadataPanelLayout.setVerticalGroup(attackMetadataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 200, Short.MAX_VALUE));
        this.attackSuccessMetricPanel.setBorder(BorderFactory.createTitledBorder("Attack success metric"));
        this.successMetric.setVerticalAlignment(1);
        GroupLayout attackSuccessMetricPanelLayout = new GroupLayout(this.attackSuccessMetricPanel);
        this.attackSuccessMetricPanel.setLayout(attackSuccessMetricPanelLayout);
        attackSuccessMetricPanelLayout.setHorizontalGroup(attackSuccessMetricPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.successMetric, -1, 400, Short.MAX_VALUE));
        attackSuccessMetricPanelLayout.setVerticalGroup(attackSuccessMetricPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.successMetric, -1, 92, Short.MAX_VALUE));
        GroupLayout chartPanel1Layout = new GroupLayout(this.chartPanel1);
        this.chartPanel1.setLayout(chartPanel1Layout);
        chartPanel1Layout.setHorizontalGroup(chartPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 408, Short.MAX_VALUE));
        chartPanel1Layout.setVerticalGroup(chartPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 206, Short.MAX_VALUE));
        this.chartPanel1.setPreferredSize(new Dimension(412, 200));
        GroupLayout chartPanel2Layout = new GroupLayout(this.chartPanel2);
        this.chartPanel2.setLayout(chartPanel2Layout);
        chartPanel2Layout.setHorizontalGroup(chartPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        chartPanel2Layout.setVerticalGroup(chartPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 164, Short.MAX_VALUE));
        this.chartPanel2.setPreferredSize(new Dimension(412, 200));
        this.saveBtn.setText("Save Results");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Result_NB.this.saveBtnActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("XML with placeholder"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 100, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 227, -2).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.saveBtn))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.attackMetadataPanel, -1, -1, Short.MAX_VALUE).addComponent(this.attackSuccessMetricPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chartPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.chartPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 376, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn)).addGroup(layout.createSequentialGroup().addComponent(this.chartPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chartPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.attackMetadataPanel, -2, -1, -2).addGap(3, 3, 3).addComponent(this.attackSuccessMetricPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            int checker = fileChooser.showOpenDialog(null);
            if (checker == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String message = "The selected file already exists.\nOverwrite?";
                if (!selectedFile.exists() || JOptionPane.showConfirmDialog(this, message, "Save result", 0) == 0) {
                    if (!FilenameUtils.getExtension((String)selectedFile.getName()).equalsIgnoreCase(FILE_EXT_ZIP)) {
                        selectedFile = new File(selectedFile.getAbsoluteFile() + "." + FILE_EXT_ZIP);
                    }
                    this.btnController.save(selectedFile);
                    JOptionPane.showMessageDialog(this, "Result has been saved to filesystem.");
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler beim Schreiben", 0);
            this.logger.warn((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resultTreeValueChanged(TreeSelectionEvent evt) {
        JTree tree = (JTree)evt.getSource();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (selectedNode != null && selectedNode.isLeaf()) {
            SuccessfulAttack sa = (SuccessfulAttack)selectedNode.getUserObject();
            this.jLabel1.setText(FormatHelper.toHTML(sa));
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            String format = "-";
            if (!Double.isNaN(sa.getRatio())) {
                format = df.format(sa.getRatio());
            }
            builder.append("Attack roundtrip time ratio: ").append(format);
            builder.append("<br />");
            builder.append("the payload is ").append(sa.getEfficiency().name());
            builder.append("<br />");
            builder.append("<br />");
            double reuqestsPerSecond = (double)((int)(sa.getParamItem().getReuqestsPerSecond() * 100.0)) / 100.0;
            builder.append(reuqestsPerSecond).append(" requests per second were sent");
            builder.append("<br />");
            if (sa.getTamperedContent() != null) {
                long l = (long)((double)sa.getTamperedContent().getBytes(Charset.forName("UTF-8")).length * sa.getParamItem().getReuqestsPerSecond());
                builder.append("the traffic was (approx) ").append(FileUtils.byteCountToDisplaySize((long)l)).append(" per second");
            }
            builder.append("</html>");
            this.successMetric.setText(builder.toString());
            this.jTextArea1.setText(sa.getXmlWithPlaceholder());
            JFreeChart createOverlaidChart = ChartHelper.createOverlaidChart(sa);
            JFreeChart createWhiskerChart = ChartHelper.createWhiskerChart(sa);
            ((ChartPanel)this.chartPanel1).setChart(createOverlaidChart);
            ((ChartPanel)this.chartPanel2).setChart(createWhiskerChart);
        } else {
            this.jLabel1.setText("");
            this.successMetric.setText("");
        }
    }

    private TreeModel createModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        HashSet<String> dosAttackNameSet = new HashSet<String>();
        HashSet<Position> elementSet = new HashSet<Position>();
        for (SuccessfulAttack sa : this.attacks) {
            dosAttackNameSet.add(sa.getDoSAttack().getName());
            elementSet.add(sa.getPosition());
        }
        for (String dosAttackName : dosAttackNameSet) {
            DefaultMutableTreeNode dn = new DefaultMutableTreeNode(dosAttackName);
            root.add(dn);
            for (Position position : elementSet) {
                DefaultMutableTreeNode el = new DefaultMutableTreeNode(position);
                boolean some = false;
                for (SuccessfulAttack sa : this.attacks) {
                    if (!sa.getDoSAttack().getName().equals(dosAttackName) || !sa.getPosition().equals(position)) continue;
                    DefaultMutableTreeNode attackNode = new DefaultMutableTreeNode(sa);
                    el.add(attackNode);
                    some = true;
                }
                if (!some) continue;
                dn.add(el);
            }
        }
        return new DefaultTreeModel(root);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException(this.getClass().getName());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

