/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.threads;

import com.google.common.collect.Lists;
import java.util.List;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestObject;
import wsattacker.plugin.intelligentdos.listener.RecentTestProbeListener;
import wsattacker.plugin.intelligentdos.requestSender.Http4RequestSenderImpl;

public class TestProbeThread
extends Thread {
    private static final int MILLIES_BETWEEN_PROBES = 1000;
    private final RequestObject requestObject;
    private final List<RecentTestProbeListener> listeners = Lists.newArrayList();

    public TestProbeThread(RequestObject requestObject) {
        this.requestObject = requestObject;
    }

    @Override
    public void run() {
        while (!TestProbeThread.interrupted()) {
            try {
                Http4RequestSenderImpl impl = new Http4RequestSenderImpl();
                String sendRequestHttpClient = impl.sendRequestHttpClient(this.requestObject);
                long duration = impl.getDuration();
                Metric metric = new Metric();
                metric.setDuration(duration);
                metric.setContent(sendRequestHttpClient);
                this.notifyListener(metric);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void addListener(RecentTestProbeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RecentTestProbeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListener(Metric metric) {
        for (RecentTestProbeListener listener : this.listeners) {
            listener.recentTestProbe(metric);
        }
    }
}

