/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.intelligentdos.option;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.schemaanalyzer.AnyElementProperties;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.main.composition.plugin.option.AbstractOptionString;
import wsattacker.main.testsuite.TestSuite;

public class SchemaAnalyzerOption
extends AbstractOptionString
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SOAP_MESSAGE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><Envelope><Header/><Body></Body></Envelope>";
    private final transient SchemaAnalyzer schemaAnalyzer;

    public SchemaAnalyzerOption(String name, String value, SchemaAnalyzer schemaAnalyzer) {
        super(name, value);
        this.schemaAnalyzer = schemaAnalyzer;
        TestSuite.getInstance().getCurrentRequest().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean isValid(String value) {
        return StringUtils.isNotBlank((CharSequence)value);
    }

    private String create(String newContent) {
        String domToString = newContent;
        try {
            Document toAnalyze = DomUtilities.stringToDom((String)newContent);
            Set<AnyElementProperties> expansionPoints = this.findExpansionPoints(toAnalyze);
            Document stringToDom = null;
            for (AnyElementProperties element : expansionPoints) {
                stringToDom = DomUtilities.stringToDom((String)domToString);
                Element correspondingElement = DomUtilities.findCorrespondingElement((Document)stringToDom, (Element)element.getDocumentElement());
                DoSAttack.PayloadPosition.ELEMENT.createPlaceholder(stringToDom, correspondingElement);
                DoSAttack.PayloadPosition.ATTRIBUTE.createPlaceholder(stringToDom, correspondingElement);
                domToString = DomUtilities.domToString((Document)stringToDom);
            }
            if (stringToDom != null) {
                domToString = DoSAttack.PayloadPosition.replace(stringToDom);
            }
        }
        catch (SAXException ex) {
            Logger.getLogger(SchemaAnalyzerOption.class.getName()).log(Level.SEVERE, null, ex);
        }
        return domToString;
    }

    private Set<AnyElementProperties> findExpansionPoints(Document toAnalyze) {
        Element documentElement = toAnalyze.getDocumentElement();
        return this.schemaAnalyzer.findExpansionPoint(documentElement);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String create = DEFAULT_SOAP_MESSAGE;
        if ("wsdlRequest".equals(propName)) {
            if (evt.getNewValue() != null) {
                WsdlRequest newRequest = (WsdlRequest)evt.getNewValue();
                create = this.create(newRequest.getRequestContent());
            }
        } else if ("wsdlRequestContent".equals(propName)) {
            if (evt.getNewValue() != null) {
                String newContent = (String)evt.getNewValue();
                create = this.create(newContent);
            }
        } else if ("wsdlResponse".equals(propName) || "wsdlResponseContent".equals(propName)) {
            return;
        }
        this.setValue(create);
    }
}

