/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.analytics;

import com.eviware.soapui.analytics.AnalyticsManager;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Analytics {
    public static AnalyticsManager getAnalyticsManager() {
        return AnalyticsManager.getInstance();
    }

    public static void clearProviders() {
        AnalyticsManager.getInstance().clearProviders();
    }

    public static void trackAction(String action) {
        Analytics.getAnalyticsManager().trackAction(action);
    }

    public static void trackError(Throwable error) {
        Analytics.getAnalyticsManager().trackError(error);
    }

    public static boolean trackSessionStart() {
        return Analytics.getAnalyticsManager().trackSessionStart();
    }

    public static boolean trackSessionStop() {
        return Analytics.getAnalyticsManager().trackSessionStop();
    }

    public static void trackAction(String action, String ... args) {
        Map<String, String> params = Analytics.createParameterMap(args);
        Analytics.getAnalyticsManager().trackAction(action, params);
    }

    public static void trackLicenseData(String actionName, String ... parameters) {
        Map<String, String> parameterMap = Analytics.createParameterMap(parameters);
        Analytics.getAnalyticsManager().trackLicenseData(actionName, parameterMap);
    }

    public static void trackCustomPlugInAction(String actionName, String ... parameters) {
        Map<String, String> parameterMap = Analytics.createParameterMap(parameters);
        Analytics.getAnalyticsManager().trackCustomPlugInAction(actionName, parameterMap);
    }

    private static Map<String, String> createParameterMap(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int argumentCount = 0; argumentCount < args.length; argumentCount += 2) {
            if (!Analytics.hasContent(args[argumentCount]) || !Analytics.hasContent(args[argumentCount + 1])) continue;
            params.put(args[argumentCount], args[argumentCount + 1]);
        }
        return params;
    }

    private static boolean hasContent(String string) {
        return string != null && string.trim().length() > 0;
    }
}

