/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.helper;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class IterateModel
implements Iterator<Integer>,
Cloneable {
    private static final int UNSET = -1;
    private boolean stop;
    private int startAt = 0;
    private int stopAt = Integer.MAX_VALUE;
    private int initialIncrement = 1;
    private int currentValue = -1;
    private int increaseCount = 0;
    private int increment = 1;
    private IterateStrategie strategie = IterateStrategie.ADD;
    private IncreaseIncrementStrategie increaseStrategie = IncreaseIncrementStrategie.NO;

    public static IterateModelBuilder custom() {
        return IterateModelBuilder.create();
    }

    public int getStartAt() {
        return this.startAt;
    }

    public void startAt(int startAt) {
        this.startAt = startAt;
    }

    public int getStopAt() {
        return this.stopAt;
    }

    public void stopAt(int stopAt) {
        this.stopAt = stopAt;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.initialIncrement = increment;
        this.increment = increment;
    }

    public IterateStrategie getIterateStrategie() {
        return this.strategie;
    }

    public void setIterateStrategie(IterateStrategie iterateStrategie) {
        this.strategie = iterateStrategie;
    }

    public void setIncreaseIncrementStrategie(IncreaseIncrementStrategie increaseIncrementStrategie) {
        this.increaseStrategie = increaseIncrementStrategie;
    }

    public void increaseIncrement() {
        ++this.increaseCount;
        double inc = this.increaseStrategie.inc(this.increaseCount);
        this.increment = (int)((double)this.increment * inc);
    }

    public int increment(int numberAttributes) throws NoSuchElementException {
        if (this.stop) {
            throw new NoSuchElementException();
        }
        int inc = this.strategie.inc(numberAttributes, this.increment);
        if (!this.stop && this.strategie.end(inc, this.stopAt)) {
            this.stop = true;
            return this.stopAt;
        }
        return inc;
    }

    @Override
    public Integer next() throws NoSuchElementException {
        if (this.currentValue == -1) {
            this.currentValue = this.startAt;
            this.increment = this.initialIncrement;
        } else {
            try {
                this.currentValue = this.increment(this.currentValue);
            }
            catch (NoSuchElementException e) {
                throw new NoSuchElementException("no more elements to iterate over");
            }
        }
        return this.currentValue;
    }

    @Override
    public boolean hasNext() {
        switch (this.strategie) {
            case SUB: {
                return this.currentValue == -1 || this.currentValue > this.stopAt;
            }
        }
        return this.currentValue < this.stopAt;
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.currentValue = -1;
        this.stop = false;
    }

    public IterateModel clone() throws CloneNotSupportedException {
        IterateModel clone = (IterateModel)super.clone();
        clone.reset();
        return clone;
    }

    public static class IterateModelBuilder {
        private int startAt = 0;
        private int stopAt = Integer.MAX_VALUE;
        private int defaultIncrement = 1;
        private IterateStrategie iterateStrategie;
        private IncreaseIncrementStrategie increaseIncrementStrategie;

        public static IterateModelBuilder create() {
            return new IterateModelBuilder();
        }

        public final IterateModelBuilder startAt(int startAt) {
            this.startAt = startAt;
            return this;
        }

        public final IterateModelBuilder stopAt(int stopAt) {
            this.stopAt = stopAt;
            return this;
        }

        public final IterateModelBuilder setIncrement(int increment) {
            this.defaultIncrement = increment;
            return this;
        }

        public final IterateModelBuilder setIterateStrategie(IterateStrategie iterateStrategie) {
            this.iterateStrategie = iterateStrategie;
            return this;
        }

        public final IterateModelBuilder setIncreaseIncrementStrategie(IncreaseIncrementStrategie increaseIncrementStrategie) {
            this.increaseIncrementStrategie = increaseIncrementStrategie;
            return this;
        }

        public IterateModel build() {
            IterateModel iterateModel = new IterateModel();
            iterateModel.startAt(this.startAt);
            iterateModel.stopAt(this.stopAt);
            iterateModel.setIncrement(this.defaultIncrement);
            if (this.iterateStrategie == null) {
                this.iterateStrategie = IterateStrategie.ADD;
            }
            if (this.increaseIncrementStrategie == null) {
                this.increaseIncrementStrategie = IncreaseIncrementStrategie.AGGRESSIV;
            }
            iterateModel.setIterateStrategie(this.iterateStrategie);
            iterateModel.setIncreaseIncrementStrategie(this.increaseIncrementStrategie);
            return iterateModel;
        }
    }

    public static enum IncreaseIncrementStrategie {
        NO{

            @Override
            double inc(int a) {
                return 1.0;
            }
        }
        ,
        MODERATE{

            @Override
            double inc(int a) {
                return 1.0 + (double)a * 0.25;
            }
        }
        ,
        AGGRESSIV{

            @Override
            double inc(int a) {
                return 1.5 + (double)a * 0.5;
            }
        };


        abstract double inc(int var1);
    }

    public static enum IterateStrategie {
        ADD{

            @Override
            int inc(int a, int b) {
                return a + b;
            }
        }
        ,
        SUB{

            @Override
            int inc(int a, int b) {
                return a - b;
            }

            @Override
            boolean end(int a, int b) {
                return a < b;
            }
        }
        ,
        MUL{

            @Override
            int inc(int a, int b) {
                return a * b;
            }
        };


        abstract int inc(int var1, int var2);

        boolean end(int a, int b) {
            return a >= b;
        }
    }
}

