/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.common;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestObject {
    private final String requestContent;
    private Map<String, String> httpHeaderMap;
    private final String endpoint;

    public RequestObject(WsdlRequest wsdlRequest) {
        if (wsdlRequest == null) {
            throw new IllegalArgumentException("wsdlRequest cannot be null!");
        }
        this.requestContent = wsdlRequest.getRequestContent();
        this.endpoint = wsdlRequest.getEndpoint();
        this.createHttpHeaderMap(wsdlRequest);
    }

    public RequestObject(String requestContent, String endpoint, Map<String, String> httpHeaderMap) {
        this.requestContent = requestContent;
        this.endpoint = endpoint;
        this.httpHeaderMap = httpHeaderMap;
    }

    public String getRequestContent() {
        return this.requestContent;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getHttpHeaderMap() {
        return this.httpHeaderMap;
    }

    private void createHttpHeaderMap(WsdlRequest wsdlRequest) {
        this.httpHeaderMap = new HashMap<String, String>();
        StringToStringsMap originalHeaders = wsdlRequest.getRequestHeaders();
        for (Map.Entry entry : originalHeaders.entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.httpHeaderMap.put((String)entry.getKey(), value);
            }
        }
    }
}

