/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import wsattacker.library.intelligentdos.DoSState;
import wsattacker.library.intelligentdos.FinishState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.PossibleState;
import wsattacker.library.intelligentdos.TamperedState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;

public class UntamperedState
implements DoSState {
    @Override
    public String getName() {
        return "untampered state";
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        if (!attackModel.wasAttackExecutionSuccessful()) {
            this.setNotPossibleState(STATE_CONTEXT);
        } else {
            STATE_CONTEXT.setCurrentUntampered(attackModel.getDurationArray());
            if (!STATE_CONTEXT.noFurtherIterations) {
                STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createNewTampered(false));
                STATE_CONTEXT.setHasFurtherAttack(true);
                STATE_CONTEXT.setDoSState(new TamperedState());
            } else {
                STATE_CONTEXT.setDoSState(new FinishState());
            }
        }
    }

    @Override
    public void updateTestProbes(Metric metric) {
    }

    private void setNotPossibleState(IntelligentDoSLibraryImpl STATE_CONTEXT) {
        AttackModel createNewUntampered = STATE_CONTEXT.createNewUntampered(true);
        STATE_CONTEXT.setCurrentAttack(createNewUntampered);
        STATE_CONTEXT.setHasFurtherAttack(true);
        STATE_CONTEXT.setDoSState(new PossibleState());
    }
}

