/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import wsattacker.library.intelligentdos.AbstractDoSState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.TamperedState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.Threshold;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.CommonParamItem;

public class ThresholdState
extends AbstractDoSState {
    private static final int RESENDS = 1;
    private static final int ITERATIONS = 4;
    private CommonParamItem minimumParamItem;
    private CommonParamItem maximumParamItem;
    private AttackModel minimumAttack;
    private AttackModel maximumAttack;
    private int count = 0;
    private int iteration = 0;
    private THS ths = THS.PARAM;

    public ThresholdState(CommonParamItem minimumParamItem, CommonParamItem maximumParamItem) {
        this.minimumParamItem = minimumParamItem;
        this.maximumParamItem = maximumParamItem;
        this.ths = THS.PARAM;
    }

    public ThresholdState(AttackModel minimumAttack, AttackModel maximumAttack) {
        this.minimumAttack = minimumAttack;
        this.maximumAttack = maximumAttack;
        this.ths = THS.VALUE;
    }

    @Override
    public String getName() {
        return "threshold state";
    }

    private void setMinimumParamItem(CommonParamItem paramItem) {
        this.minimumParamItem = paramItem;
    }

    private void setMaximumParamItem(CommonParamItem paramItem) {
        this.maximumParamItem = paramItem;
    }

    private void setMinimumAttack(AttackModel attackModel) {
        this.minimumAttack = attackModel;
    }

    private void setMaximumAttack(AttackModel attackModel) {
        this.maximumAttack = attackModel;
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        switch (this.ths) {
            case PARAM: {
                CommonParamItem middle = this.createMiddleForParamItem(this.minimumParamItem, this.maximumParamItem);
                AttackModel middleParamAttack = ThresholdState.createTRWithParam(STATE_CONTEXT, middle);
                ++this.count;
                this.switchTo(THS.PARAMTHRESHOLD, STATE_CONTEXT, middleParamAttack);
                break;
            }
            case PARAMTHRESHOLD: {
                if (this.iteration < 4) {
                    if (attackModel.isAllFail()) {
                        if (this.count > 1) {
                            this.logger.warn((Object)("Further investigation is not possible! " + attackModel.getErrorCount() + " requests has not been send successfully. Abort execution."));
                            ThresholdState.switchToFinishState(STATE_CONTEXT);
                            break;
                        }
                        CommonParamItem middle = attackModel.getParamItem();
                        AttackModel paramMiddleAttack = ThresholdState.createTRWithParam(STATE_CONTEXT, middle);
                        ThresholdState.setAttack(STATE_CONTEXT, paramMiddleAttack);
                        ++this.count;
                        break;
                    }
                    if (attackModel.wasAttackExecutionSuccessful()) {
                        this.setMinimumParamItem(attackModel.getParamItem());
                        CommonParamItem middle = this.createMiddleForParamItem(this.minimumParamItem, this.maximumParamItem);
                        AttackModel paramMiddleAttack = ThresholdState.createTRWithParam(STATE_CONTEXT, middle);
                        ThresholdState.setAttack(STATE_CONTEXT, paramMiddleAttack);
                        ++this.iteration;
                        break;
                    }
                    this.setMaximumParamItem(attackModel.getParamItem());
                    CommonParamItem middle = this.createMiddleForParamItem(this.minimumParamItem, this.maximumParamItem);
                    AttackModel paramMiddleAttack = ThresholdState.createTRWithParam(STATE_CONTEXT, middle);
                    ThresholdState.setAttack(STATE_CONTEXT, paramMiddleAttack);
                    ++this.iteration;
                    break;
                }
                if (attackModel.isAllFail()) {
                    this.setMaximumParamItem(attackModel.getParamItem());
                } else if (attackModel.wasAttackExecutionSuccessful()) {
                    this.setMinimumParamItem(attackModel.getParamItem());
                }
                STATE_CONTEXT.setMaximumRequestsPerSecond(this.minimumParamItem.getReuqestsPerSecond());
                STATE_CONTEXT.setDoSState(new TamperedState());
                this.continueAttacks(STATE_CONTEXT);
                this.resetIteration();
                break;
            }
            case VALUE: {
                AttackModel middleAttack = this.createMiddle(STATE_CONTEXT);
                this.switchTo(THS.THRESHOLD, STATE_CONTEXT, middleAttack);
                this.resetIteration();
                break;
            }
            case THRESHOLD: {
                if (this.iteration < 4) {
                    if (attackModel.isAllFail()) {
                        this.setMaximumAttack(attackModel);
                        this.newFindThresholdIteration(STATE_CONTEXT);
                        break;
                    }
                    if (attackModel.wasAttackExecutionSuccessful()) {
                        this.setMinimumAttack(attackModel);
                        this.newFindThresholdIteration(STATE_CONTEXT);
                        break;
                    }
                    if (this.count > 1) {
                        this.logger.warn((Object)("Further investigation is not possible! " + attackModel.getErrorCount() + " requests has not been send successfully. Abort execution."));
                        ThresholdState.switchToFinishState(STATE_CONTEXT);
                        break;
                    }
                    this.createMiddleAttackAndSetToContext(STATE_CONTEXT);
                    ++this.count;
                    break;
                }
                if (attackModel.isAllFail()) {
                    this.setMaximumAttack(attackModel);
                } else if (attackModel.wasAttackExecutionSuccessful()) {
                    this.setMinimumAttack(attackModel);
                }
                STATE_CONTEXT.addThreshold(new Threshold(this.minimumAttack.getDoSAttack(), this.maximumAttack.getDoSAttack()));
                this.continueAttacks(STATE_CONTEXT);
                this.resetIteration();
                break;
            }
        }
    }

    @Override
    public void updateTestProbes(Metric metric) {
    }

    private void switchTo(THS ths, IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        this.count = 0;
        ThresholdState.setAttack(STATE_CONTEXT, attackModel);
        this.ths = ths;
    }

    private CommonParamItem createMiddleForParamItem(CommonParamItem min, CommonParamItem max) {
        int requests = max.getNumberOfRequests();
        int threads = max.getNumberOfThreads();
        int millies = max.getMilliesBetweenRequests();
        if (min.getNumberOfThreads() != max.getNumberOfThreads()) {
            threads = min.getNumberOfThreads() + (max.getNumberOfThreads() - min.getNumberOfThreads()) / 2;
        }
        if (threads <= 0 || min.getNumberOfThreads() == threads) {
            int minMBR = min.getMilliesBetweenRequests();
            if (min.getMilliesBetweenRequests() == max.getMilliesBetweenRequests()) {
                minMBR = 1;
            }
            millies = Math.min(minMBR, max.getMilliesBetweenRequests()) + Math.abs(max.getMilliesBetweenRequests() - minMBR) / 2;
        }
        return new CommonParamItem(requests, threads, millies);
    }

    private void newFindThresholdIteration(IntelligentDoSLibraryImpl STATE_CONTEXT) {
        this.createMiddleAttackAndSetToContext(STATE_CONTEXT);
        ++this.iteration;
    }

    private void createMiddleAttackAndSetToContext(IntelligentDoSLibraryImpl STATE_CONTEXT) {
        AttackModel middleAttack = this.createMiddle(STATE_CONTEXT);
        ThresholdState.setAttack(STATE_CONTEXT, middleAttack);
    }

    private AttackModel createMiddle(IntelligentDoSLibraryImpl STATE_CONTEXT) {
        DoSAttack middle = this.minimumAttack.getDoSAttack().middle(this.maximumAttack.getDoSAttack());
        AttackModel tampered = STATE_CONTEXT.createNewTampered(middle);
        return tampered;
    }

    private void resetIteration() {
        this.iteration = 0;
    }

    private static enum THS {
        PARAM,
        PARAMTHRESHOLD,
        VALUE,
        THRESHOLD;

    }
}

