/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import wsattacker.library.intelligentdos.DoSState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.SafetyState;
import wsattacker.library.intelligentdos.UntamperedState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.success.SuccessDecider;

public class SuspiciousState
implements DoSState {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final double UTR_RATIO_LOWER = SuspiciousState.getFromProperty("utr.ratio.lower", 0.5);
    private static final double UTR_RATIO_UPPER = SuspiciousState.getFromProperty("utr.ratio.upper", 2.0);
    private AttackModel untampered = null;

    @Override
    public String getName() {
        return "suspicious state";
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        if (this.untampered == null) {
            this.untampered = attackModel;
            STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createVerifyUntampered(true));
            STATE_CONTEXT.setHasFurtherAttack(true);
        } else {
            SuccessDecider successDecider = STATE_CONTEXT.getSuccessDecider();
            double ratio = successDecider.calculateRatio(STATE_CONTEXT.getCurrentUntampered(), attackModel.getDurationArray());
            double ratioFormatted = (double)Math.round(ratio * 100.0) / 100.0;
            if (SuspiciousState.isSuspicious(ratio)) {
                this.logger.info((Object)String.format("The ratio (%s) of the untampered requests stay suspicious. Switch to safety mode.", ratioFormatted));
                STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createVerifyUntampered(false));
                STATE_CONTEXT.setHasFurtherAttack(true);
                STATE_CONTEXT.setDoSState(new SafetyState());
            } else {
                this.logger.info((Object)String.format("The suspicious behavior could not be confirmed. The ratio was %s.", ratioFormatted));
                STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createNewUntampered(false));
                STATE_CONTEXT.setHasFurtherAttack(true);
                STATE_CONTEXT.setDoSState(new UntamperedState());
            }
        }
    }

    @Override
    public void updateTestProbes(Metric metric) {
    }

    public static boolean isSuspicious(double ratio) {
        return ratio < UTR_RATIO_LOWER || ratio > UTR_RATIO_UPPER;
    }

    private static double getFromProperty(String string, double defaultValue) {
        try {
            String property = System.getProperty(string);
            if (StringUtils.isEmpty((CharSequence)property)) {
                return defaultValue;
            }
            return Double.parseDouble(property);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

