/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import wsattacker.library.intelligentdos.AbstractDoSState;
import wsattacker.library.intelligentdos.FinishState;
import wsattacker.library.intelligentdos.IntelligentDoSLibraryImpl;
import wsattacker.library.intelligentdos.PossibleState;
import wsattacker.library.intelligentdos.UntamperedState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestType;
import wsattacker.library.intelligentdos.success.SuccessDecider;

public class SafetyState
extends AbstractDoSState {
    private AttackModel untampered = null;

    @Override
    public String getName() {
        return "safety state";
    }

    @Override
    public void update(IntelligentDoSLibraryImpl STATE_CONTEXT, AttackModel attackModel) {
        if (!attackModel.wasAttackExecutionSuccessful()) {
            STATE_CONTEXT.setDoSState(new PossibleState());
            STATE_CONTEXT.update(attackModel);
        } else if (this.untampered == null && attackModel.getRequestType() == RequestType.UNTAMPERED) {
            this.untampered = attackModel;
            STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createNewTampered(false));
            STATE_CONTEXT.setHasFurtherAttack(true);
        } else {
            if (this.untampered == null && attackModel.getRequestType() != RequestType.UNTAMPERED) {
                throw new IllegalStateException("untampered is null but attack model was " + (Object)((Object)attackModel.getRequestType()));
            }
            if (this.untampered != null) {
                SuccessDecider successDecider = STATE_CONTEXT.getSuccessDecider();
                Long[] currentTampered = attackModel.getDurationArray();
                Long[] currentUntampered = this.untampered.getDurationArray();
                boolean successful = successDecider.wasSuccessful(currentUntampered, currentTampered);
                if (successful) {
                    double calculateRatio = successDecider.calculateRatio(currentUntampered, currentTampered);
                    double d = (double)Math.round(calculateRatio * 100.0) / 100.0;
                    String dName = attackModel.getDoSAttack() != null ? attackModel.getDoSAttack().getName() : "???";
                    String msg = String.format("First execution of %s was successful (ratio: %s).", dName, d);
                    this.logger.info((Object)msg);
                    STATE_CONTEXT.setCurrentUntampered(currentUntampered);
                    this.setSuccessfulState(STATE_CONTEXT);
                } else {
                    this.untampered = null;
                    AttackModel nextAttack = STATE_CONTEXT.createNextAttack();
                    boolean hasFurtherAttack = nextAttack != null;
                    STATE_CONTEXT.setHasFurtherAttack(hasFurtherAttack);
                    if (hasFurtherAttack) {
                        if (nextAttack.getRequestType() == RequestType.UNTAMPERED) {
                            STATE_CONTEXT.setCurrentAttack(nextAttack);
                            STATE_CONTEXT.setDoSState(new UntamperedState());
                        } else {
                            STATE_CONTEXT.setCurrentAttack(STATE_CONTEXT.createVerifyUntampered(false));
                        }
                    } else {
                        STATE_CONTEXT.setDoSState(new FinishState());
                    }
                }
            }
        }
    }

    @Override
    public void updateTestProbes(Metric metric) {
    }
}

