/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.HashMap;
import java.util.Map;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheck;
import org.w3c.tidy.AttrId;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.TagId;
import org.w3c.tidy.TidyUtils;

public final class AttrCheckImpl {
    public static final AttrCheck PCDATA = null;
    public static final AttrCheck CHARSET = null;
    public static final AttrCheck TYPE = new CheckType();
    public static final AttrCheck XTYPE = null;
    public static final AttrCheck CHARACTER = null;
    public static final AttrCheck URLS = null;
    public static final AttrCheck URL = new CheckUrl();
    public static final AttrCheck SCRIPT = new CheckScript();
    public static final AttrCheck ALIGN = new CheckAlign();
    public static final AttrCheck VALIGN = new CheckValign();
    public static final AttrCheck COLOR = new CheckColor();
    public static final AttrCheck CLEAR = new CheckClear();
    public static final AttrCheck BORDER = new CheckBool();
    public static final AttrCheck LANG = new CheckLang();
    public static final AttrCheck BOOL = new CheckBool();
    public static final AttrCheck COLS = null;
    public static final AttrCheck NUMBER = new CheckNumber();
    public static final AttrCheck LENGTH = new CheckLength();
    public static final AttrCheck COORDS = null;
    public static final AttrCheck DATE = null;
    public static final AttrCheck TEXTDIR = new CheckTextDir();
    public static final AttrCheck IDREFS = null;
    public static final AttrCheck IDREF = null;
    public static final AttrCheck IDDEF = new CheckId();
    public static final AttrCheck NAME = new CheckName();
    public static final AttrCheck TFRAME = null;
    public static final AttrCheck FBORDER = null;
    public static final AttrCheck MEDIA = null;
    public static final AttrCheck FSUBMIT = new CheckFsubmit();
    public static final AttrCheck LINKTYPES = null;
    public static final AttrCheck TRULES = null;
    public static final AttrCheck SCOPE = new CheckScope();
    public static final AttrCheck SHAPE = new CheckShape();
    public static final AttrCheck SCROLL = new CheckScroll();
    public static final AttrCheck TARGET = new CheckTarget();
    public static final AttrCheck VTYPE = new CheckVType();
    public static final AttrCheck ACTION = new CheckAction();

    private AttrCheckImpl() {
    }

    private static void checkAttrValidity(Lexer lexer, Node node, AttVal attval, String[] list) {
        if (!attval.hasValue()) {
            lexer.report.attrError(lexer, node, attval, (short)50);
            return;
        }
        attval.checkLowerCaseAttrValue(lexer, node);
        if (!attval.valueIsAmong(list)) {
            lexer.report.attrError(lexer, node, attval, (short)51);
        }
    }

    public static class CheckType
    implements AttrCheck {
        private static final String[] valuesINPUT = new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"};
        private static final String[] valuesBUTTON = new String[]{"button", "submit", "reset"};
        private static final String[] valuesUL = new String[]{"disc", "square", "circle"};
        private static final String[] valuesOL = new String[]{"1", "a", "i"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            if (node.is(TagId.INPUT)) {
                AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckType.valuesINPUT);
            } else if (node.is(TagId.BUTTON)) {
                AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckType.valuesBUTTON);
            } else if (node.is(TagId.UL)) {
                AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckType.valuesUL);
            } else if (node.is(TagId.OL)) {
                if (!attval.hasValue()) {
                    lexer.report.attrError(lexer, node, attval, (short)50);
                    return;
                }
                if (!attval.valueIsAmong(valuesOL)) {
                    lexer.report.attrError(lexer, node, attval, (short)51);
                }
            } else if (node.is(TagId.LI)) {
                if (!attval.hasValue()) {
                    lexer.report.attrError(lexer, node, attval, (short)50);
                    return;
                }
                if (attval.valueIsAmong(valuesUL)) {
                    attval.checkLowerCaseAttrValue(lexer, node);
                } else if (!attval.valueIsAmong(valuesOL)) {
                    lexer.report.attrError(lexer, node, attval, (short)51);
                }
            }
        }
    }

    public static class CheckLang
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue() && !attval.is(AttrId.XML_LANG)) {
                if (lexer.configuration.getAccessibilityCheckLevel() == 0) {
                    lexer.report.attrError(lexer, node, attval, (short)50);
                }
                return;
            }
        }
    }

    public static class CheckTextDir
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"rtl", "ltr"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckTextDir.VALID_VALUES);
        }
    }

    public static class CheckScroll
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"no", "auto", "yes"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckScroll.VALID_VALUES);
        }
    }

    public static class CheckVType
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"data", "object", "ref"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckVType.VALID_VALUES);
        }
    }

    public static class CheckColor
    implements AttrCheck {
        private static final Map<String, String> COLORS_BY_NAME = new HashMap<String, String>();
        private static final Map<String, String> COLORS_BY_VALUE = new HashMap<String, String>();

        private static void addColor(String name, String value) {
            COLORS_BY_NAME.put(name, value);
            COLORS_BY_VALUE.put(value, name);
        }

        private static String getColorCode(String name) {
            return COLORS_BY_NAME.get(name.toLowerCase());
        }

        private static String getColorName(String code) {
            return COLORS_BY_VALUE.get(code.toUpperCase());
        }

        private static boolean isValidColorCode(String color) {
            if (color.length() != 6) {
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                if (TidyUtils.isxdigit(color.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public void check(Lexer lexer, Node node, AttVal attval) {
            String newName;
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            boolean valid = false;
            String given = attval.value;
            if (given.length() > 0 && given.charAt(0) != '#' && (valid = CheckColor.isValidColorCode(given))) {
                String s = '#' + given;
                lexer.report.attrError(lexer, node, attval, (short)73);
                given = attval.value = s;
            }
            if (!valid && given.length() > 0 && given.charAt(0) == '#') {
                valid = CheckColor.isValidColorCode(given.substring(1));
            }
            if (valid && given.charAt(0) == '#' && lexer.configuration.isReplaceColor() && (newName = CheckColor.getColorName(given)) != null) {
                given = attval.value = newName;
            }
            if (!valid) {
                valid = CheckColor.getColorCode(given) != null;
            }
            attval.value = valid && given.charAt(0) == '#' ? attval.value.toUpperCase() : attval.value.toLowerCase();
            if (!valid) {
                lexer.report.attrError(lexer, node, attval, (short)51);
            }
        }

        static {
            CheckColor.addColor("black", "#000000");
            CheckColor.addColor("green", "#008000");
            CheckColor.addColor("silver", "#C0C0C0");
            CheckColor.addColor("lime", "#00FF00");
            CheckColor.addColor("gray", "#808080");
            CheckColor.addColor("olive", "#808000");
            CheckColor.addColor("white", "#FFFFFF");
            CheckColor.addColor("yellow", "#FFFF00");
            CheckColor.addColor("maroon", "#800000");
            CheckColor.addColor("navy", "#000080");
            CheckColor.addColor("red", "#FF0000");
            CheckColor.addColor("blue", "#0000FF");
            CheckColor.addColor("purple", "#800080");
            CheckColor.addColor("teal", "#008080");
            CheckColor.addColor("fuchsia", "#FF00FF");
            CheckColor.addColor("aqua", "#00FFFF");
        }
    }

    public static class CheckNumber
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            if (node.is(TagId.FRAMESET) && (attval.is(AttrId.COLS) || attval.is(AttrId.ROWS))) {
                return;
            }
            String p = attval.value;
            int j = 0;
            if (node.is(TagId.FONT) && p.length() > 0 && (p.charAt(0) == '+' || p.charAt(0) == '-')) {
                ++j;
            }
            while (j < p.length()) {
                if (!Character.isDigit(p.charAt(j))) {
                    lexer.report.attrError(lexer, node, attval, (short)51);
                    break;
                }
                ++j;
            }
        }
    }

    public static class CheckScope
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"row", "rowgroup", "col", "colgroup"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckScope.VALID_VALUES);
        }
    }

    public static class CheckShape
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"rect", "default", "circle", "poly"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckShape.VALID_VALUES);
        }
    }

    public static class CheckClear
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"none", "left", "right", "all"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                if (attval.value == null) {
                    attval.value = "none";
                }
                return;
            }
            attval.checkLowerCaseAttrValue(lexer, node);
            if (!attval.valueIsAmong(VALID_VALUES)) {
                lexer.report.attrError(lexer, node, attval, (short)51);
            }
        }
    }

    public static class CheckFsubmit
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"get", "post"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            AttrCheckImpl.checkAttrValidity(lexer, node, attval, CheckFsubmit.VALID_VALUES);
        }
    }

    public static class CheckTarget
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"_blank", "_self", "_parent", "_top"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            String value = attval.value;
            if (value.length() > 0 && Character.isLetter(value.charAt(0))) {
                return;
            }
            if (!attval.valueIsAmong(VALID_VALUES)) {
                lexer.report.attrError(lexer, node, attval, (short)51);
            }
        }
    }

    public static class CheckLength
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            if (attval.is(AttrId.WIDTH) && (node.is(TagId.COL) || node.is(TagId.COLGROUP))) {
                return;
            }
            String p = attval.value;
            if (p.length() == 0 || !Character.isDigit(p.charAt(0))) {
                lexer.report.attrError(lexer, node, attval, (short)51);
            } else {
                for (int j = 1; j < p.length(); ++j) {
                    if (Character.isDigit(p.charAt(j)) || p.charAt(j) == '%') continue;
                    lexer.report.attrError(lexer, node, attval, (short)51);
                    break;
                }
            }
        }
    }

    public static class CheckValign
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"top", "middle", "bottom", "baseline"};
        private static final String[] VALID_VALUES_IMG = new String[]{"left", "right"};
        private static final String[] VALID_VALUES_PROPRIETARY = new String[]{"texttop", "absmiddle", "absbottom", "textbottom"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            attval.checkLowerCaseAttrValue(lexer, node);
            if (!attval.valueIsAmong(VALID_VALUES)) {
                if (attval.valueIsAmong(VALID_VALUES_IMG)) {
                    if (node.tag == null || (node.tag.model & 0x10000) == 0) {
                        lexer.report.attrError(lexer, node, attval, (short)51);
                    }
                } else if (attval.valueIsAmong(VALID_VALUES_PROPRIETARY)) {
                    lexer.constrainVersion(57344);
                    lexer.report.attrError(lexer, node, attval, (short)54);
                } else {
                    lexer.report.attrError(lexer, node, attval, (short)51);
                }
            }
        }
    }

    public static class CheckAlign
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"left", "right", "center", "justify"};

        public void check(Lexer lexer, Node node, AttVal attval) {
            if (node.tag != null && (node.tag.model & 0x10000) != 0) {
                VALIGN.check(lexer, node, attval);
                return;
            }
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            attval.checkLowerCaseAttrValue(lexer, node);
            if (node.is(TagId.CAPTION)) {
                return;
            }
            if (!(attval.valueIsAmong(VALID_VALUES) || attval.valueIs("char") && node.hasCM(640))) {
                lexer.report.attrError(lexer, node, attval, (short)51);
            }
        }
    }

    public static class CheckBool
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                return;
            }
            attval.checkLowerCaseAttrValue(lexer, node);
        }
    }

    public static class CheckId
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            Node old;
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            if (!TidyUtils.isValidHTMLID(attval.value)) {
                if (lexer.isvoyager && TidyUtils.isValidXMLID(attval.value)) {
                    lexer.report.attrError(lexer, node, attval, (short)71);
                } else {
                    lexer.report.attrError(lexer, node, attval, (short)51);
                }
            }
            if ((old = lexer.configuration.tt.getNodeByAnchor(attval.value)) != null && old != node) {
                lexer.report.attrError(lexer, node, attval, (short)66);
            } else {
                lexer.configuration.tt.addAnchor(attval.value, node);
            }
        }
    }

    public static class CheckName
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            if (node.isAnchorElement()) {
                Node old;
                if (lexer.configuration.isXmlOut() && !TidyUtils.isValidNMTOKEN(attval.value)) {
                    lexer.report.attrError(lexer, node, attval, (short)51);
                }
                if ((old = lexer.configuration.tt.getNodeByAnchor(attval.value)) != null && old != node) {
                    lexer.report.attrError(lexer, node, attval, (short)66);
                } else {
                    lexer.configuration.tt.addAnchor(attval.value, node);
                }
            }
        }
    }

    public static class CheckScript
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
        }
    }

    public static class CheckAction
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (attval.hasValue()) {
                URL.check(lexer, node, attval);
            }
        }
    }

    public static class CheckUrl
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attval) {
            int escapeCount = 0;
            boolean backslashFound = false;
            if (!attval.hasValue()) {
                lexer.report.attrError(lexer, node, attval, (short)50);
                return;
            }
            String p = attval.value;
            boolean isJavascript = attval.value.startsWith("javascript:");
            for (int i = 0; i < p.length(); ++i) {
                char c = p.charAt(i);
                if (c == '\\') {
                    backslashFound = true;
                    continue;
                }
                if (c <= '~' && c > ' ' && c != '<' && c != '>') continue;
                ++escapeCount;
            }
            if (lexer.configuration.isFixBackslash() && backslashFound) {
                attval.value = p = p.replace('\\', '/');
            }
            if (lexer.configuration.isFixUri() && escapeCount > 0) {
                StringBuilder dest = new StringBuilder(p.length() + escapeCount * 2);
                for (int i = 0; i < p.length(); ++i) {
                    char c = p.charAt(i);
                    if (c > '~' || c <= ' ' || c == '<' || c == '>') {
                        dest.append(String.format("%%%02X", Character.valueOf(c)));
                        continue;
                    }
                    dest.append(c);
                }
                attval.value = dest.toString();
            }
            if (backslashFound) {
                if (lexer.configuration.isFixBackslash() && !isJavascript) {
                    lexer.report.attrError(lexer, node, attval, (short)62);
                } else {
                    lexer.report.attrError(lexer, node, attval, (short)61);
                }
            }
            if (escapeCount > 0) {
                if (lexer.configuration.isFixUri()) {
                    lexer.report.attrError(lexer, node, attval, (short)64);
                } else {
                    lexer.report.attrError(lexer, node, attval, (short)63);
                }
                lexer.badChars = (short)(lexer.badChars | 0x51);
            }
        }
    }
}

