/*
 * Decompiled with CFR 0.152.
 */
package hermes.taglib;

import hermes.Domain;
import hermes.Hermes;
import hermes.taglib.HermesSessionManager;
import hermes.taglib.MessageDecorator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class HermesBrowseTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(HermesBrowseTag.class);
    private String hermes;
    private String destination;
    private String collection;
    private String params;
    private String raise;
    private String decorator = MessageDecorator.class.getName();

    public int doStartTag() throws JspTagException {
        StringTokenizer tokens;
        Hermes h = null;
        ArrayList<String> paramSet = new ArrayList<String>();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (this.params != null) {
            tokens = new StringTokenizer(this.params, ",");
            while (tokens.hasMoreTokens()) {
                paramSet.add(tokens.nextToken());
            }
        }
        if (this.raise != null) {
            tokens = new StringTokenizer(this.raise, ",");
            while (tokens.hasMoreTokens()) {
                String keyVal = tokens.nextToken();
                StringTokenizer tokens2 = new StringTokenizer(keyVal, "=");
                headerMap.put(tokens2.nextToken(), tokens2.nextToken());
            }
        }
        this.hermes = (String)this.pageContext.getAttribute("hermes", 3);
        this.destination = (String)this.pageContext.getAttribute("destination", 3);
        this.collection = (String)this.pageContext.getAttribute("collection", 3);
        if (this.collection == null) {
            this.collection = "messages";
        }
        log.debug((Object)("hermes=" + this.hermes + ", destination=" + this.destination + ", params=" + paramSet));
        try {
            MessageDecorator dec = (MessageDecorator)Class.forName(this.decorator).newInstance();
            ArrayList<Object> c = new ArrayList<Object>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            h = HermesSessionManager.getHermes(this.pageContext, this.hermes);
            Destination d = h.getDestination(this.destination, Domain.QUEUE);
            QueueBrowser browser = h.createBrowser(d);
            long i = 0L;
            Enumeration e = browser.getEnumeration();
            while (e.hasMoreElements()) {
                Message m = (Message)e.nextElement();
                if (m == null) continue;
                Object mbean = dec.decorate(this.collection, h, Long.toString(i), m, paramSet, headerMap);
                this.pageContext.setAttribute(this.getCollection() + "[" + Long.toString(i) + "]", mbean, 3);
                map.put(Long.toString(i++), mbean);
                c.add(mbean);
            }
            this.pageContext.setAttribute(this.getCollection(), c, 3);
            this.pageContext.setAttribute(this.getCollection() + ".map", c, 3);
            browser.close();
            log.debug((Object)("read " + c.size() + " message(s)"));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new JspTagException(e.getMessage());
        }
        finally {
            try {
                if (h != null) {
                    h.close();
                }
            }
            catch (JMSException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getHermes() {
        return this.hermes;
    }

    public void setHermes(String hermes) {
        this.hermes = hermes;
    }

    public String getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getRaise() {
        return this.raise;
    }

    public void setRaise(String raise) {
        this.raise = raise;
    }
}

