/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.impl.FileRepository;
import hermes.swing.actions.ActionSupport;
import hermes.swing.actions.DirectoryCache;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

public class OpenXMLFileAction
extends ActionSupport {
    public OpenXMLFileAction() {
        this.putValue("Name", "Open Messages...");
        this.putValue("ShortDescription", "Open an XML messages file");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.file.xml.open"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.setEnabled(false);
        this.enableOnBrowserTreeSelection(new Class[]{DestinationConfigTreeNode.class, HermesTreeNode.class}, (Action)this, true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            JFileChooser chooser = null;
            HermesTreeNode hermesNode = null;
            if (HermesBrowser.getBrowser().getBrowserTree().getSelectionPath().getLastPathComponent() instanceof HermesTreeNode) {
                hermesNode = (HermesTreeNode)HermesBrowser.getBrowser().getBrowserTree().getSelectionPath().getLastPathComponent();
            } else if (HermesBrowser.getBrowser().getBrowserTree().getSelectionPath().getLastPathComponent() instanceof DestinationConfigTreeNode) {
                hermesNode = ((DestinationConfigTreeNode)HermesBrowser.getBrowser().getBrowserTree().getSelectionPath().getLastPathComponent()).getHermesTreeNode();
            } else {
                return;
            }
            chooser = DirectoryCache.lastUploadDirectory == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(DirectoryCache.lastUploadDirectory);
            if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Open") == 0) {
                DirectoryCache.lastUploadDirectory = chooser.getSelectedFile().getParentFile();
                HermesBrowser.getBrowser().getActionFactory().createRepositoryBrowseAction(new FileRepository(chooser.getSelectedFile()), hermesNode.getHermes());
            } else {
                Hermes.ui.getDefaultMessageSink().add("File open cancelled");
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to open: ", ex);
        }
    }
}

