/*
 * Decompiled with CFR 0.152.
 */
package hermes.store;

import hermes.Domain;
import hermes.HermesException;
import hermes.MessageFactory;
import hermes.store.MessageStore;
import hermes.store.MessageStoreListener;
import hermes.store.MessageStoreQueue;
import hermes.store.MessageStoreTopic;
import hermes.store.StoreMessageFactory;
import hermes.store.StoreUtils;
import hermes.store.jdbc.JDBCConnectionPool;
import hermes.store.schema.JDBCAdapter;
import hermes.util.JMSUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.naming.NamingException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.log4j.Logger;

public class SingleUserMessageStore
implements MessageStore {
    private static final Logger log = Logger.getLogger(SingleUserMessageStore.class);
    private String storeId;
    private String jdbcURL;
    private JDBCAdapter adapter;
    private List<MessageStoreListener> listeners = new ArrayList<MessageStoreListener>();
    private MessageFactory defaultFactory = new StoreMessageFactory();
    private Set<Destination> destinations = new HashSet<Destination>();
    private Map<Destination, Integer> depths = new HashMap<Destination, Integer>();
    private JDBCConnectionPool connectionPool;
    private ThreadLocal<Connection> writerTL = new ThreadLocal();

    public SingleUserMessageStore(String storeId, String jdbcURL, boolean doCreate) throws JMSException {
        this.storeId = storeId;
        this.jdbcURL = jdbcURL;
        this.connectionPool = new JDBCConnectionPool(jdbcURL, 2, false);
        this.adapter = StoreUtils.getJDBCAdapter(jdbcURL);
        try {
            Connection connection = (Connection)this.connectionPool.get();
            if (doCreate) {
                this.adapter.createDatabase(connection);
            }
            this.adapter.createStore(connection, storeId);
            connection.commit();
            this.destinations.addAll(this.getDestinationsFromDatabase());
            for (Destination d : this.destinations) {
                this.getDepth(d);
            }
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
    }

    @Override
    public String getURL() {
        return this.jdbcURL;
    }

    private Connection getWriterConnection() throws HermesException {
        if (this.writerTL.get() == null) {
            this.writerTL.set((Connection)this.connectionPool.get());
        }
        return this.writerTL.get();
    }

    @Override
    public String getTooltipText() {
        return this.jdbcURL;
    }

    @Override
    public String getId() {
        return this.storeId;
    }

    @Override
    public Collection<Destination> getDestinations() throws JMSException {
        return this.destinations;
    }

    public Collection<Destination> getDestinationsFromDatabase() throws JMSException {
        Connection connection = (Connection)this.connectionPool.get();
        try {
            Collection<Destination> collection = this.adapter.getDestinations(connection, this.getId());
            return collection;
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
        finally {
            if (connection != null) {
                DbUtils.closeQuietly((Connection)connection);
            }
        }
    }

    @Override
    public QueueBrowser visit() throws JMSException {
        return this.visit(this.defaultFactory, MessageStore.HeaderPolicy.MESSAGEID_AND_DESTINATION);
    }

    @Override
    public QueueBrowser visit(Destination d) throws JMSException {
        return this.visit(this.defaultFactory, d, MessageStore.HeaderPolicy.MESSAGEID_AND_DESTINATION);
    }

    @Override
    public QueueBrowser visit(MessageFactory factory, MessageStore.HeaderPolicy headerPolicy) throws JMSException {
        Connection connection = (Connection)this.connectionPool.get();
        try {
            return this.adapter.getMessages(connection, this.getId(), factory, headerPolicy);
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
    }

    @Override
    public QueueBrowser visit(MessageFactory factory, Destination d, MessageStore.HeaderPolicy headerPolicy) throws JMSException {
        Connection connection = (Connection)this.connectionPool.get();
        try {
            return this.adapter.getMessages(connection, this.getId(), d, factory, headerPolicy);
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
    }

    @Override
    public void delete() throws JMSException {
        Connection connection = this.getWriterConnection();
        try {
            this.adapter.remove(connection, this.storeId);
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
    }

    protected Destination createStoreDestination(Destination from) throws JMSException {
        try {
            if (from instanceof MessageStoreQueue || from instanceof MessageStoreTopic) {
                return from;
            }
            return this.defaultFactory.getDestination(JMSUtils.getDestinationName(from), Domain.getDomain(from));
        }
        catch (NamingException ex) {
            throw new HermesException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(Message message) throws JMSException {
        try {
            this.adapter.insert(this.getWriterConnection(), this.getId(), message);
            Destination from = this.createStoreDestination(message.getJMSDestination());
            if (!this.destinations.contains(from)) {
                this.destinations.add(from);
                for (MessageStoreListener l : this.listeners) {
                    l.onDestination(from);
                }
            }
            for (MessageStoreListener l : this.listeners) {
                l.onMessage(message);
            }
            Map<Destination, Integer> map = this.depths;
            synchronized (map) {
                if (this.depths.containsKey(from)) {
                    this.depths.put(from, this.depths.get(from) + 1);
                }
            }
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDepth(Destination d) throws JMSException {
        d = this.createStoreDestination(d);
        Map<Destination, Integer> map = this.depths;
        synchronized (map) {
            if (this.depths.containsKey(d)) {
                return this.depths.get(d);
            }
        }
        Connection connection = (Connection)this.connectionPool.get();
        try {
            int depth = this.adapter.getDepth(connection, this.getId(), d);
            Map<Destination, Integer> map2 = this.depths;
            synchronized (map2) {
                this.depths.put(d, depth);
            }
            int n = depth;
            return n;
        }
        catch (SQLException e) {
            throw new HermesException(e);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Message message) throws JMSException {
        block11: {
            Connection connection = this.getWriterConnection();
            Destination destination = this.createStoreDestination(message.getJMSDestination());
            try {
                this.adapter.remove(connection, this.getId(), message);
                for (MessageStoreListener l : this.listeners) {
                    l.onMessageDeleted(message);
                }
                Object i$ = this.depths;
                synchronized (i$) {
                    if (this.depths.containsKey(destination)) {
                        this.depths.put(destination, this.depths.get(destination) - 1);
                    }
                }
                if (this.getDepth(destination) != 0) break block11;
                this.destinations.remove(destination);
                i$ = this.depths;
                synchronized (i$) {
                    this.depths.remove(destination);
                }
                for (MessageStoreListener l : this.listeners) {
                    l.onDestinationDeleted(destination);
                }
            }
            catch (SQLException ex) {
                throw new HermesException(ex);
            }
        }
    }

    @Override
    public void delete(Destination d) throws JMSException {
        Connection connection = this.getWriterConnection();
        try {
            this.adapter.remove(connection, this.getId(), JMSUtils.getDestinationName(d));
            for (MessageStoreListener l : this.listeners) {
                l.onDestinationDeleted(d);
            }
            this.depths.remove(d);
            this.destinations.remove(this.createStoreDestination(d));
        }
        catch (SQLException ex) {
            throw new HermesException(ex);
        }
    }

    @Override
    public void rollback() throws JMSException {
        try {
            if (this.writerTL.get() != null) {
                this.writerTL.get().rollback();
                this.writerTL.get().close();
            }
        }
        catch (SQLException e) {
            throw new HermesException(e);
        }
        finally {
            this.writerTL.set(null);
        }
    }

    @Override
    public void checkpoint() throws JMSException {
        try {
            if (this.writerTL.get() != null) {
                this.writerTL.get().commit();
                this.writerTL.get().close();
            }
        }
        catch (SQLException e) {
            throw new HermesException(e);
        }
        finally {
            this.writerTL.set(null);
        }
    }

    @Override
    public void close() throws JMSException {
        try {
            this.getWriterConnection().close();
        }
        catch (SQLException e) {
            throw new HermesException(e);
        }
        finally {
            this.writerTL.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(MessageStoreListener listener) {
        List<MessageStoreListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(MessageStoreListener listener) {
        List<MessageStoreListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

