/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.browser.HermesBrowser;
import hermes.config.ClasspathConfig;
import hermes.config.PropertyConfig;
import hermes.config.PropertySetConfig;
import hermes.util.TextUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.jms.ConnectionFactory;
import javax.swing.ProgressMonitor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class LoaderSupport {
    private static final Logger log = Logger.getLogger(LoaderSupport.class);

    static ClassLoader createClassLoader(List loaderConfigs, URL[] extraUrls, ClassLoader classLoader) throws IOException {
        int index = 0;
        int size = loaderConfigs.size();
        if (extraUrls != null) {
            size += extraUrls.length;
        }
        URL[] urls = new URL[size];
        StringBuffer debug = new StringBuffer("URLClassLoader: ");
        Iterator iter = loaderConfigs.iterator();
        while (iter.hasNext()) {
            ClasspathConfig lConfig = (ClasspathConfig)iter.next();
            URL url = null;
            url = lConfig.getJar().startsWith("http") ? new URL(TextUtils.replaceClasspathVariables(lConfig.getJar())) : new File(TextUtils.replaceClasspathVariables(lConfig.getJar())).toURL();
            urls[index++] = url;
            debug.append(url.toString());
            if (!iter.hasNext()) continue;
            debug.append(", ");
        }
        if (extraUrls != null) {
            for (int i = 0; i < extraUrls.length; ++i) {
                urls[index++] = extraUrls[i];
                debug.append(", " + extraUrls[i].toString());
            }
        }
        log.debug((Object)debug.toString());
        return new DebugClassLoader(urls, classLoader);
    }

    static ClassLoader createClassLoader(List loaderConfigs, ClassLoader classLoader) throws IOException {
        return LoaderSupport.createClassLoader(loaderConfigs, null, classLoader);
    }

    static List lookForFactories(final List loaderConfigs, final ClassLoader baseLoader) throws IOException {
        final ArrayList<String> rval = new ArrayList<String>();
        for (final ClasspathConfig lConfig : loaderConfigs) {
            if (lConfig.getFactories() != null) {
                log.debug((Object)("using cached " + lConfig.getFactories()));
                StringTokenizer tokens = new StringTokenizer(lConfig.getFactories(), ",");
                while (tokens.hasMoreTokens()) {
                    rval.add(tokens.nextToken());
                }
                continue;
            }
            if (lConfig.isNoFactories().booleanValue()) {
                log.debug((Object)("previously scanned " + lConfig.getJar()));
                continue;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> localFactories = new ArrayList<String>();
                    boolean foundFactory = false;
                    StringBuffer factoriesAsString = null;
                    try {
                        log.debug((Object)("searching " + lConfig.getJar()));
                        ClassLoader l = LoaderSupport.createClassLoader(loaderConfigs, baseLoader);
                        JarFile jarFile = new JarFile(lConfig.getJar());
                        ProgressMonitor monitor = null;
                        int entryNumber = 0;
                        if (HermesBrowser.getBrowser() != null) {
                            monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Looking for factories in " + lConfig.getJar(), "Scanning...", 0, jarFile.size());
                            monitor.setMillisToDecideToPopup(0);
                            monitor.setMillisToPopup(0);
                            monitor.setProgress(0);
                        }
                        Enumeration<JarEntry> iter = jarFile.entries();
                        while (iter.hasMoreElements()) {
                            ZipEntry entry = iter.nextElement();
                            ++entryNumber;
                            if (monitor != null) {
                                monitor.setProgress(entryNumber);
                                monitor.setNote("Checking entry " + entryNumber + " of " + jarFile.size());
                            }
                            if (!entry.getName().endsWith(".class")) continue;
                            String s = entry.getName().substring(0, entry.getName().indexOf(".class"));
                            s = s.replaceAll("/", ".");
                            try {
                                Class<?> clazz;
                                if (s.startsWith("hermes.browser") || s.startsWith("hermes.impl") || s.startsWith("javax.jms") || (clazz = l.loadClass(s)).isInterface() || !LoaderSupport.implementsOrExtends(clazz, ConnectionFactory.class)) continue;
                                foundFactory = true;
                                localFactories.add(s);
                                if (factoriesAsString == null) {
                                    factoriesAsString = new StringBuffer();
                                    factoriesAsString.append(clazz.getName());
                                } else {
                                    factoriesAsString.append(",").append(clazz.getName());
                                }
                                log.debug((Object)("found " + clazz.getName()));
                            }
                            catch (Throwable t) {}
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("unable to access jar/zip " + lConfig.getJar() + ": " + e.getMessage()), (Throwable)e);
                    }
                    if (!foundFactory) {
                        lConfig.setNoFactories(true);
                    } else {
                        lConfig.setFactories(factoriesAsString.toString());
                        rval.addAll(localFactories);
                    }
                }
            };
            r.run();
        }
        return rval;
    }

    public static boolean implementsOrExtends(Class clazz, Class testInterface) {
        Class<?>[] implementedInterfaces = clazz.getInterfaces();
        if (clazz.equals(testInterface)) {
            return true;
        }
        for (int i = 0; i < implementedInterfaces.length; ++i) {
            if (!LoaderSupport.implementsOrExtends(implementedInterfaces[i], testInterface)) continue;
            return true;
        }
        Class superClass = clazz.getSuperclass();
        return superClass != null && LoaderSupport.implementsOrExtends(superClass, testInterface);
    }

    public static void populateBean(Object bean, PropertySetConfig propertySet) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (propertySet != null) {
            HashSet<String> appliedProperties = new HashSet<String>();
            Iterator<PropertyConfig> iter = propertySet.getProperty().iterator();
            while (iter.hasNext()) {
                PropertyConfig propertyConfig = iter.next();
                if (appliedProperties.contains(propertyConfig.getName())) {
                    iter.remove();
                    continue;
                }
                try {
                    BeanUtils.setProperty((Object)bean, (String)propertyConfig.getName(), (Object)TextUtils.replaceClasspathVariables(propertyConfig.getValue()));
                    appliedProperties.add(propertyConfig.getName());
                    log.debug((Object)("set " + bean.getClass().getName() + " " + propertyConfig.getName() + "=" + TextUtils.replaceClasspathVariables(propertyConfig.getValue())));
                }
                catch (InvocationTargetException t) {
                    log.error((Object)("unable to set property name=" + propertyConfig.getName() + " value=" + propertyConfig.getValue() + " on object of class " + bean.getClass().getName() + ": " + t.getCause().getMessage()), t.getCause());
                }
            }
        }
    }

    public static class DebugClassLoader
    extends URLClassLoader {
        public DebugClassLoader(URL[] arg0) {
            super(arg0);
        }

        public DebugClassLoader(URL[] arg0, ClassLoader arg1) {
            super(arg0, arg1);
        }

        public DebugClassLoader(URL[] arg0, ClassLoader arg1, URLStreamHandlerFactory arg2) {
            super(arg0, arg1, arg2);
        }

        protected synchronized Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
            if (arg0.equals("fr.dyade.aaa.jndi2.client.NamingContextFactory")) {
                log.debug((Object)("loadClass(" + arg0 + ", " + arg1 + ") from " + this.toString()));
            }
            return super.loadClass(arg0, arg1);
        }

        public String toString() {
            StringBuffer rval = new StringBuffer();
            rval.append("DebugClassLoader: ");
            for (int i = 0; i < this.getURLs().length; ++i) {
                URL url = this.getURLs()[i];
                rval.append(url.toString());
                if (i == this.getURLs().length - 1) continue;
                rval.append(", ");
            }
            if (this.getParent() instanceof DebugClassLoader) {
                rval.append(", parent=" + this.getParent().toString());
            }
            return rval.toString();
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

