/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.oracle.aq;

import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.ext.oracle.aq.AQAdmin;
import hermes.ext.oracle.aq.AQConnectionFactory;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsSession;
import org.apache.log4j.Logger;

public class OracleAQAdminFactory
implements HermesAdminFactory {
    public static final String VERSION_STR = "$Header: /cvs/Integration/dev-tools/rib-aq-hermes-impl/src/hermes/ext/oracle/aq/OracleAQAdminFactory.java,v 1.1 2009/02/06 03:00:18 polavap Exp $";
    private static final Logger LOG = Logger.getLogger(OracleAQAdminFactory.class);
    private AQjmsSession session;

    @Override
    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException, NamingException {
        AQConnectionFactory aqFactory = null;
        if (!(connectionFactory instanceof AQConnectionFactory)) {
            throw new HermesException("Provider is not Oracle AQ");
        }
        aqFactory = (AQConnectionFactory)connectionFactory;
        LOG.debug((Object)("Connection string URL " + aqFactory.getUrl()));
        LOG.debug((Object)("JMS ConnectionFactory implementation class is " + hermes.getConnection().getClass()));
        AQjmsConnection aqJMS = (AQjmsConnection)hermes.getConnection();
        this.session = (AQjmsSession)aqJMS.createSession(false, 1);
        LOG.debug((Object)("Creating AQjmsSession session " + this.session));
        LOG.debug((Object)("Underlying database connection is " + this.session.getDBConnection()));
        AQAdmin ribAQ = new AQAdmin(hermes, this.session);
        return ribAQ;
    }
}

