/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.grid.SortableTable;
import hermes.Hermes;
import hermes.HermesRuntimeException;
import hermes.browser.actions.BrowserAction;
import hermes.browser.components.MessageHeaderTableSupport;
import hermes.browser.model.MessageHeaderTableModel;
import hermes.swing.HideableTableColumn;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class MessageHeaderTable
extends SortableTable {
    private static final Logger log = Logger.getLogger(MessageHeaderTable.class);
    private DataFlavor[] myFlavours;
    private Map<String, HideableTableColumn> userPropertyColumns = new HashMap<String, HideableTableColumn>();
    private Hermes hermes;

    public MessageHeaderTable(Hermes hermes, BrowserAction action, MessageHeaderTableModel model) {
        super((TableModel)model);
        this.hermes = hermes;
        MessageHeaderTableSupport.init(action, this, this.myFlavours);
        this.setDragEnabled(true);
    }

    public void onDoubleClick() {
    }

    private void checkForProperties(Message message) {
        try {
            Enumeration e = message.getPropertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (this.userPropertyColumns.containsKey(propertyName)) continue;
                HideableTableColumn column = new HideableTableColumn();
                column.setHeaderValue(propertyName);
                this.getColumnModel().addColumn(column);
                MessageHeaderTableModel model = (MessageHeaderTableModel)this.getModel();
            }
        }
        catch (JMSException e) {
            throw new HermesRuntimeException((Exception)((Object)e));
        }
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        return MessageHeaderTableSupport.prepareRenderer(super.prepareRenderer(renderer, row, column), (JTable)((Object)this), renderer, row, column);
    }

    public String getToolTipText(MouseEvent event) {
        return super.getToolTipText(event);
    }
}

