/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.util;

import uk.ac.shef.wit.simmetrics.similaritymetrics.DiceSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaccardSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Jaro;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import uk.ac.shef.wit.simmetrics.similaritymetrics.MongeElkan;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class SimStringStrategyFactory {
    private SimStringStrategyFactory() {
    }

    public static InterfaceStringMetric createSimStringStrategy(SimStringStrategy strategyType) {
        switch (strategyType) {
            case DICE_COEFF: {
                return new DiceSimilarity();
            }
            case JARO: {
                return new Jaro();
            }
            case JAROWINKLER: {
                return new JaroWinkler();
            }
            case LEVENSTHEIN: {
                return new Levenshtein();
            }
            case JACCARD: {
                return new JaccardSimilarity();
            }
            case MONGEELKAN: {
                return new MongeElkan();
            }
            case QGRAMS: {
                return new QGramsDistance();
            }
        }
        throw new IllegalArgumentException("No valid SimStringStrategyType!");
    }

    public static enum SimStringStrategy {
        DICE_COEFF,
        JARO,
        JAROWINKLER,
        LEVENSTHEIN,
        JACCARD,
        MONGEELKAN,
        QGRAMS;

    }
}

