/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete;

import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.base.AbstractDetectionFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AbstractDetectionInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.EncryptionInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractRefElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class XMLEncryptionFilter
extends AbstractDetectionFilter {
    public XMLEncryptionFilter(DetectFilterEnum filterType) {
        this.mFilterType = filterType;
        this.m_OutputFilter = new EncryptionInfo(filterType);
    }

    @Override
    public AbstractDetectionInfo process() {
        try {
            if (this.m_InputFilter != null) {
                this.detectEncryptedKeyElement();
                this.detectEncryptedDataElement();
            } else {
                LOG.info((Object)"Could not find any Input-File.");
            }
        }
        catch (XPathExpressionException ex) {
            LOG.error((Object)ex);
        }
        return (EncryptionInfo)this.m_OutputFilter;
    }

    private void detectEncryptedKeyElement() throws XPathExpressionException {
        List encryptedKeyList = DomUtilities.evaluateXPath((Document)this.m_InputFilter, (String)"//*[local-name()='EncryptedKey' and namespace-uri()='http://www.w3.org/2001/04/xmlenc#']");
        if (0 < encryptedKeyList.size()) {
            for (Element enc : encryptedKeyList) {
                if (this.detectIsEncryptedKeyInEncryptedData(enc)) continue;
                ((EncryptionInfo)this.m_OutputFilter).addEncryptedKeyElements(new EncryptedKeyElement(enc));
            }
        } else {
            LOG.info((Object)"Could not find any EncryptedKey Elements.");
        }
    }

    private void detectEncryptedDataElement() throws XPathExpressionException {
        List encryptedDataList = DomUtilities.evaluateXPath((Document)this.m_InputFilter, (String)"//*[local-name()='EncryptedData' and namespace-uri()='http://www.w3.org/2001/04/xmlenc#']");
        if (0 < encryptedDataList.size()) {
            this.filterEncDataWithoutExternEncKey(encryptedDataList);
        } else {
            LOG.info((Object)"Could not find any EncryptedData Elements.");
        }
    }

    private void filterEncDataWithoutExternEncKey(List<Element> encryptedDataList) {
        List<EncryptedKeyElement> encKeyList = ((EncryptionInfo)this.m_OutputFilter).getEncryptedKeyElements();
        if (0 < encKeyList.size()) {
            for (int i = 0; encryptedDataList.size() > i; ++i) {
                Element refEncData = encryptedDataList.get(i);
                boolean isEncKeyData = false;
                block1: for (int j = 0; encKeyList.size() > j && !isEncKeyData; ++j) {
                    List<AbstractRefElement> refListEl = encKeyList.get(j).getReferenceElementList();
                    for (int k = 0; refListEl.size() > k; ++k) {
                        if (!refListEl.get(k).getReferredElement().isEqualNode(refEncData)) continue;
                        isEncKeyData = true;
                        continue block1;
                    }
                }
                if (isEncKeyData) continue;
                EncryptedDataElement encData = new EncryptedDataElement(refEncData);
                ((EncryptionInfo)this.m_OutputFilter).addEncryptedDataElements(encData);
                this.checkEncKeyInEncData(encData);
            }
        } else {
            for (Element enc : encryptedDataList) {
                EncryptedDataElement encData = new EncryptedDataElement(enc);
                this.checkEncKeyInEncData(encData);
                ((EncryptionInfo)this.m_OutputFilter).addEncryptedDataElements(encData);
                LOG.info((Object)"Added EncryptedData without extern EncryptedKey.");
            }
        }
    }

    private void checkEncKeyInEncData(EncryptedDataElement encData) {
        EncryptedKeyElement encKey;
        if (null != encData.getKeyInfoElement() && null != (encKey = encData.getKeyInfoElement().getEncryptedKeyElement())) {
            encKey.setEnwrapEncData(encData);
        }
    }

    private boolean detectIsEncryptedKeyInEncryptedData(Element enc) {
        Node parentNode;
        String namespaceURI = enc.lookupNamespaceURI(enc.getPrefix());
        List refElement = DomUtilities.findChildren((Node)enc, (String)"ReferenceList", (String)namespaceURI, (boolean)true);
        if (null != enc.getParentNode() && 0 == refElement.size() && enc.getParentNode().getLocalName().equals("KeyInfo") && null != (parentNode = enc.getParentNode().getParentNode()) && parentNode.getLocalName().equals("EncryptedData")) {
            if (0 == refElement.size()) {
                LOG.info((Object)"EncKey inside EncData without referencelist detected.");
                return true;
            }
            LOG.error((Object)"EncKey inside EncData with referencelist detected.");
            return false;
        }
        return false;
    }
}

