/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1;

import wsattacker.library.xmlencryptionattack.attackengine.attacker.pkcs1.PKCS1AttackConfig;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.mode.AbstractOracleBehaviour;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.OracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.concrete.pkcs1.strategy.AbstractPKCS1Strategy;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionmanager.DetectFilterEnum;
import wsattacker.library.xmlencryptionattack.detectionengine.detectionstreams.DetectionReport;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.AvoidedDocErrorInfo;
import wsattacker.library.xmlencryptionattack.detectionengine.filter.info.TimestampInfo;
import wsattacker.library.xmlencryptionattack.util.ServerSendCommandIF;

public class PKCS1Oracle
extends AOracle {
    private AbstractPKCS1Strategy m_PKCS1Strategy;

    public PKCS1Oracle(DetectionReport detectRep, AbstractOracleBehaviour oracleBehave, ServerSendCommandIF serverSendCmnd, PKCS1AttackConfig attackCfg) {
        if (null == oracleBehave) {
            throw new IllegalArgumentException("Type of oracle not set!");
        }
        if (null == attackCfg) {
            throw new IllegalArgumentException("PKCS1AttackCfg not set");
        }
        AvoidedDocErrorInfo wrapInfo = (AvoidedDocErrorInfo)detectRep.getDetectionInfo(DetectFilterEnum.AVOIDDOCFILTER);
        this.m_OracleBehaviour = oracleBehave;
        this.m_InputFile = detectRep.getRawFile();
        this.m_AvoidedFile = wrapInfo.getAvoidedDocument();
        this.m_AttackPayload = wrapInfo.getOriginalPayInput();
        this.m_ServerCommand = serverSendCmnd;
        this.m_PublicKey = attackCfg.getServerRSAPubKey();
        this.m_AttackedAlgoritm = wrapInfo.getAlgoOfSymmtricBlockCipher();
        this.m_TimestampInfo = (TimestampInfo)detectRep.getDetectionInfo(DetectFilterEnum.TIMESTAMPFILTER);
    }

    @Override
    public OracleResponse[] sendRequests(OracleRequest[] request) {
        return null;
    }

    @Override
    public void setResponseValidity(OracleResponse response, OracleResponse.Result result) {
        response.setResult(result);
    }

    @Override
    public OracleResponse queryOracle(OracleRequest request) {
        OracleResponse respMaxScore = null;
        respMaxScore = this.m_PKCS1Strategy.handleRequest(this.m_ServerCommand, request);
        ++this.numberOfQueries;
        return respMaxScore;
    }

    public AbstractPKCS1Strategy getPKCS1Strategy() {
        return this.m_PKCS1Strategy;
    }

    public void setPKCS1Strategy(AbstractPKCS1Strategy pkcs1Strategy) {
        this.m_PKCS1Strategy = pkcs1Strategy;
    }
}

