/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http.proxy;

import flex.messaging.FlexContext;
import flex.messaging.log.Log;
import flex.messaging.services.http.proxy.ProxyContext;
import flex.messaging.services.http.proxy.ProxyException;
import flex.messaging.services.http.proxy.ProxyFilter;
import flex.messaging.services.http.proxy.ResponseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.OptionsMethod;

public class ResponseFilter
extends ProxyFilter {
    public static int RESPONSE_CHUNK = 4096;
    private static final int STATUS_ERROR = 10708;
    private static final int NULL_RESPONSE_STREAM = 10709;
    private static final int CANNOT_STREAM_NOT_HTTP = 10710;
    private static final int ERROR_WRITING_RESPONSE = 10711;

    public void invoke(ProxyContext context) {
        if (this.next != null) {
            this.next.invoke(context);
        }
        this.checkStatusCode(context);
        this.copyCookiesFromEndpoint(context);
        this.copyHeadersFromEndpoint(context);
        this.recordResponseHeaders(context);
        this.setupResponse(context);
    }

    protected void checkStatusCode(ProxyContext context) {
        int statusCode = context.getStatusCode();
        if (statusCode >= 400 && statusCode != 401 & statusCode != 403 && !context.isSoapRequest()) {
            StatusLine statusLine = context.getHttpMethod().getStatusLine();
            String reason = null;
            if (statusLine != null) {
                reason = statusLine.toString();
            }
            if (reason == null || "".equals(reason)) {
                reason = "" + statusCode;
            }
            ProxyException pe = new ProxyException();
            pe.setMessage(10708, new Object[]{reason});
            pe.setCode("Server.Proxy.Request.Failed");
            pe.setDetails(10708, "1", new Object[]{reason});
            throw pe;
        }
    }

    protected void copyCookiesFromEndpoint(ProxyContext context) {
        HttpServletResponse clientResponse = FlexContext.getHttpResponse();
        if (clientResponse != null) {
            Cookie[] cookies = context.getHttpClient().getState().getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                String domain = cookies[i].getDomain();
                String path = cookies[i].getPath();
                String name = cookies[i].getName();
                String value = cookies[i].getValue();
                String clientName = ResponseUtil.getCookieName(context, path, name, domain);
                if (Log.isInfo()) {
                    String str = "-- Cookie in response: domain = '" + domain + "', path = '" + path + "', client name = '" + clientName + "', endpoint name = '" + name + "', value = '" + value;
                    Log.getLogger((String)"Service.HTTP").debug(str);
                }
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(clientName, value);
                Date expiry = cookies[i].getExpiryDate();
                if (expiry != null) {
                    int maxAge = (int)((expiry.getTime() - System.currentTimeMillis()) / 1000L);
                    cookie.setMaxAge(maxAge);
                }
                cookie.setSecure(cookies[i].getSecure());
                cookie.setPath("/");
                clientResponse.addCookie(cookie);
            }
        }
    }

    protected void copyHeadersFromEndpoint(ProxyContext context) {
        HttpServletResponse clientResponse = FlexContext.getHttpResponse();
        if (clientResponse != null) {
            Header[] headers = context.getHttpMethod().getResponseHeaders();
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                String name = header.getName();
                String value = header.getValue();
                if (ResponseUtil.ignoreHeader(name, context) || name == null || value == null) continue;
                clientResponse.addHeader(name, value);
                if (!Log.isInfo()) continue;
                Log.getLogger((String)"Service.HTTP").debug("-- Header in response: " + name + " : " + value);
            }
            clientResponse.setHeader("Pragma", "public");
        }
    }

    protected void recordResponseHeaders(ProxyContext context) {
        String method = context.getMethod();
        if (context.getRecordHeaders() || "HEAD".equals(method)) {
            Header[] headers = context.getHttpMethod().getResponseHeaders();
            HashMap<String, Object> responseHeaders = new HashMap<String, Object>();
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                String headerName = header.getName();
                String headerValue = header.getValue();
                Object existingHeaderValue = responseHeaders.get(headerName);
                if (existingHeaderValue != null) {
                    ArrayList headerValues;
                    if (existingHeaderValue instanceof String) {
                        headerValues = new ArrayList();
                        headerValues.add(existingHeaderValue);
                        headerValues.add(headerValue);
                        responseHeaders.put(headerName, headerValues);
                        continue;
                    }
                    if (!(existingHeaderValue instanceof ArrayList)) continue;
                    headerValues = (ArrayList)existingHeaderValue;
                    headerValues.add(headerValue);
                    continue;
                }
                responseHeaders.put(headerName, headerValue);
            }
            context.setResponseHeaders(responseHeaders);
        }
    }

    protected void setupResponse(ProxyContext context) {
        String method = context.getMethod();
        HttpMethodBase httpMethod = context.getHttpMethod();
        if ("POST".equals(method)) {
            this.writeResponse(context);
        } else if ("GET".equals(method)) {
            this.writeResponse(context);
        } else if ("OPTIONS".equals(method)) {
            OptionsMethod optionsMethod = (OptionsMethod)httpMethod;
            Enumeration options = optionsMethod.getAllowedMethods();
            if (options != null) {
                ArrayList ops = new ArrayList();
                while (options.hasMoreElements()) {
                    Object option = options.nextElement();
                    ops.add(option);
                }
                Object[] o = ops.toArray();
                context.setResponse(o);
            }
        } else if ("TRACE".equals(method)) {
            this.writeResponse(context);
        } else if (!"DELETE".equals(method)) {
            if ("HEAD".equals(method)) {
                context.setResponse(context.getResponseHeaders());
            } else if ("PUT".equals(method)) {
                // empty if block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeResponse(ProxyContext context) {
        try {
            InputStream in = context.getHttpMethod().getResponseBodyAsStream();
            if (in == null) {
                throw new ProxyException(10709);
            }
            int length = (int)context.getHttpMethod().getResponseContentLength();
            if (context.streamResponseToClient()) {
                HttpServletResponse clientResponse = FlexContext.getHttpResponse();
                if (clientResponse == null) throw new ProxyException(10710);
                ServletOutputStream out = clientResponse.getOutputStream();
                if (length != -1) {
                    clientResponse.setContentLength(length);
                }
                this.writeStreamedResponse(in, (OutputStream)out, context);
                return;
            } else {
                this.writeResponseAsString(in, length, context);
            }
            return;
        }
        catch (IOException ioe) {
            ProxyException pe = new ProxyException();
            pe.setMessage(10711, new Object[]{ioe.getMessage()});
            throw pe;
        }
    }

    protected void writeStreamedResponse(InputStream inStream, OutputStream out, ProxyContext context) throws IOException {
        byte[] tmp = new byte[RESPONSE_CHUNK];
        int i = 0;
        while ((i = inStream.read(tmp)) >= 0) {
            out.write(tmp, 0, i);
        }
    }

    protected void writeResponseAsString(InputStream inStream, int length, ProxyContext context) throws IOException {
        char[] tmp = new char[RESPONSE_CHUNK];
        StringBuffer sb = new StringBuffer(length < 0 ? 16 : length);
        BufferedInputStream bufferedIn = new BufferedInputStream(inStream);
        String charset = context.getHttpMethod().getResponseCharSet();
        bufferedIn.mark(4);
        boolean hasBOM = false;
        int read = bufferedIn.read();
        if (read > 0) {
            if (239 == (read & 0xFF)) {
                read = bufferedIn.read();
                if (187 == (read & 0xFF) && 191 == ((read = bufferedIn.read()) & 0xFF)) {
                    hasBOM = true;
                    charset = "UTF-8";
                }
            } else if (255 == (read & 0xFF)) {
                read = bufferedIn.read();
                if (254 == (read & 0xFF)) {
                    hasBOM = true;
                    charset = "UTF16-LE";
                    bufferedIn.mark(2);
                    read = bufferedIn.read();
                    if (0 == (read & 0xFF)) {
                        read = bufferedIn.read();
                        if (0 == (read & 0xFF)) {
                            charset = "UTF32-LE";
                        } else {
                            bufferedIn.reset();
                        }
                    } else {
                        bufferedIn.reset();
                    }
                }
            } else if (254 == (read & 0xFF)) {
                read = bufferedIn.read();
                if (255 == (read & 0xFF)) {
                    hasBOM = true;
                    charset = "UTF16-BE";
                }
            } else if (0 == (read & 0xFF) && 0 == ((read = bufferedIn.read()) & 0xFF) && 254 == ((read = bufferedIn.read()) & 0xFF) && 255 == ((read = bufferedIn.read()) & 0xFF)) {
                hasBOM = true;
                charset = "UTF32-BE";
            }
            if (!hasBOM) {
                bufferedIn.reset();
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bufferedIn, charset));
        int charactersRead = -1;
        while ((charactersRead = reader.read(tmp, 0, tmp.length)) >= 0) {
            sb.append(new String(tmp, 0, charactersRead));
        }
        context.setResponse(sb.toString());
    }
}

