/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.net.MalformedURLException;
import net.sourceforge.htmlunit.corejs.javascript.Context;

public class HTMLBodyElement
extends HTMLElement {
    private static final long serialVersionUID = -915040139319661419L;

    public void createEventHandlerFromAttribute(String attributeName, String value) {
        if (attributeName.toLowerCase().startsWith("on")) {
            this.createEventHandler(attributeName, value);
        }
    }

    public void setDefaults(ComputedCSSStyleDeclaration style) {
        if (this.getBrowserVersion().isIE()) {
            style.setDefaultLocalStyleAttribute("margin", "15px 10px");
            style.setDefaultLocalStyleAttribute("padding", "0px");
        } else {
            style.setDefaultLocalStyleAttribute("margin-left", "8px");
            style.setDefaultLocalStyleAttribute("margin-right", "8px");
            style.setDefaultLocalStyleAttribute("margin-top", "8px");
            style.setDefaultLocalStyleAttribute("margin-bottom", "8px");
        }
    }

    public HTMLElement jsxGet_offsetParent() {
        return null;
    }

    public String jsxGet_aLink() {
        String aLink = this.getDomNodeOrDie().getAttribute("aLink");
        if (aLink == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().isFirefox()) {
            aLink = "#ee0000";
        }
        return aLink;
    }

    public void jsxSet_aLink(String aLink) {
        this.setColorAttribute("aLink", aLink);
    }

    public String jsxGet_background() {
        HtmlElement node = this.getDomNodeOrDie();
        String background = node.getAttribute("background");
        if (background != DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().isFirefox()) {
            try {
                HtmlPage page = (HtmlPage)node.getPage();
                background = page.getFullyQualifiedUrl(background).toExternalForm();
            }
            catch (MalformedURLException e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        return background;
    }

    public void jsxSet_background(String background) {
        this.getDomNodeOrDie().setAttribute("background", background);
    }

    public String jsxGet_bgColor() {
        String bgColor = this.getDomNodeOrDie().getAttribute("bgColor");
        if (bgColor == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().isFirefox()) {
            bgColor = "#ffffff";
        }
        return bgColor;
    }

    public void jsxSet_bgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    public String jsxGet_link() {
        String link = this.getDomNodeOrDie().getAttribute("link");
        if (link == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().isFirefox()) {
            link = "#0000ee";
        }
        return link;
    }

    public void jsxSet_link(String link) {
        this.setColorAttribute("link", link);
    }

    public String jsxGet_text() {
        String text = this.getDomNodeOrDie().getAttribute("text");
        if (text == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().isFirefox()) {
            text = "#000000";
        }
        return text;
    }

    public void jsxSet_text(String text) {
        this.setColorAttribute("text", text);
    }

    public String jsxGet_vLink() {
        String vLink = this.getDomNodeOrDie().getAttribute("vLink");
        if (vLink == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().isFirefox()) {
            vLink = "#551a8b";
        }
        return vLink;
    }

    public void jsxSet_vLink(String vLink) {
        this.setColorAttribute("vLink", vLink);
    }
}

