/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.xmlutilities.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import wsattacker.library.xmlutilities.namespace.NamespaceResolver;

public final class DomUtilities {
    private static final Logger LOG = Logger.getLogger(DomUtilities.class);
    private static final String YES = "yes";

    public static String getFastXPath(Node node) {
        Element ele;
        StringBuffer buf = new StringBuffer();
        switch (node.getNodeType()) {
            case 1: {
                ele = (Element)node;
                break;
            }
            case 2: {
                buf.append("/@");
                buf.append(node.getNodeName());
                buf.append("=\"");
                buf.append(node.getTextContent());
                buf.append('\"');
                ele = ((Attr)node).getOwnerElement();
                break;
            }
            case 3: {
                buf.append("/text()");
                ele = (Element)node.getParentNode();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Node '%s' is of Type %s", node.getNodeName(), node.getNodeType()));
            }
        }
        int index = DomUtilities.getElementIndex(ele);
        buf.append(ele.getNodeName() + "[" + index + "]");
        for (Node parent = ele.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
            index = DomUtilities.getElementIndex((Element)parent);
            buf.insert(0, parent.getNodeName() + "[" + index + "]/");
        }
        buf.insert(0, "/");
        return buf.toString();
    }

    public static int getElementIndex(Element ele) {
        int index = 1;
        for (Node prev = ele.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev.getNodeType() != 1 || !((Element)prev).getNodeName().equals(ele.getNodeName())) continue;
            ++index;
        }
        return index;
    }

    public static List<String> nodelistToFastXPathList(List<? extends Node> nodelist) {
        ArrayList<String> fastXPathList = new ArrayList<String>();
        for (Node node : nodelist) {
            fastXPathList.add(DomUtilities.getFastXPath(node));
        }
        return fastXPathList;
    }

    public static List<? extends Node> evaluateXPath(Document doc, String path) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NamespaceResolver(doc));
        XPathExpression expr = xpath.compile(path);
        NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<Node> nodelist = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            nodelist.add(nodes.item(i));
        }
        LOG.trace((Object)String.format("Evaluated XPath: %s and found %s", path, DomUtilities.nodeListToString(nodelist)));
        return nodelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Element> findElementByWsuId(Document doc, String id) {
        String xpath = String.format("//attribute::*[local-name()='Id' and namespace-uri()='%s' and string()='%s']/parent::node()", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", id);
        ArrayList<Element> result = new ArrayList();
        try {
            result = DomUtilities.evaluateXPath(doc, xpath);
            LOG.trace((Object)String.format("### WSU IDs found ### \n%s", DomUtilities.nodelistToFastXPathList(result)));
        }
        catch (XPathExpressionException e) {
            LOG.warn((Object)String.format("BAD XPath: %s", xpath));
        }
        return result;
    }

    public static List<Attr> findAttributeByValue(Document doc, String attributeValue) {
        ArrayList<Attr> returnedElements = new ArrayList();
        String xpath = String.format("//attribute::*[string()='%s']", attributeValue);
        try {
            returnedElements = DomUtilities.evaluateXPath(doc, xpath);
            LOG.trace((Object)String.format("### Element with Attribute '%s' ### \n%s", attributeValue, DomUtilities.nodelistToFastXPathList(returnedElements)));
        }
        catch (XPathExpressionException e) {
            LOG.warn((Object)String.format("BAD XPATH: %s", xpath));
        }
        return returnedElements;
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling;
        for (sibling = node.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    public static List<Element> findChildren(Node parent, String localname, String namespaceuri) {
        return DomUtilities.findChildren(parent, localname, namespaceuri, false);
    }

    public static List<Element> findChildren(Node parent, String localname, String namespaceuri, boolean deep) {
        ArrayList<Element> matches = new ArrayList<Element>();
        DomUtilities.findChildren(matches, parent, localname, namespaceuri, deep);
        return matches;
    }

    public static List<Element> getAllChildElements(Element ele) {
        return DomUtilities.getAllChildElements(ele, false);
    }

    public static List<Element> getAllChildElements(Element ele, boolean recursive) {
        ArrayList<Element> list = new ArrayList<Element>();
        return DomUtilities.getAllChildElements(ele, recursive, list);
    }

    public static Document createDomDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(String.format("%s.createDomDucment() could not instantiate DocumentBuilderFactory. This should never happen", DomUtilities.class.getName()), e);
        }
        return doc;
    }

    public static Document createNewDomFromNode(Node toClone) {
        Document newDoc = DomUtilities.createDomDocument();
        Node importedNode = newDoc.importNode(toClone, true);
        newDoc.appendChild(importedNode);
        return newDoc;
    }

    public static Document readDocument(String filename) throws FileNotFoundException, SAXException, IOException {
        File file = new File(filename);
        return DomUtilities.readDocument(file);
    }

    public static Document readDocument(File file) throws FileNotFoundException, SAXException, IOException {
        return DomUtilities.readDocument(new FileInputStream(file));
    }

    public static Document readDocument(URL url) throws SAXException, IOException {
        URLConnection con = url.openConnection();
        con.setConnectTimeout(1000);
        con.setReadTimeout(1000);
        con.setUseCaches(true);
        return DomUtilities.readDocument(url.openStream());
    }

    public static Document readDocument(InputStream is) throws SAXException, IOException {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = fac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(String.format("%s.readDocument() could not instantiate DocumentBuilderFactory. This should never happen", DomUtilities.class.getName()), e);
        }
        return builder.parse(is);
    }

    public static void writeDocument(Document doc, String filename) {
        DomUtilities.writeDocument(doc, filename, false);
    }

    public static void writeDocument(Document doc, String filename, boolean prettyPrint) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            if (prettyPrint) {
                trans.setOutputProperty("omit-xml-declaration", YES);
                trans.setOutputProperty("indent", YES);
            }
            trans.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(filename)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Document stringToDom(String xmlString) throws SAXException {
        Document dom;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        StringReader reader = new StringReader(xmlString);
        InputSource input = new InputSource(reader);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(String.format("%s.stringToDom() could not instantiate DocumentBuilderFactory. This should never happen", DomUtilities.class.getName()), e);
        }
        try {
            dom = builder.parse(input);
        }
        catch (IOException e) {
            dom = DomUtilities.createDomDocument();
        }
        return dom;
    }

    public static String domToString(Document domDoc) {
        return DomUtilities.domToString(domDoc.getDocumentElement(), false);
    }

    public static String domToString(Document domDoc, boolean prettyPrint) {
        return DomUtilities.domToString(domDoc.getDocumentElement(), prettyPrint);
    }

    public static String domToString(Node n) {
        return DomUtilities.domToString(n, false);
    }

    public static String domToString(Node n, boolean prettyPrint) {
        StringWriter output = new StringWriter();
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", YES);
            if (prettyPrint) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.setOutputProperty("indent", YES);
            }
            transformer.transform(new DOMSource(n), new StreamResult(output));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("%s.domToString() throws an Exception. This should never happen", DomUtilities.class.getName()), e);
        }
        return output.toString();
    }

    public static String showOnlyImportant(Document doc) {
        return DomUtilities.showOnlyImportant(doc.getDocumentElement());
    }

    public static String showOnlyImportant(Node node) {
        return DomUtilities.showOnlyImportant(DomUtilities.domToString(node, true));
    }

    public static String showOnlyImportant(String xml) {
        String[] tasks;
        for (String task : tasks = new String[]{"ds:KeyInfo", "ds:SignatureValue", "ds:SignedInfo"}) {
            String endString;
            int end;
            int start = xml.indexOf("<" + task);
            while (start >= 0 && (end = xml.indexOf(endString = "/" + task + ">", start + 1)) > 0) {
                xml = xml.substring(0, start) + "<" + task + "/>" + xml.substring(end + endString.length());
                start = xml.indexOf("<" + task);
            }
        }
        String nsOpen = " xmlns:";
        int start = xml.indexOf(nsOpen);
        while (start >= 0) {
            int nextWhitespace = xml.indexOf(32, start + 1);
            int nextClose = xml.indexOf(62, start + 1);
            if (nextClose < nextWhitespace && nextClose >= 0) {
                xml = xml.substring(0, start) + xml.substring(nextClose);
            } else {
                if (nextWhitespace < 0) break;
                xml = xml.substring(0, start) + xml.substring(nextWhitespace);
            }
            start = xml.indexOf(nsOpen);
        }
        return xml;
    }

    public static String nodeListToString(List<? extends Node> list) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        if (list.size() > 0) {
            buf.append("\n  0 : [" + DomUtilities.domToString(list.get(0)) + "]");
            for (int i = 1; i < list.size(); ++i) {
                buf.append("\n  " + i + " : [" + DomUtilities.domToString(list.get(0)) + "]");
            }
            buf.append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public static Element findCorrespondingElement(Document doc, Element element) {
        ArrayList<Element> parentElements = new ArrayList<Element>();
        ArrayList<Integer> parentIndex = new ArrayList<Integer>();
        for (Node theParent = element; theParent != null && theParent.getNodeType() == 1; theParent = theParent.getParentNode()) {
            parentElements.add((Element)theParent);
            parentIndex.add(DomUtilities.getElementIndex(theParent));
        }
        Element ret = doc.getDocumentElement();
        if (ret.isSameNode(element.getOwnerDocument().getDocumentElement())) {
            LOG.warn((Object)"No different Root Nodes");
        }
        for (int i = parentElements.size() - 2; i >= 0; --i) {
            List<Element> children;
            Element child = (Element)parentElements.get(i);
            int index = (Integer)parentIndex.get(i);
            if (index > (children = DomUtilities.findChildren(ret, child.getLocalName(), child.getNamespaceURI())).size()) {
                for (int j = 0; j < index - children.size(); ++j) {
                    Node imported = doc.importNode(child, false);
                    ret.appendChild(imported);
                }
                children = DomUtilities.findChildren(ret, child.getLocalName(), child.getNamespaceURI());
            }
            ret = children.get(index - 1);
        }
        return ret;
    }

    public static String getNamespaceURI(Node node, String searchPrefix) {
        return node.lookupNamespaceURI(searchPrefix);
    }

    public static String getPrefix(Node node, String searchNamespaceURI) {
        String prefix = node.isDefaultNamespace(searchNamespaceURI) ? "" : node.lookupPrefix(searchNamespaceURI);
        return prefix;
    }

    public static Element getFirstChildElementByNames(Element startElement, String ... localname) {
        Element foundElement = startElement;
        for (int i = 0; i < localname.length; ++i) {
            String tmp = localname[i];
            try {
                foundElement = DomUtilities.findChildren(foundElement, tmp, null, false).get(0);
                continue;
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("Could not find Element with name '%s' (%d Parameter)", tmp, i));
            }
        }
        return foundElement;
    }

    private static void findChildren(List<Element> result, Node parent, String localname, String namespaceuri, boolean deep) {
        Node n;
        int i;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("From %s find children %s with URI %s%s", parent.getNodeName(), localname, namespaceuri, deep ? " DEEP" : " nondeep"));
        }
        NodeList children = parent.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            n = children.item(i);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found Child: " + children.item(i).getNodeName()));
            }
            if (n == null || n.getNodeType() != 1 || localname != null && !n.getLocalName().equals(localname) || namespaceuri != null && !n.getNamespaceURI().equals(namespaceuri)) continue;
            result.add((Element)n);
        }
        for (i = 0; i < children.getLength(); ++i) {
            n = children.item(i);
            if (!deep || n.getNodeType() != 1) continue;
            DomUtilities.findChildren(result, n, localname, namespaceuri, deep);
        }
    }

    private static List<Element> getAllChildElements(Element ele, boolean recursive, List<Element> list) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            list.add((Element)n);
            if (!recursive) continue;
            DomUtilities.getAllChildElements((Element)n, recursive, list);
        }
        return list;
    }

    private DomUtilities() {
    }
}

